/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.service.datascope;

import cn.smarthse.modules.health.enums.datascope.DataScopeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperatorType;
import net.sf.jsqlparser.expression.operators.relational.RegExpMySQLOperator;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SelectSQLParser {
    private DataScopeEnum scopeEnum;
    private List<Long> orgIdList;
    private String loginStaffId;
    private String mainTableName;
    private String orgTableName = "company_organization";
    private String orgColumnAlias = "org_id";
    private String orderByStr = "";
    private String createBy = "create_by";
    public static final String KEEP_ORDERBY = "/*keep orderby*/";

    private SelectSQLParser() {
    }

    public SelectSQLParser(DataScopeEnum scopeEnum, List<Long> orgIdList, String loginStaffId, String mainTableName, String orgColumnAlias) {
        this.loginStaffId = loginStaffId;
        this.mainTableName = mainTableName;
        if (StringUtils.isNotBlank((String)orgColumnAlias)) {
            this.orgColumnAlias = orgColumnAlias;
        }
        this.scopeEnum = scopeEnum;
        this.orgIdList = orgIdList;
    }

    public SelectBody getSelectBodyBySQL(String sql) {
        Statement stmt = null;
        try {
            stmt = CCJSqlParserUtil.parse((String)sql);
        }
        catch (Throwable e) {
            return null;
        }
        Select select = (Select)stmt;
        SelectBody selectBody = select.getSelectBody();
        return selectBody;
    }

    public String getSmartSql(String sql) {
        if (StringUtils.isBlank((String)this.mainTableName)) {
            return this.getSimpleDataSql(sql);
        }
        SelectBody selectBody = this.getSelectBodyBySQL(sql);
        if (selectBody == null) {
            return this.getSimpleDataSql(sql);
        }
        try {
            this.processSelectBody(selectBody);
        }
        catch (Exception e) {
            return this.getSimpleDataSql(sql);
        }
        String result = selectBody.toString();
        return result;
    }

    public String getSimpleDataSql(String sql) {
        StringBuilder stringBuilder = new StringBuilder(sql.length() + 400);
        SelectBody selectBody = this.getSelectBodyBySQL(sql);
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            this.processOrderFiled(plainSelect);
            List orderByElements = plainSelect.getOrderByElements();
            if (!this.orderByHashParameters(plainSelect.getOrderByElements())) {
                plainSelect.setOrderByElements(null);
            }
            stringBuilder.append("select * from (");
            stringBuilder.append(plainSelect.toString());
            stringBuilder.append(") _datascopet where 1=1 ");
            if (this.scopeEnum.equals((Object)DataScopeEnum.PERSONAL)) {
                stringBuilder.append(" and _datascopet." + this.createBy + " = " + this.loginStaffId);
            } else if (this.scopeEnum.equals((Object)DataScopeEnum.DEPARTMENT) && CollectionUtils.isNotEmpty(this.orgIdList)) {
                stringBuilder.append(" and (");
                stringBuilder.append(" _datascopet." + this.orgColumnAlias + " regexp '" + StringUtils.join(this.orgIdList, (String)"|") + "'");
                stringBuilder.append(" or  _datascopet." + this.createBy + " = " + this.loginStaffId);
                stringBuilder.append(" ) ");
            }
            if (CollectionUtils.isNotEmpty((Collection)orderByElements)) {
                stringBuilder.append(" order by ");
                for (int i = 0; i < orderByElements.size(); ++i) {
                    OrderByElement orderByElement;
                    String orderField;
                    if (i != 0) {
                        stringBuilder.append(",");
                    }
                    if ((orderField = (orderByElement = (OrderByElement)orderByElements.get(i)).toString()).indexOf(".") > -1) {
                        stringBuilder.append("_datascopet" + orderField.substring(orderField.indexOf(".")));
                        continue;
                    }
                    stringBuilder.append("_datascopet." + orderField);
                }
            }
        } else {
            stringBuilder.append("select * from (");
            stringBuilder.append(sql);
            stringBuilder.append(") _datascopet where 1=1 ");
            if (this.scopeEnum.equals((Object)DataScopeEnum.PERSONAL)) {
                stringBuilder.append(" and _datascopet." + this.createBy + " = " + this.loginStaffId);
            } else if (this.scopeEnum.equals((Object)DataScopeEnum.DEPARTMENT) && CollectionUtils.isNotEmpty(this.orgIdList)) {
                stringBuilder.append(" and (");
                stringBuilder.append(" _datascopet." + this.orgColumnAlias + " regexp '" + StringUtils.join(this.orgIdList, (String)"|") + "'");
                stringBuilder.append(" or  _datascopet." + this.createBy + " = " + this.loginStaffId);
                stringBuilder.append(" ) ");
            }
            if (StringUtils.isNotBlank((String)this.getOrderByStr())) {
                stringBuilder.append(" order by " + this.getOrderByStr());
            }
        }
        return stringBuilder.toString();
    }

    private void processOrderFiled(PlainSelect plainSelect) {
        List selectItems = plainSelect.getSelectItems();
        HashSet<String> selectFieldSet = new HashSet<String>();
        for (SelectItem item : selectItems) {
            if (item instanceof SelectExpressionItem) {
                SelectExpressionItem selectExpressionItem = (SelectExpressionItem)item;
                Expression expression = selectExpressionItem.getExpression();
                String expressionStr = expression.toString();
                selectFieldSet.add(expressionStr.toLowerCase());
                continue;
            }
            selectFieldSet.add(item.toString().toLowerCase());
        }
        List orderByElements = plainSelect.getOrderByElements();
        ArrayList<String> orderByFieldList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)orderByElements)) {
            for (int i = 0; i < orderByElements.size(); ++i) {
                OrderByElement orderByElement = (OrderByElement)orderByElements.get(i);
                boolean addOderField2Select = this.addOderField2Select(selectFieldSet, orderByElement.getExpression().toString());
                if (!addOderField2Select) continue;
                orderByFieldList.add(orderByElement.getExpression().toString());
            }
        }
        if (CollectionUtils.isNotEmpty(orderByFieldList)) {
            for (String orderByField : orderByFieldList) {
                SelectExpressionItem selectExpressionItem = new SelectExpressionItem();
                selectExpressionItem.setExpression((Expression)new Column(orderByField));
                selectItems.add(selectExpressionItem);
            }
            plainSelect.setSelectItems(selectItems);
        }
    }

    public boolean addOderField2Select(Set<String> selectFieldSet, String orderFiled) {
        String tableAlias;
        orderFiled = orderFiled.toLowerCase();
        if (selectFieldSet.contains("*")) {
            return false;
        }
        if (selectFieldSet.contains(orderFiled)) {
            return false;
        }
        return orderFiled.indexOf(".") <= -1 || !selectFieldSet.contains((tableAlias = orderFiled.substring(0, orderFiled.indexOf("."))) + ".*");
    }

    public void processSelectBody(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            if (withItem.getSubSelect().getSelectBody() != null) {
                this.processSelectBody(withItem.getSubSelect().getSelectBody());
            }
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                List plainSelects = operationList.getSelects();
                for (SelectBody plainSelect : plainSelects) {
                    this.processSelectBody(plainSelect);
                }
            }
            if (!this.orderByHashParameters(operationList.getOrderByElements())) {
                operationList.setOrderByElements(null);
            }
        }
    }

    public void processPlainSelect(PlainSelect plainSelect) {
        if (plainSelect.getFromItem() != null) {
            this.processFromItem(plainSelect.getFromItem());
        }
        if (plainSelect.getJoins() != null && plainSelect.getJoins().size() > 0) {
            List joins = plainSelect.getJoins();
            for (Join join : joins) {
                if (join.getRightItem() == null) continue;
                this.processFromItem(join.getRightItem());
            }
        }
        Table mianTable = this.getTableByName(plainSelect, this.mainTableName);
        Table orgTable = null;
        if (mianTable != null) {
            String mianTableName = "";
            mianTableName = mianTable.getAlias() != null && StringUtils.isNotBlank((String)mianTable.getAlias().getName()) ? mianTable.getAlias().getName() : mianTable.getName();
            this.addDataScopeWhereExpression(plainSelect, mianTableName, orgTable);
        }
    }

    public void addDataScopeWhereExpression(PlainSelect plainSelect, String mainTableName, Table orgTable) {
        Expression where;
        String tempOrgTableName = this.orgTableName;
        if (orgTable != null && orgTable.getAlias() != null && StringUtils.isNotBlank((String)orgTable.getAlias().getName())) {
            tempOrgTableName = orgTable.getAlias().getName();
        }
        if ((where = plainSelect.getWhere()) == null) {
            EqualsTo nullwhere = new EqualsTo();
            nullwhere.setLeftExpression((Expression)new LongValue(1L));
            nullwhere.setRightExpression((Expression)new LongValue(1L));
            where = nullwhere;
        }
        EqualsTo staffEq = new EqualsTo();
        staffEq.setLeftExpression((Expression)new Column(mainTableName + "." + this.getCreateBy()));
        staffEq.setRightExpression((Expression)new LongValue(this.loginStaffId));
        if (this.scopeEnum.equals((Object)DataScopeEnum.DEPARTMENT)) {
            RegExpMySQLOperator regExpMySQLOperator = new RegExpMySQLOperator(RegExpMatchOperatorType.NOT_MATCH_CASEINSENSITIVE);
            regExpMySQLOperator.setLeftExpression((Expression)new Column(mainTableName + ".org_id"));
            regExpMySQLOperator.setRightExpression((Expression)new StringValue(StringUtils.join(this.orgIdList, (String)"|")));
            OrExpression orgPersonExpress = new OrExpression((Expression)regExpMySQLOperator, (Expression)staffEq);
            Parenthesis parenthesis = new Parenthesis((Expression)orgPersonExpress);
            AndExpression andExpression = new AndExpression(where, (Expression)parenthesis);
            plainSelect.setWhere((Expression)andExpression);
        }
        if (this.scopeEnum.equals((Object)DataScopeEnum.PERSONAL)) {
            AndExpression andExpression = new AndExpression(where, (Expression)staffEq);
            plainSelect.setWhere((Expression)andExpression);
        }
    }

    public Table getTableByName(PlainSelect plainSelect, String tableName) {
        Table fromTable;
        tableName = tableName.toLowerCase();
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table && StringUtils.isNotBlank((String)(fromTable = (Table)fromItem).getName()) && fromTable.getName().toLowerCase().equals(tableName)) {
            return fromTable;
        }
        if (plainSelect.getJoins() != null && plainSelect.getJoins().size() > 0) {
            List joins = plainSelect.getJoins();
            for (Join join : joins) {
                Table rightTable;
                FromItem rightItem;
                if (join.getRightItem() == null || !((rightItem = join.getRightItem()) instanceof Table) || !StringUtils.isNotBlank((String)(rightTable = (Table)rightItem).getName()) || !rightTable.getName().toLowerCase().equals(tableName)) continue;
                return rightTable;
            }
        }
        return null;
    }

    public void processWithItemsList(List<WithItem> withItemsList) {
        if (withItemsList != null && withItemsList.size() > 0) {
            for (WithItem item : withItemsList) {
                this.processSelectBody(item.getSubSelect().getSelectBody());
            }
        }
    }

    public void processFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (subJoin.getJoinList() != null && subJoin.getJoinList().size() > 0) {
                for (Join join : subJoin.getJoinList()) {
                    if (join.getRightItem() == null) continue;
                    this.processFromItem(join.getRightItem());
                }
            }
            if (subJoin.getLeft() != null) {
                this.processFromItem(subJoin.getLeft());
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (!(fromItem instanceof ValuesList) && fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody());
        }
    }

    public boolean orderByHashParameters(List<OrderByElement> orderByElements) {
        if (orderByElements == null) {
            return false;
        }
        for (OrderByElement orderByElement : orderByElements) {
            if (!orderByElement.toString().contains("?")) continue;
            return true;
        }
        return false;
    }

    public String getOrderByStr() {
        return this.orderByStr;
    }

    public void setOrderByStr(String orderByStr) {
        this.orderByStr = orderByStr;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getLoginStaffId() {
        return this.loginStaffId;
    }

    public void setLoginStaffId(String loginStaffId) {
        this.loginStaffId = loginStaffId;
    }
}

