/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.service.datascope;

import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.framework.service.datascope.DataScopeUtils;
import cn.smarthse.common.framework.service.datascope.SelectSQLParser;
import cn.smarthse.modules.health.entity.datascope.DataScope;
import cn.smarthse.modules.health.enums.datascope.DataScopeEnum;
import com.github.pagehelper.Dialect;
import com.github.pagehelper.PageException;
import com.github.pagehelper.cache.Cache;
import com.github.pagehelper.cache.CacheFactory;
import com.github.pagehelper.util.ExecutorUtil;
import com.github.pagehelper.util.MSUtils;
import com.github.pagehelper.util.StringUtil;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class PageDataScopeInterceptor
implements Interceptor {
    private volatile Dialect dialect;
    private String countSuffix = "_COUNT";
    protected Cache<String, MappedStatement> msCountMap = null;
    private String default_dialect_class = "com.github.pagehelper.PageHelper";
    private Field additionalParametersField;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        try {
            List resultList;
            Byte dataScope;
            CacheKey cacheKey;
            BoundSql boundSql;
            Object[] args = invocation.getArgs();
            MappedStatement ms = (MappedStatement)args[0];
            Object parameter = args[1];
            RowBounds rowBounds = (RowBounds)args[2];
            ResultHandler resultHandler = (ResultHandler)args[3];
            Executor executor = (Executor)invocation.getTarget();
            if (args.length == 4) {
                boundSql = ms.getBoundSql(parameter);
                cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
            } else {
                cacheKey = (CacheKey)args[4];
                boundSql = (BoundSql)args[5];
            }
            this.checkDialectExists();
            DataScope dataScope1 = DataScopeHelper.getDataScope();
            if (dataScope1 != null && (dataScope = DataScopeUtils.getDataScope(dataScope1.getModelName(), dataScope1.getLoginStaffId())) != null && dataScope != 1) {
                if (CollectionUtils.isEmpty((Collection)dataScope1.getOrgIdList())) {
                    dataScope = DataScopeEnum.PERSONAL.getCode();
                }
                DataScopeEnum dataScopeEnum = DataScopeEnum.getDataScopeEnum((Byte)dataScope);
                String dataScopeSQL = boundSql.getSql();
                SelectSQLParser selectSQLParser = new SelectSQLParser(dataScopeEnum, dataScope1.getOrgIdList(), dataScope1.getLoginStaffId(), dataScope1.getMainTableName(), dataScope1.getOrgColumnAlias());
                if (StringUtils.isNotBlank((String)dataScope1.getOrderByStr())) {
                    selectSQLParser.setOrderByStr(dataScope1.getOrderByStr());
                }
                if (StringUtils.isNotBlank((String)dataScope1.getCreateBy())) {
                    selectSQLParser.setCreateBy(dataScope1.getCreateBy());
                }
                if ("company.org".equals(dataScope1.getModelName())) {
                    if (StringUtils.isNotBlank((String)dataScope1.getOrgId())) {
                        selectSQLParser.setLoginStaffId(dataScope1.getOrgId());
                    } else {
                        selectSQLParser.setLoginStaffId("-1");
                    }
                }
                String smartCountSql = selectSQLParser.getSmartSql(dataScopeSQL);
                Map additionalParameters = (Map)this.additionalParametersField.get(boundSql);
                boundSql = new BoundSql(ms.getConfiguration(), smartCountSql, boundSql.getParameterMappings(), parameter);
                for (String key : additionalParameters.keySet()) {
                    boundSql.setAdditionalParameter(key, additionalParameters.get(key));
                }
                DataScopeHelper.clearDataScope();
            }
            if (!this.dialect.skip(ms, parameter, rowBounds)) {
                Long count;
                if (this.dialect.beforeCount(ms, parameter, rowBounds) && !this.dialect.afterCount((count = this.count(executor, ms, parameter, rowBounds, resultHandler, boundSql)).longValue(), parameter, rowBounds)) {
                    Object object = this.dialect.afterPage(new ArrayList(), parameter, rowBounds);
                    return object;
                }
                resultList = ExecutorUtil.pageQuery((Dialect)this.dialect, (Executor)executor, (MappedStatement)ms, (Object)parameter, (RowBounds)rowBounds, (ResultHandler)resultHandler, (BoundSql)boundSql, (CacheKey)cacheKey);
            } else {
                resultList = executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
            }
            Object object = this.dialect.afterPage(resultList, parameter, rowBounds);
            return object;
        }
        finally {
            if (this.dialect != null) {
                this.dialect.afterAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDialectExists() {
        if (this.dialect == null) {
            String string = this.default_dialect_class;
            synchronized (string) {
                if (this.dialect == null) {
                    this.setProperties(new Properties());
                }
            }
        }
    }

    private Long count(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        Long count;
        String countMsId = ms.getId() + this.countSuffix;
        MappedStatement countMs = ExecutorUtil.getExistedMappedStatement((Configuration)ms.getConfiguration(), (String)countMsId);
        if (countMs != null) {
            count = ExecutorUtil.executeManualCount((Executor)executor, (MappedStatement)countMs, (Object)parameter, (BoundSql)boundSql, (ResultHandler)resultHandler);
        } else {
            countMs = (MappedStatement)this.msCountMap.get((Object)countMsId);
            if (countMs == null) {
                countMs = MSUtils.newCountMappedStatement((MappedStatement)ms, (String)countMsId);
                this.msCountMap.put((Object)countMsId, (Object)countMs);
            }
            count = ExecutorUtil.executeAutoCount((Dialect)this.dialect, (Executor)executor, (MappedStatement)countMs, (Object)parameter, (BoundSql)boundSql, (RowBounds)rowBounds, (ResultHandler)resultHandler);
        }
        return count;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.msCountMap = CacheFactory.createCache((String)properties.getProperty("msCountCache"), (String)"ms", (Properties)properties);
        String dialectClass = properties.getProperty("dialect");
        if (StringUtil.isEmpty((String)dialectClass)) {
            dialectClass = this.default_dialect_class;
        }
        try {
            Class<?> aClass = Class.forName(dialectClass);
            this.dialect = (Dialect)aClass.newInstance();
        }
        catch (Exception e) {
            throw new PageException((Throwable)e);
        }
        this.dialect.setProperties(properties);
        try {
            this.additionalParametersField = BoundSql.class.getDeclaredField("additionalParameters");
            this.additionalParametersField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        String countSuffix = properties.getProperty("countSuffix");
        if (StringUtil.isNotEmpty((String)countSuffix)) {
            this.countSuffix = countSuffix;
        }
    }
}

