/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.service.datascope;

import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.datascope.DataScope;
import cn.smarthse.modules.health.enums.datascope.DataScopeEnum;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataScopeUtils {
    private static Logger logger = LoggerFactory.getLogger(DataScopeUtils.class);
    private static String DATASCOPE_MCACHE = "hse_memory_datascopeInfo";
    private static ISysUserService sysUserService = (ISysUserService)SpringContextHolder.getBean(ISysUserService.class);
    private static Map<Long, Map<String, Byte>> dataMap = new ConcurrentHashMap<Long, Map<String, Byte>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Byte getDataScope(String permissionCode, String loginStaffId) {
        String mapKey = permissionCode + loginStaffId;
        if (StringUtils.isNumber((String)loginStaffId)) {
            long staffId = Long.parseLong(loginStaffId);
            if (dataMap.containsKey(staffId)) {
                Map<String, Byte> stringByteMap = dataMap.get(staffId);
                return stringByteMap.get(mapKey);
            }
            Object stringByteMap = DataScopeUtils.class;
            synchronized (DataScopeUtils.class) {
                if (!dataMap.containsKey(staffId)) {
                    Page localPage = PageHelper.getLocalPage();
                    PageHelper.clearPage();
                    DataScope dataScope = DataScopeHelper.getDataScope();
                    DataScopeHelper.clearDataScope();
                    List allDataScope = sysUserService.getAllDataScopeInfo(Long.valueOf(staffId));
                    if (localPage != null) {
                        PageHelper.startPage((int)localPage.getPageNum(), (int)localPage.getPageSize());
                    }
                    if (dataScope != null) {
                        DataScopeHelper.setDataScope(dataScope);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)allDataScope)) {
                        Map<String, Byte> datascopeMap = allDataScope.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getPermissionCode()) && f.getScope() != null).collect(Collectors.toMap(a -> a.getPermissionCode(), v -> v.getScope(), (v1, v2) -> v2));
                        dataMap.put(staffId, datascopeMap);
                    }
                }
                // ** MonitorExit[stringByteMap] (shouldn't be in output)
                if (dataMap.containsKey(staffId)) {
                    stringByteMap = dataMap.get(staffId);
                    return (Byte)stringByteMap.get(mapKey);
                }
            }
        } else {
            logger.error("loginStaffId:{}, \u53c2\u6570\u9519\u8bef", (Object)loginStaffId);
        }
        return null;
    }

    public static boolean isPersonDataScope(String permissionCode, String loginStaffId) {
        Byte dataScope = DataScopeUtils.getDataScope(permissionCode, loginStaffId);
        return dataScope != null && DataScopeEnum.PERSONAL.getCode() == dataScope;
    }

    public static void clearCache() {
        dataMap.clear();
    }
}

