/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.service.datascope;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.datascope.DataScope;
import com.alibaba.dubbo.rpc.RpcContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DataScopeHelper
implements AutoCloseable {
    private static final ThreadLocal<DataScope> LOCAL_DATASCOPE = new ThreadLocal();

    public static void setDataScope(DataScope datascope) {
        LOCAL_DATASCOPE.set(datascope);
    }

    public static DataScope getDataScope() {
        return LOCAL_DATASCOPE.get();
    }

    public static void clearDataScope() {
        LOCAL_DATASCOPE.remove();
    }

    public static DataScope startDataScope(String permissionCode) {
        return DataScopeHelper.startDataScope(permissionCode, "", "");
    }

    public static DataScope startDataScope(String permissionCode, String mainTableName) {
        return DataScopeHelper.startDataScope(permissionCode, mainTableName, "");
    }

    public static DataScope startDataScope(String permissionCode, String mainTableName, String orgColName) {
        RpcContext context = RpcContext.getContext();
        String loginStaffId = context.getAttachment("_loginStaffId");
        String orgIds = context.getAttachment("_orgIds");
        String orgId = context.getAttachment("_orgId");
        if (StringUtils.isNotBlank((CharSequence)loginStaffId) && StringUtils.isNotBlank((CharSequence)permissionCode)) {
            DataScope data = new DataScope();
            List<Object> orgIdList = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)orgIds)) {
                orgIdList = Arrays.stream(StringUtils.splitByWholeSeparatorPreserveAllTokens((String)orgIds, (String)",")).filter(s -> StringUtils.isNumeric((CharSequence)s)).map(s -> {
                    s = s.trim();
                    return Long.parseLong(s);
                }).collect(Collectors.toList());
            }
            data.setOrgIdList(orgIdList);
            data.setOrgId(orgId);
            data.setOrgColumnAlias(orgColName);
            data.setMainTableName(mainTableName);
            data.setModelName(permissionCode);
            data.setLoginStaffId(loginStaffId);
            context.clearAttachments();
            DataScopeHelper.setDataScope(data);
            return data;
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        DataScopeHelper.clearDataScope();
    }
}

