/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.redis.seria;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;

public class LongSerializer
extends JsonSerializer<Long> {
    public static final LongSerializer instance = new LongSerializer();

    public void serialize(Long value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        if (gen.getOutputContext().inArray()) {
            gen.writeStartArray();
            gen.writeString(Long.class.getName());
            gen.writeNumber(value.longValue());
            gen.writeEndArray();
        } else if (gen.getOutputContext().getParent() == null) {
            gen.writeStartObject();
            gen.writeStringField("@class", Long.class.getName());
            gen.writeNumberField("value", value.longValue());
            gen.writeEndObject();
        } else {
            gen.writeString(value.toString());
        }
    }

    public void serializeWithType(Long value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(value, gen, serializers);
    }
}

