/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.redis.seria;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

public class LongDeserializer
extends JsonDeserializer<Long> {
    public static final LongDeserializer instance = new LongDeserializer();

    public Long deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode valueNode;
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (p.getCurrentToken() == JsonToken.START_ARRAY) {
            p.nextToken();
            String typeName = p.getText();
            p.nextToken();
            if (Long.class.getName().equals(typeName)) {
                long value = p.getLongValue();
                p.nextToken();
                return value;
            }
        } else if (node.isObject() && node.has("@class") && node.has("value")) {
            JsonNode classNode = node.get("@class");
            JsonNode valueNode2 = node.get("value");
            if (classNode.isTextual() && (valueNode2.isNumber() || valueNode2.isTextual())) {
                String className = classNode.asText();
                if (Long.class.getName().equals(className)) {
                    try {
                        return valueNode2.asLong();
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("\u975e\u6570\u503c\u53cd\u5e8f\u5217\u5316: " + e.getMessage());
                    }
                }
            }
        } else if (node.has("value") && ((valueNode = node.get("value")).isNumber() || valueNode.isTextual())) {
            try {
                return valueNode.asLong();
            }
            catch (NumberFormatException e) {
                throw new IOException("\u975e\u6570\u503c\u53cd\u5e8f\u5217\u5316: " + e.getMessage());
            }
        }
        try {
            return node.asLong();
        }
        catch (NumberFormatException e) {
            throw new IOException("\u975e\u6570\u503c\u53cd\u5e8f\u5217\u5316: " + e.getMessage());
        }
    }
}

