/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.redis.config;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.redis.keyresolver.DefaultRedisKeyResolver;
import cn.smarthse.common.framework.redis.keyresolver.RedisKeyResolver;
import cn.smarthse.common.framework.redis.keyresolver.RedisKeyResolverSerializer;
import cn.smarthse.common.framework.redis.seria.LongDeserializer;
import cn.smarthse.common.framework.redis.seria.LongSerializer;
import cn.smarthse.framework.redis.config.properties.RedissonProperties;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import lombok.Generated;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

@AutoConfiguration
@EnableCaching(proxyTargetClass=true)
@EnableConfigurationProperties(value={RedissonProperties.class})
public class RedisTemplateConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisTemplateConfig.class);
    private static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String TIME_PATTERN = "HH:mm:ss";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");

    public ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        JavaTimeModule timeModule = new JavaTimeModule();
        timeModule.addSerializer((JsonSerializer)new LocalDateTimeSerializer(DATE_TIME_FORMATTER));
        timeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DATE_TIME_FORMATTER));
        timeModule.addSerializer((JsonSerializer)new LocalDateSerializer(DATE_FORMATTER));
        timeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DATE_FORMATTER));
        timeModule.addSerializer((JsonSerializer)new LocalTimeSerializer(TIME_FORMATTER));
        timeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(TIME_FORMATTER));
        timeModule.addSerializer(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
        timeModule.addSerializer(BigDecimal.class, (JsonSerializer)ToStringSerializer.instance);
        SimpleModule longModule = new SimpleModule();
        longModule.addSerializer(Long.class, (JsonSerializer)LongSerializer.instance);
        longModule.addDeserializer(Long.class, (JsonDeserializer)LongDeserializer.instance);
        objectMapper.registerModule((Module)timeModule);
        objectMapper.registerModule((Module)longModule);
        objectMapper.setTimeZone(TimeZone.getDefault());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        objectMapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        return objectMapper;
    }

    @Bean
    public RedisKeyResolver redisKeyResolver(RedissonProperties properties) {
        return new DefaultRedisKeyResolver(properties);
    }

    @Bean
    @Primary
    public RedisTemplate<?, ?> stringRedisTemplateT(RedisConnectionFactory factory, RedisKeyResolver templateKeyResolver) {
        log.info("\u521d\u59cb\u5316 redisTemplate stringRedisTemplate \u914d\u7f6e");
        RedisTemplate redisTemplate = new RedisTemplate();
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(this.objectMapper(), Object.class);
        RedisKeyResolverSerializer keySerializer = new RedisKeyResolverSerializer((RedisSerializer<String>)RedisSerializer.string(), templateKeyResolver);
        redisTemplate.setKeySerializer((RedisSerializer)keySerializer);
        redisTemplate.setConnectionFactory(factory);
        redisTemplate.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    @Bean
    @Primary
    public RedisClient getRedisClient(RedissonClient redissonClient, RedisTemplate redisTemplate) {
        return new RedisClient(redissonClient, redisTemplate);
    }

    @Generated
    public RedisTemplateConfig() {
    }
}

