/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.ratelimit.interprecetor;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.ratelimit.config.RateLimitProperties;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateType;
import org.redisson.api.RedissonClient;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class RateLimitInterceptor
implements HandlerInterceptor {
    private RedissonClient redissonClient;
    private RateLimitProperties rateLimitProperties;

    public RateLimitInterceptor(RedissonClient redissonClient, RateLimitProperties rateLimitProperties) {
        this.redissonClient = redissonClient;
        this.rateLimitProperties = rateLimitProperties;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        RequestLimit methodAnnotation = method.getAnnotation(RequestLimit.class);
        RequestLimit classAnnotation = method.getDeclaringClass().getAnnotation(RequestLimit.class);
        if (ObjectUtil.isNotNull((Object)methodAnnotation) || ObjectUtil.isNotNull((Object)classAnnotation)) {
            return true;
        }
        int rate = this.rateLimitProperties.getDefaultRate();
        int rateInterval = this.rateLimitProperties.getDefaultRateInterval();
        int expireTime = this.rateLimitProperties.getDefaultExpireTime();
        String message = this.rateLimitProperties.getDefaultMessage();
        String key = "rate-limit:" + this.rateLimitProperties.getKey();
        RRateLimiter rateLimiter = this.redissonClient.getRateLimiter(key);
        if (!this.redissonClient.getBucket(key).isExists()) {
            rateLimiter.trySetRate(RateType.OVERALL, (long)rate, (long)rateInterval, RateIntervalUnit.SECONDS);
            if (expireTime > 0) {
                rateLimiter.expire((long)expireTime, TimeUnit.SECONDS);
            }
        }
        if (!rateLimiter.tryAcquire()) {
            throw new RuntimeException(message);
        }
        return true;
    }

    private String generateDefaultKey(HttpServletRequest request, Method method) {
        String ip = request.getRemoteAddr();
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        StringBuilder params = new StringBuilder();
        for (Class<?> paramType : method.getParameterTypes()) {
            params.append(paramType.getSimpleName()).append(",");
        }
        return String.format("rate_limit:%s:%s.%s(%s)", ip, className, methodName, params.length() > 0 ? params.substring(0, params.length() - 1) : "");
    }
}

