/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.prometheus.config;

import cn.smarthse.prometheus.collector.DruidDataSourceMetricsCollector;
import cn.smarthse.prometheus.collector.DubboThreadMetrics;
import cn.smarthse.prometheus.collector.JvmMetricsCollector;
import cn.smarthse.prometheus.collector.TomcatMetricsCollector;
import cn.smarthse.prometheus.property.PrometheusMonitorProperties;
import io.micrometer.core.instrument.MeterRegistry;
import org.apache.dubbo.common.utils.NetUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={PrometheusMonitorProperties.class})
@ConditionalOnProperty(prefix="management.prometheus", name={"enabled"}, havingValue="true")
public class PrometheusMonitorAutoConfiguration {
    private final PrometheusMonitorProperties properties;
    private final MeterRegistry meterRegistry;
    private final ApplicationContext applicationContext;

    public PrometheusMonitorAutoConfiguration(PrometheusMonitorProperties properties, MeterRegistry meterRegistry, ApplicationContext applicationContext) {
        this.properties = properties;
        this.meterRegistry = meterRegistry;
        this.applicationContext = applicationContext;
        String applicationId = applicationContext.getId();
        String localHost = NetUtils.getLocalHost();
        meterRegistry.config().commonTags(new String[]{"applicationName", applicationId, "hostAddress", localHost});
    }

    @Bean
    @ConditionalOnProperty(prefix="management.prometheus.jvm", name={"enabled"}, havingValue="true")
    public JvmMetricsCollector jvmMetricsCollector() {
        return new JvmMetricsCollector(this.meterRegistry, this.applicationContext);
    }

    @Bean
    @ConditionalOnWebApplication
    @ConditionalOnProperty(prefix="management.prometheus.tomcat", name={"enabled"}, havingValue="true")
    public TomcatMetricsCollector tomcatMetricsCollector() {
        return new TomcatMetricsCollector(this.meterRegistry, this.applicationContext);
    }

    @Bean
    @ConditionalOnProperty(prefix="management.prometheus.datasource", name={"enabled"}, havingValue="true")
    @ConditionalOnClass(name={"com.alibaba.druid.pool.DruidDataSource"})
    public DruidDataSourceMetricsCollector dataSourceMetricsCollector() {
        return new DruidDataSourceMetricsCollector(this.meterRegistry, this.applicationContext);
    }

    @Bean
    public DubboThreadMetrics getDubboThreadPoolMetricsCollector() {
        return new DubboThreadMetrics(this.meterRegistry);
    }
}

