/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.prometheus.config;

import cn.smarthse.prometheus.property.PrometheusMonitorProperties;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import io.micrometer.prometheusmetrics.PrometheusConfig;
import io.micrometer.prometheusmetrics.PrometheusMeterRegistry;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={PrometheusMonitorProperties.class})
@ConditionalOnProperty(prefix="management.prometheus", name={"enabled"}, havingValue="true")
public class PrometheusMetricsServerConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricsServerConfig.class);
    HttpServer server = null;

    public static String getCurrentIpAddress() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u672c\u673aIP\u5730\u5740", e);
        }
    }

    @Bean
    public PrometheusMeterRegistry prometheusMeterRegistry() {
        PrometheusMeterRegistry registry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        return registry;
    }

    private void sendUnauthorized(HttpExchange exchange, String message) throws IOException {
        exchange.getResponseHeaders().set("WWW-Authenticate", "Basic realm=\"Metrics\"");
        exchange.sendResponseHeaders(401, message.getBytes().length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(message.getBytes());
        }
    }

    @PreDestroy
    public void stopServer() {
        if (this.server != null) {
            this.server.stop(0);
            log.error("Prometheus metrics server stopped.");
        }
    }

    @Bean
    public HttpServer metricsHttpServer(PrometheusMeterRegistry registry, PrometheusMonitorProperties config) {
        String host = PrometheusMetricsServerConfig.getCurrentIpAddress();
        try {
            this.server = HttpServer.create(new InetSocketAddress(host, config.getEndpoint().getPort()), 0);
            this.server.createContext("/metrics", exchange -> {
                String password;
                String authHeader = exchange.getRequestHeaders().getFirst("Authorization");
                if (authHeader == null || !authHeader.startsWith("Basic ")) {
                    this.sendUnauthorized(exchange, "Missing Authorization header");
                    return;
                }
                String base64Credentials = authHeader.substring("Basic ".length());
                String credentials = new String(Base64.getDecoder().decode(base64Credentials), StandardCharsets.UTF_8);
                String[] parts = credentials.split(":", 2);
                String username = parts[0];
                String string = password = parts.length > 1 ? parts[1] : "";
                if (!Objects.equals(config.getEndpoint().getUsername(), username) || !Objects.equals(config.getEndpoint().getPassword(), password)) {
                    this.sendUnauthorized(exchange, "Invalid username or password");
                    return;
                }
                try {
                    String response = registry.scrape();
                    exchange.getResponseHeaders().set("Content-Type", "text/plain; charset=UTF-8");
                    byte[] responseBytes = response.getBytes(StandardCharsets.UTF_8);
                    exchange.sendResponseHeaders(200, responseBytes.length);
                    try (OutputStream os = exchange.getResponseBody();){
                        os.write(responseBytes);
                    }
                }
                catch (Exception e) {
                    log.error("Error scraping metrics: " + e.getMessage(), (Throwable)e);
                    try {
                        exchange.sendResponseHeaders(500, 0L);
                    }
                    catch (IOException ex) {
                        log.error("Failed to send error response: " + ex.getMessage(), (Throwable)ex);
                    }
                }
            });
            log.warn("\u542f\u52a8Prometheus \u6307\u6807\u76d1\u63a7 at http://{}:{}", (Object)host, (Object)config.getEndpoint().getPort());
            this.server.start();
        }
        catch (IOException e) {
            log.error("\u542f\u52a8Prometheus \u6307\u6807\u76d1\u63a7  at http://{}:{} \u5f02\u5e38", new Object[]{host, config.getEndpoint().getPort(), e});
        }
        return this.server;
    }
}

