/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.prometheus.collector;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.tomcat.TomcatMetrics;
import java.lang.management.ManagementFactory;
import java.util.Optional;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationContext;

public class TomcatMetricsCollector {
    private final MeterRegistry meterRegistry;
    private final ApplicationContext applicationContext;

    public TomcatMetricsCollector(MeterRegistry meterRegistry, ApplicationContext applicationContext) {
        this.meterRegistry = meterRegistry;
        this.applicationContext = applicationContext;
        this.registerMetrics();
    }

    private Context findContext(TomcatWebServer tomcatWebServer) {
        for (Container container : tomcatWebServer.getTomcat().getHost().findChildren()) {
            if (!(container instanceof Context)) continue;
            Context context = (Context)container;
            return context;
        }
        return null;
    }

    private Manager findManager(ApplicationContext applicationContext) {
        TomcatWebServer tomcatWebServer;
        Context context;
        WebServerApplicationContext webServerApplicationContext;
        WebServer webServer;
        if (applicationContext instanceof WebServerApplicationContext && (webServer = (webServerApplicationContext = (WebServerApplicationContext)applicationContext).getWebServer()) instanceof TomcatWebServer && (context = this.findContext(tomcatWebServer = (TomcatWebServer)webServer)) != null) {
            return context.getManager();
        }
        return null;
    }

    private void registerMetrics() {
        Manager manager = this.findManager(this.applicationContext);
        new TomcatMetrics(manager, null).bindTo(this.meterRegistry);
        Gauge.builder((String)"tomcat.connections.active.max", () -> this.getTomcatThreadPool().map(ThreadPool::getMaxThreads).orElse(0)).description("Maximum active connections").register(this.meterRegistry);
        Gauge.builder((String)"tomcat.connections.active.current", () -> this.getTomcatThreadPool().map(ThreadPool::getCurrentThreadsBusy).orElse(0)).description("Current active connections").register(this.meterRegistry);
    }

    private Optional<ThreadPool> getTomcatThreadPool() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("Tomcat:type=ThreadPool,name=*");
            Set<ObjectName> objectNames = mBeanServer.queryNames(objectName, null);
            if (!objectNames.isEmpty()) {
                ObjectName first = objectNames.iterator().next();
                return Optional.of(ManagementFactory.newPlatformMXBeanProxy(mBeanServer, first.getCanonicalName(), ThreadPool.class));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static interface ThreadPool {
        public int getMaxThreads();

        public int getCurrentThreadsBusy();
    }
}

