/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.prometheus.collector;

import cn.hutool.core.convert.Convert;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import org.redisson.api.RedissonClient;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;

public class RedissonMetricsCollector {
    private final MeterRegistry meterRegistry;
    private final RedissonClient redissonClient;

    public RedissonMetricsCollector(MeterRegistry meterRegistry, RedissonClient redissonClient) {
        this.meterRegistry = meterRegistry;
        this.redissonClient = redissonClient;
    }

    @PostConstruct
    public void init() {
        try {
            ConnectionManager connectionManager = this.getConnectionManagerViaReflection();
            this.registerPerNodeMetrics(connectionManager);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ConnectionManager getConnectionManagerViaReflection() throws Exception {
        try {
            Method getServiceManager = this.redissonClient.getClass().getMethod("getServiceManager", new Class[0]);
            Object serviceManager = getServiceManager.invoke((Object)this.redissonClient, new Object[0]);
            Method getConnectionManager = serviceManager.getClass().getMethod("getConnectionManager", new Class[0]);
            return (ConnectionManager)getConnectionManager.invoke(serviceManager, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                Field connectionManagerField = this.redissonClient.getClass().getDeclaredField("connectionManager");
                connectionManagerField.setAccessible(true);
                return (ConnectionManager)connectionManagerField.get(this.redissonClient);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to access ConnectionManager", ex);
            }
        }
    }

    private void registerPerNodeMetrics(ConnectionManager manager) {
        Collection entries = manager.getEntrySet();
        for (MasterSlaveEntry entry : entries) {
            ClientConnectionsEntry connEntry = entry.getEntry();
            String nodeId = entry.getClient().getAddr().toString();
            Gauge.builder((String)"redisson.connections.node_active", (Object)connEntry, c -> {
                int i = connEntry.getConnectionsHolder().getAllConnections().size() - connEntry.getConnectionsHolder().getFreeConnections().size();
                return Convert.toDouble((Object)i);
            }).tag("node", nodeId).description("\u8282\u70b9\u6d3b\u8dc3\u8fde\u63a5\u6570").baseUnit("connections").register(this.meterRegistry);
            Gauge.builder((String)"redisson.connections.node_idle", (Object)connEntry, c -> c.getConnectionsHolder().getFreeConnections().size()).tag("node", nodeId).description("\u8282\u70b9\u7a7a\u95f2\u8fde\u63a5\u6570").baseUnit("connections").register(this.meterRegistry);
            Gauge.builder((String)"redisson.connections.node_conns", (Object)connEntry, c -> c.getConnectionsHolder().getAllConnections().size()).tag("node", nodeId).description("\u8282\u70b9\u7b49\u5f85\u7ebf\u7a0b\u6570").baseUnit("threads").register(this.meterRegistry);
        }
    }
}

