/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.prometheus.collector;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import jakarta.annotation.PostConstruct;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;

public class JvmMetricsCollector
implements BeanPostProcessor {
    private final Map<String, String> monitoredExecutors = new ConcurrentHashMap<String, String>();
    private final MeterRegistry meterRegistry;
    private final ApplicationContext applicationContext;

    public JvmMetricsCollector(MeterRegistry meterRegistry, ApplicationContext applicationContext) {
        this.meterRegistry = meterRegistry;
        this.applicationContext = applicationContext;
        this.registerMetrics();
    }

    @PostConstruct
    public void init() {
        this.applicationContext.getBeansOfType(ExecutorService.class).forEach((name, t) -> this.monitorThreadPool((ExecutorService)t, (String)name));
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ExecutorService) {
            this.monitorThreadPool((ExecutorService)bean, beanName);
        }
        return bean;
    }

    private void registerCustomMetrics(ThreadPoolExecutor executor, String beanName) {
        Gauge.builder((String)"executor.pool.utilization", (Object)executor, e -> {
            int max = e.getMaximumPoolSize();
            return max > 0 ? (double)e.getActiveCount() / (double)max : 0.0;
        }).description("\u7ebf\u7a0b\u6c60\u5229\u7528\u7387 (0-1)").tags(new String[]{"executor.pool.name", beanName}).register(this.meterRegistry);
    }

    private void monitorThreadPool(ExecutorService threadPool, String beanName) {
        String identifier = beanName;
        if (this.monitoredExecutors.containsKey(identifier)) {
            return;
        }
        ExecutorServiceMetrics.monitor((MeterRegistry)this.meterRegistry, (ExecutorService)threadPool, (String)beanName, (Iterable)Tags.of((String[])new String[]{"executor.pool.name", beanName, "executor.pool.class", threadPool.getClass().getSimpleName()}));
        if (threadPool instanceof ThreadPoolExecutor) {
            this.registerCustomMetrics((ThreadPoolExecutor)threadPool, beanName);
        }
        this.monitoredExecutors.put(identifier, beanName);
    }

    private void registerMetrics() {
        new JvmMemoryMetrics().bindTo(this.meterRegistry);
        new JvmGcMetrics().bindTo(this.meterRegistry);
        new JvmThreadMetrics().bindTo(this.meterRegistry);
        new ClassLoaderMetrics().bindTo(this.meterRegistry);
        new ProcessorMetrics().bindTo(this.meterRegistry);
        new FileDescriptorMetrics().bindTo(this.meterRegistry);
        Gauge.builder((String)"jvm.memory.heap.usage", () -> ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed()).description("JVM heap memory usage in bytes").baseUnit("bytes").register(this.meterRegistry);
        Gauge.builder((String)"jvm.memory.nonheap.usage", () -> ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed()).description("JVM non-heap memory usage in bytes").baseUnit("bytes").register(this.meterRegistry);
        Gauge.builder((String)"process_uptime_seconds", () -> ManagementFactory.getRuntimeMXBean().getUptime() / 1000L).description("\u8fd0\u884c\u65f6\u957f").baseUnit("seconds").register(this.meterRegistry);
        Gauge.builder((String)"process_start_time_seconds", () -> ManagementFactory.getRuntimeMXBean().getStartTime() / 1000L).description("\u542f\u52a8\u65f6\u95f4").baseUnit("seconds").register(this.meterRegistry);
    }
}

