/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.prometheus.collector;

import com.alibaba.dubbo.common.Constants;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.store.DataStore;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.model.sample.CounterMetricSample;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.metrics.registry.collector.RegistryMetricsCollector;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public class DubboThreadMetrics
implements ApplicationRunner {
    private MeterRegistry meterRegistry;
    private final Iterable<Tag> TAG = Collections.singletonList(Tag.of((String)"thread.pool.name", (String)"dubboThreadPool"));

    public DubboThreadMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void init() {
        DataStore dataStore = (DataStore)ExtensionLoader.getExtensionLoader(DataStore.class).getDefaultExtension();
        Map executors = dataStore.get(Constants.EXECUTOR_SERVICE_COMPONENT_KEY);
        for (Map.Entry entry : executors.entrySet()) {
            ExecutorService executor = (ExecutorService)entry.getValue();
            if (!(executor instanceof ThreadPoolExecutor)) continue;
            ThreadPoolExecutor tp = (ThreadPoolExecutor)executor;
            Gauge.builder((String)"dubbo.thread.pool.core.size", (Object)tp, ThreadPoolExecutor::getCorePoolSize).description("\u6838\u5fc3\u7ebf\u7a0b\u6570").baseUnit("threads").register(this.meterRegistry);
            Gauge.builder((String)"dubbo.thread.pool.largest.size", (Object)tp, ThreadPoolExecutor::getLargestPoolSize).description("\u5386\u53f2\u6700\u9ad8\u7ebf\u7a0b\u6570").baseUnit("threads").register(this.meterRegistry);
            Gauge.builder((String)"dubbo.thread.pool.max.size", (Object)tp, ThreadPoolExecutor::getMaximumPoolSize).description("\u6700\u5927\u7ebf\u7a0b\u6570").baseUnit("threads").register(this.meterRegistry);
            Gauge.builder((String)"dubbo.thread.pool.active.size", (Object)tp, ThreadPoolExecutor::getActiveCount).description("\u6d3b\u8dc3\u7ebf\u7a0b\u6570").baseUnit("threads").register(this.meterRegistry);
            Gauge.builder((String)"dubbo.thread.pool.thread.count", (Object)tp, ThreadPoolExecutor::getPoolSize).description("\u5f53\u524d\u7ebf\u7a0b\u6570").baseUnit("threads").register(this.meterRegistry);
            Gauge.builder((String)"dubbo.thread.pool.queue.size", (Object)tp, e -> e.getQueue().size()).description("\u961f\u5217\u5927\u5c0f").baseUnit("threads").register(this.meterRegistry);
            Gauge.builder((String)"dubbo.thread.pool.taskCount", (Object)tp, ThreadPoolExecutor::getTaskCount).description("\u4efb\u52a1\u603b\u91cf").baseUnit("threads").register(this.meterRegistry);
            Gauge.builder((String)"dubbo.thread.pool.completedTaskCount", (Object)tp, ThreadPoolExecutor::getCompletedTaskCount).description("\u5df2\u5b8c\u6210\u7684\u4efb\u52a1\u91cf").baseUnit("threads").register(this.meterRegistry);
        }
        RegistryMetricsCollector r = new RegistryMetricsCollector(ApplicationModel.defaultModel());
        r.setCollectEnabled(Boolean.valueOf(true));
        List collect1 = r.collect();
        for (MetricSample metricSample : collect1) {
            System.out.println(metricSample.getDescription());
        }
        DefaultMetricsCollector defaultMetricsCollector = new DefaultMetricsCollector(ApplicationModel.defaultModel());
        defaultMetricsCollector.setCollectEnabled(Boolean.valueOf(true));
        defaultMetricsCollector.setThreadpoolCollectEnabled(true);
        List collect = defaultMetricsCollector.collect();
        for (MetricSample metricSample : collect) {
            Map tags = metricSample.getTags();
            ArrayList tagList = new ArrayList();
            if (tags != null && !tags.isEmpty()) {
                tags.forEach((key, value) -> tagList.add(Tag.of((String)key, (String)value)));
            }
            String name = metricSample.getName();
            String baseUnit = metricSample.getBaseUnit();
            String description = metricSample.getDescription();
            if (metricSample instanceof CounterMetricSample) {
                CounterMetricSample counter = (CounterMetricSample)metricSample;
                Gauge.builder((String)name, (Object)counter, ds -> ds.getValue().doubleValue()).tags(tagList).baseUnit(baseUnit).description(description).register(this.meterRegistry);
                continue;
            }
            if (!(metricSample instanceof GaugeMetricSample)) continue;
            GaugeMetricSample gauge = (GaugeMetricSample)metricSample;
            Gauge.builder((String)name, (Object)gauge, ds -> ds.applyAsDouble()).tags(tagList).baseUnit(baseUnit).description(description).register(this.meterRegistry);
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        this.init();
    }
}

