/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.prometheus.collector;

import com.alibaba.druid.pool.DruidAbstractDataSource;
import com.alibaba.druid.pool.DruidDataSource;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.TimeGauge;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.datasource.DelegatingDataSource;

public class DruidDataSourceMetricsCollector {
    private final MeterRegistry meterRegistry;
    private final ApplicationContext applicationContext;

    public DruidDataSourceMetricsCollector(MeterRegistry meterRegistry, ApplicationContext applicationContext) {
        this.meterRegistry = meterRegistry;
        this.applicationContext = applicationContext;
        this.registerMetrics();
    }

    private void registerMetrics() {
        Map dataSources = this.applicationContext.getBeansOfType(DataSource.class);
        dataSources.forEach((beanName, dataSource) -> {
            if (this.isDruidDataSource((DataSource)dataSource)) {
                this.bindDruidMetrics(this.unwrapDruidDataSource((DataSource)dataSource), (String)beanName);
            }
        });
    }

    private boolean isDruidDataSource(DataSource dataSource) {
        return dataSource instanceof DruidDataSource || dataSource instanceof DelegatingDataSource && ((DelegatingDataSource)dataSource).getTargetDataSource() instanceof DruidDataSource;
    }

    private DruidDataSource unwrapDruidDataSource(DataSource dataSource) {
        DataSource target;
        if (dataSource instanceof DruidDataSource) {
            return (DruidDataSource)dataSource;
        }
        if (dataSource instanceof DelegatingDataSource && (target = ((DelegatingDataSource)dataSource).getTargetDataSource()) instanceof DruidDataSource) {
            return (DruidDataSource)target;
        }
        throw new IllegalArgumentException("DataSource is not a DruidDataSource");
    }

    private void bindDruidMetrics(DruidDataSource dataSource, String beanName) {
        this.bindConnectionPoolMetrics(dataSource, beanName);
    }

    private void bindConnectionPoolMetrics(DruidDataSource dataSource, String beanName) {
        Gauge.builder((String)"druid.connections.active", (Object)dataSource, DruidDataSource::getActiveCount).tag("pool", beanName).description("\u6d3b\u52a8\u8fde\u63a5\u6570").register(this.meterRegistry);
        Gauge.builder((String)"druid.connections.idle", (Object)dataSource, DruidDataSource::getPoolingCount).tag("pool", beanName).description("\u7a7a\u95f2\u8fde\u63a5\u6570").register(this.meterRegistry);
        Gauge.builder((String)"druid.connections.max", (Object)dataSource, DruidAbstractDataSource::getMaxActive).tag("pool", beanName).description("\u6700\u5927\u8fde\u63a5\u6570").register(this.meterRegistry);
        Gauge.builder((String)"druid.connections.min_idle", (Object)dataSource, DruidAbstractDataSource::getMinIdle).tag("pool", beanName).description("\u6700\u5c0f\u7a7a\u95f2\u8fde\u63a5\u6570").register(this.meterRegistry);
        Gauge.builder((String)"druid.connections.waiting", (Object)dataSource, DruidDataSource::getWaitThreadCount).tag("pool", beanName).description("T\u7b49\u5f85\u7ebf\u7a0b\u6570").register(this.meterRegistry);
        Gauge.builder((String)"druid.connections.total", (Object)dataSource, ds -> ds.getActiveCount() + ds.getPoolingCount()).tag("pool", beanName).description("\u6c60\u4e2d\u8fde\u63a5\u603b\u6570").register(this.meterRegistry);
        Gauge.builder((String)"druid.connections.usage.ratio", (Object)dataSource, ds -> ds.getMaxActive() > 0 ? (double)ds.getActiveCount() / (double)ds.getMaxActive() : 0.0).tag("pool", beanName).description("\u8fde\u63a5\u4f7f\u7528\u7387").register(this.meterRegistry);
    }

    private void bindSqlExecutionMetrics(DruidDataSource dataSource, String beanName) {
        FunctionCounter.builder((String)"druid.sql.execute.count", (Object)dataSource, ds -> ds.getDataSourceStat().getStatementStat().getExecuteCount()).tag("pool", beanName).description("Total SQL statements executed").register(this.meterRegistry);
        TimeGauge.builder((String)"druid.sql.execute.time.total", (Object)dataSource, (TimeUnit)TimeUnit.MILLISECONDS, ds -> ds.getDataSourceStat().getStatementStat().getExecuteMillisTotal()).tag("pool", beanName).description("Total time spent executing SQL (ms)").register(this.meterRegistry);
        Gauge.builder((String)"druid.sql.execute.time.avg", (Object)dataSource, ds -> ds.getDataSourceStat().getStatementStat().getExecuteCount() > 0L ? (double)ds.getDataSourceStat().getStatementStat().getExecuteMillisTotal() / (double)ds.getDataSourceStat().getStatementStat().getExecuteCount() : 0.0).tag("pool", beanName).description("Average SQL execution time (ms)").register(this.meterRegistry);
    }
}

