/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.config;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.properties.OssClientProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={OssClientProperties.class})
@ConditionalOnProperty(prefix="ossclient", name={"oss_endpoint", "oss_accesskey", "oss_accesssecret"})
@AutoConfiguration
public class OssClientConfig {
    @Bean
    public OssClientBean ossClient(OssClientProperties ossClientProperties) {
        OssClientBean ossClientBean = new OssClientBean();
        ossClientBean.setEndpoint(ossClientProperties.getOss_endpoint());
        ossClientBean.setAccessKeyId(ossClientProperties.getOss_accesskey());
        ossClientBean.setAccessKeySecret(ossClientProperties.getOss_accesssecret());
        ossClientBean.setBucketName(ossClientProperties.getOss_bucketname());
        ossClientBean.setAsynch(ossClientProperties.isOss_asynch());
        ossClientBean.setDomain(ossClientProperties.getOss_domain());
        ossClientBean.setOssdir(ossClientProperties.getOssdir());
        ossClientBean.setExptime(ossClientProperties.getExptime());
        ossClientBean.setPublicread(ossClientProperties.isOss_publicread());
        return ossClientBean;
    }
}

