/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.beans;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.smarthse.common.framework.file.FileContentTypeUtils;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.ServletsUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.leak.SSRFLeakUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.ResponseHeaderOverrides;
import com.aliyun.oss.model.UploadPartRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssClientBean {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String FILE_NAME_POINT_STRING = ".";
    private String domain = "";
    private String endpoint = "";
    private String accessKeyId = "";
    private String accessKeySecret = "";
    private String bucketName = "";
    private boolean asynch = false;
    private int exptime = 7200;
    private OSS client = null;
    private boolean publicread = true;
    private String local = "";
    private String ossdir = "";
    private String adminPath = "";

    public String startMultipartUpload(String objectName) {
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(this.bucketName, objectName);
        InitiateMultipartUploadResult result = this.getClient().initiateMultipartUpload(request);
        return result.getUploadId();
    }

    public PartETag uploadPart(String objectName, String uploadId, int partNumber, InputStream inputStream, long partSize) {
        UploadPartRequest request = new UploadPartRequest(this.bucketName, objectName, uploadId, partNumber, inputStream, partSize);
        return this.getClient().uploadPart(request).getPartETag();
    }

    public void completeMultipartUpload(String objectName, String uploadId, List<PartETag> partETags) {
        CompleteMultipartUploadRequest request = new CompleteMultipartUploadRequest(this.bucketName, objectName, uploadId, partETags);
        this.getClient().completeMultipartUpload(request);
    }

    public String getUrl(String urlfile) {
        return this.getUrl(urlfile, null, this.exptime);
    }

    public String getUrl(String urlfile, String filename, int exptime) {
        if (StringUtils.isEmpty((CharSequence)urlfile)) {
            return "";
        }
        if (urlfile.indexOf("http://") >= 0 || urlfile.indexOf("https://") >= 0) {
            return urlfile;
        }
        if (this.isAsynch()) {
            if (this.publicread) {
                StringBuffer url = new StringBuffer();
                url.append("http://").append(this.bucketName).append(FILE_NAME_POINT_STRING).append(this.domain).append("/").append(urlfile);
                if (StringUtils.isNotEmpty((String)filename)) {
                    try {
                        filename = URLEncoder.encode(filename, "utf-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        this.logger.error("\u7f16\u7801\u9519\u8bef\uff1a" + e.getMessage());
                    }
                    url.append("?response-content-disposition=attachment;filename=" + filename);
                }
                return url.toString();
            }
            Date exp = DateUtils.addSecond((Date)new Date(), (int)exptime);
            URL url = null;
            url = StringUtils.isEmpty((CharSequence)filename) ? this.getClient().generatePresignedUrl(this.bucketName, urlfile, exp, HttpMethod.GET) : this.generatePresignedUrl(this.bucketName, filename, urlfile, exp, HttpMethod.GET);
            return url.toString();
        }
        Object basePath = "";
        HttpServletRequest request = ServletsUtil.getRequest();
        if (request != null) {
            String path = request.getContextPath();
            basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/" + this.getAdminPath();
        }
        return (String)basePath + "/file/downloadLocalByUrl?url=" + urlfile + "?response-content-disposition=attachment;filename=" + filename;
    }

    private URL generatePresignedUrl(String bucketName, String attachmentFilename, String key, Date expiration, HttpMethod method) throws ClientException {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, key);
        request.setExpiration(expiration);
        request.setMethod(method);
        ResponseHeaderOverrides responseHeaders = new ResponseHeaderOverrides();
        responseHeaders.setContentDisposition("attachment;filename=\"" + attachmentFilename + "\"");
        request.setResponseHeaders(responseHeaders);
        if (key.endsWith(".m3u8")) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("x-oss-process", "hls/sign");
            request.setQueryParameter(param);
        }
        return this.getClient().generatePresignedUrl(request);
    }

    public String getUrlBybucket(String bucket, String urlfile) {
        if (StringUtils.isEmpty((CharSequence)urlfile) || StringUtils.isEmpty((CharSequence)bucket)) {
            return "";
        }
        if (urlfile.indexOf("http://") >= 0 || urlfile.indexOf("https://") >= 0) {
            return urlfile;
        }
        if (this.publicread) {
            StringBuffer url = new StringBuffer();
            url.append("http://").append(this.bucketName).append(FILE_NAME_POINT_STRING).append("oss-cn-hangzhou.aliyuncs.com").append("/").append(urlfile);
            return url.toString();
        }
        Date exp = DateUtils.addSecond((Date)new Date(), (int)this.exptime);
        URL url = this.getClient().generatePresignedUrl(this.bucketName, urlfile, exp, HttpMethod.GET);
        return url.toString();
    }

    public String getThumbnail(String urlfile, String styleName) {
        if (StringUtils.isEmpty((CharSequence)urlfile)) {
            return "";
        }
        if (((String)urlfile).indexOf("http://") >= 0 || ((String)urlfile).indexOf("https://") >= 0) {
            return urlfile;
        }
        URL url = null;
        Date exp = DateUtils.addSecond((Date)new Date(), (int)this.exptime);
        urlfile = (String)urlfile + "@!" + styleName;
        url = this.getClient().generatePresignedUrl(this.bucketName, (String)urlfile, exp, HttpMethod.GET);
        return url.toString();
    }

    public String OSSPutObject(String serviceFilename, File file, String serviceDir, String fileFullname, String contentMD5) {
        return this.OSSPutObject(serviceFilename, file, serviceDir, fileFullname, null, FileContentTypeUtils.contentType((String)fileFullname));
    }

    public String OSSPutObject(String serviceFilename, File file, String serviceDir, String fileFullname) {
        return this.OSSPutObject(serviceFilename, file, serviceDir, fileFullname, null, FileContentTypeUtils.contentType((String)fileFullname));
    }

    public String OSSPutObject(String serviceFilename, File file, String serviceDir, String fileFullname, String contentMD5, String contentType) {
        ObjectMetadata objectMeta = new ObjectMetadata();
        objectMeta.setContentLength(file.length());
        if (StringUtils.isNotEmpty((String)fileFullname)) {
            try {
                fileFullname = URLEncoder.encode(fileFullname, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("UnsupportedEncodingException\uff1a", (Throwable)e);
            }
            objectMeta.setContentDisposition("inline;filename*=utf-8'zh_cn'" + fileFullname);
            objectMeta.setHeader("Content-disposition", (Object)("filename*=utf-8'zh_cn'" + fileFullname));
            objectMeta.setContentEncoding("UTF-8");
        }
        if (StringUtils.isNotEmpty((String)contentType)) {
            objectMeta.setContentType(contentType + ";charset=utf-8");
        }
        if (StringUtils.isNotEmpty((String)contentMD5)) {
            objectMeta.setContentMD5(contentMD5);
        }
        return this.OSSPutObject(serviceFilename, file, serviceDir, objectMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String OSSPutObject(String serviceFilename, File file, String serviceDir, ObjectMetadata objectMeta) {
        StringBuilder ossfile = new StringBuilder();
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            serviceDir = serviceDir.replace("\\", "/");
            if (serviceDir.endsWith(serviceFilename)) {
                ossfile.append(serviceDir);
            } else if (serviceDir.endsWith("/")) {
                ossfile.append(serviceDir).append(serviceFilename);
            } else {
                ossfile.append(serviceDir).append("/").append(serviceFilename);
            }
            PutObjectResult putObjectResult = this.getClient().putObject(this.bucketName, ossfile.toString(), (InputStream)input, objectMeta);
        }
        catch (FileNotFoundException e) {
            this.logger.error("FileNotFoundException\uff1a", (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            try {
                ((InputStream)input).close();
            }
            catch (IOException e) {
                this.logger.error("IOException\uff1a", (Throwable)e);
            }
        }
        return ossfile.toString();
    }

    public OSSObject downloadFile(String file) {
        OSSObject obj = null;
        try {
            obj = this.getClient().getObject(this.bucketName, file);
        }
        catch (OSSException oe) {
            this.logger.error("\u963f\u91cc\u4e91\u6587\u4ef6\u83b7\u53d6\u5931\u8d25:" + oe.getMessage());
        }
        catch (ClientException ce) {
            this.logger.error("\u963f\u91cc\u4e91\u8fde\u63a5\u5931\u8d25:" + ce.getMessage());
        }
        catch (NullPointerException n) {
            this.logger.error("\u963f\u91cc\u4e91\u6587\u4ef6\u83b7\u53d6\u5931\u8d25:" + n.getMessage());
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadFile(String fileOssurl, String destFilePath, String fileName) throws IOException {
        if (StringUtils.isEmpty((CharSequence)fileOssurl) || StringUtils.isEmpty((CharSequence)destFilePath)) {
            return fileName;
        }
        BufferedOutputStream bos = null;
        InputStream reader = null;
        String[] names = new String[]{fileName};
        File file = this.getNoRepeatDestFilePath(destFilePath, names);
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.mkdirs() && !parentFile.isDirectory()) {
            this.logger.error("IOException\u76ee\u5f55\u521b\u5efa\u5931\u8d25");
        }
        try {
            bos = new BufferedOutputStream(new FileOutputStream(file));
            if (this.asynch) {
                OSSObject ossObject;
                if (fileOssurl.startsWith("/")) {
                    fileOssurl = fileOssurl.substring(1);
                }
                if ((ossObject = this.downloadFile(fileOssurl)) == null || ossObject.getObjectContent() == null) {
                    String string = fileName;
                    return string;
                }
                reader = ossObject.getObjectContent();
            } else {
                String realPath = this.ossdir;
                if (StringUtils.isBlank((CharSequence)realPath)) {
                    throw new RuntimeException("\u5f53\u524d\u9644\u4ef6\u4e3a\u672c\u5730\u5b58\u50a8\uff0c \u6ca1\u6709\u914d\u7f6e\u9644\u4ef6\u5b58\u50a8\u8def\u5f84");
                }
                reader = new FileInputStream(FileUtils.getFile((String[])new String[]{realPath + "/" + fileOssurl}));
            }
            int len = 2048;
            byte[] b = new byte[len];
            while ((len = reader.read(b)) > 0) {
                bos.write(b, 0, len);
            }
            bos.flush();
        }
        catch (FileNotFoundException e) {
            this.logger.error("\u6587\u4ef6\u672a\u627e\u5230:" + e.getMessage());
        }
        catch (IOException e) {
            this.logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u8f93\u5165\u8f93\u51fa\u9519\u8bef:" + e.getMessage());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return names[0];
    }

    private File getNoRepeatDestFilePath(String destFilePath, String[] fileName) {
        if (!((String)destFilePath).endsWith(File.separator)) {
            destFilePath = (String)destFilePath + File.separator;
        }
        String fileSuffix = "";
        String pointStr = FILE_NAME_POINT_STRING;
        int pointIndex = fileName[0].lastIndexOf(FILE_NAME_POINT_STRING);
        if (pointIndex > 0) {
            fileSuffix = fileName[0].substring(pointIndex + 1);
            fileName[0] = fileName[0].substring(0, pointIndex);
        } else {
            pointStr = "";
        }
        File file = FileUtils.getFile((String[])new String[]{(String)destFilePath + fileName[0] + pointStr + fileSuffix});
        int i = 1;
        while (file.exists()) {
            file = FileUtils.getFile((String[])new String[]{(String)destFilePath + fileName[0] + i + pointStr + fileSuffix});
            ++i;
        }
        fileName[0] = i > 1 ? fileName[0] + --i + pointStr + fileSuffix : fileName[0] + pointStr + fileSuffix;
        return file;
    }

    public ObjectMetadata getObjectMetadataByUrl(String url) {
        ObjectMetadata metadata = this.getClient().getObjectMetadata(this.bucketName, url);
        return metadata;
    }

    public InputStream getInputStreamByUrl(String fileUrl) {
        InputStream reader = null;
        try {
            if (StringUtils.isEmpty((CharSequence)fileUrl)) {
                return null;
            }
            if (!fileUrl.startsWith("http") && !fileUrl.startsWith("https")) {
                this.logger.error("\u8be5\u8bf7\u6c42\u4e0d\u662f\u4ee5http\u6216https\u5f00\u5934");
                return null;
            }
            if (!SSRFLeakUtil.securitySSRFFileTypeCheck(null, (String)fileUrl)) {
                return null;
            }
            HttpResponse execute = HttpUtil.createGet((String)fileUrl).execute();
            reader = execute.bodyStream();
            return reader;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getHost() {
        return "http://" + this.bucketName + FILE_NAME_POINT_STRING + this.domain;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint == null ? null : endpoint.trim();
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId == null ? null : accessKeyId.trim();
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret == null ? null : accessKeySecret.trim();
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName == null ? null : bucketName.trim();
    }

    public boolean isAsynch() {
        return this.asynch;
    }

    public void setAsynch(boolean asynch) {
        this.asynch = asynch;
    }

    public OSS getClient() {
        if (this.client == null) {
            ClientBuilderConfiguration configuration = new ClientBuilderConfiguration();
            this.client = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
        }
        return this.client;
    }

    public int getExptime() {
        return this.exptime;
    }

    public void setExptime(int exptime) {
        this.exptime = exptime;
    }

    public boolean isPublicread() {
        return this.publicread;
    }

    public void setPublicread(boolean publicread) {
        this.publicread = publicread;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain == null ? null : domain.trim();
    }

    public String getAdminPath() {
        return this.adminPath;
    }

    public void setAdminPath(String adminPath) {
        this.adminPath = adminPath == null ? null : adminPath.trim();
    }

    public String getOssdir() {
        return this.ossdir;
    }

    public void setOssdir(String ossdir) {
        this.ossdir = ossdir;
    }

    public String getLocal() {
        return this.local;
    }

    public void setLocal(String local) {
        this.local = local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File download(String ossUrl, String filename) throws Exception {
        File file = CommonUtil.getFile((String[])new String[]{filename});
        try {
            this.client.getObject(new GetObjectRequest(this.bucketName, ossUrl), file);
        }
        finally {
            if (this.client != null) {
                this.client.shutdown();
            }
        }
        return file;
    }

    public Map<String, String> getPostSignature(String dir) throws Exception {
        String host = "https://" + this.bucketName + FILE_NAME_POINT_STRING + this.domain;
        long expireTime = 30L;
        long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
        Date expiration = new Date(expireEndTime);
        PolicyConditions policyConds = new PolicyConditions();
        policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
        policyConds.addConditionItem(MatchMode.StartWith, "key", dir);
        String postPolicy = this.getClient().generatePostPolicy(expiration, policyConds);
        byte[] binaryData = postPolicy.getBytes("utf-8");
        String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
        String postSignature = this.getClient().calculatePostSignature(postPolicy);
        LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
        respMap.put("accessid", this.accessKeyId);
        respMap.put("policy", encodedPolicy);
        respMap.put("signature", postSignature);
        respMap.put("dir", dir);
        respMap.put("host", host);
        respMap.put("expire", String.valueOf(expireEndTime / 1000L));
        JSONObject jasonCallback = new JSONObject();
        StringBuffer callbackBody = new StringBuffer("{");
        callbackBody.append("bucket:").append("${bucket}");
        callbackBody.append(",filename:").append("${object}");
        callbackBody.append(",etag:").append("${etag}");
        callbackBody.append(",size:").append("${size}");
        callbackBody.append(",mimeType:").append("${mimeType}");
        callbackBody.append(",height:").append("${imageInfo.height}");
        callbackBody.append(",width:").append("${imageInfo.width}");
        callbackBody.append(",format:").append("${imageInfo.format}");
        callbackBody.append("}");
        jasonCallback.put("callbackBody", (Object)callbackBody.toString());
        jasonCallback.put("callbackBodyType", (Object)"application/json");
        String base64CallbackBody = BinaryUtil.toBase64String((byte[])jasonCallback.toString().getBytes());
        respMap.put("callback", base64CallbackBody);
        return respMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File downloadFileFromOss(String fileOssurl, String destFilePath, String fileName) throws IOException {
        if (StringUtils.isEmpty((CharSequence)fileOssurl) || StringUtils.isEmpty((CharSequence)destFilePath)) {
            return null;
        }
        BufferedOutputStream bos = null;
        InputStream reader = null;
        File file = FileUtils.getFile((String[])new String[]{destFilePath + File.separator + fileName});
        if (!file.exists()) {
            file.createNewFile();
        }
        try {
            OSSObject ossObject;
            bos = new BufferedOutputStream(new FileOutputStream(file));
            if (fileOssurl.startsWith("/")) {
                fileOssurl = fileOssurl.substring(1);
            }
            if ((ossObject = this.downloadFile(fileOssurl)) == null || ossObject.getObjectContent() == null) {
                File file2 = null;
                return file2;
            }
            reader = ossObject.getObjectContent();
            int len = 2048;
            byte[] b = new byte[len];
            while ((len = reader.read(b)) > 0) {
                bos.write(b, 0, len);
            }
            bos.flush();
        }
        catch (FileNotFoundException e) {
            this.logger.error("\u6587\u4ef6\u672a\u627e\u5230:" + e.getMessage());
        }
        catch (IOException e) {
            this.logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u8f93\u5165\u8f93\u51fa\u9519\u8bef:" + e.getMessage());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File downloadTempFileFromOss(String fileOssurl, String ext) throws IOException {
        if (StringUtils.isEmpty((CharSequence)fileOssurl)) {
            return null;
        }
        BufferedOutputStream bos = null;
        InputStream reader = null;
        File file = File.createTempFile("shiping", ext);
        if (!file.exists()) {
            file.createNewFile();
        }
        try {
            OSSObject ossObject;
            bos = new BufferedOutputStream(new FileOutputStream(file));
            if (fileOssurl.startsWith("/")) {
                fileOssurl = fileOssurl.substring(1);
            }
            if ((ossObject = this.downloadFile(fileOssurl)) == null || ossObject.getObjectContent() == null) {
                File file2 = null;
                return file2;
            }
            reader = ossObject.getObjectContent();
            FileUtils.copyInputStreamToFile((InputStream)reader, (File)file);
        }
        catch (FileNotFoundException e) {
            this.logger.error("\u6587\u4ef6\u672a\u627e\u5230:" + e.getMessage());
        }
        catch (IOException e) {
            this.logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u8f93\u5165\u8f93\u51fa\u9519\u8bef:" + e.getMessage());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return file;
    }

    public List<String> findFileName(String filename) {
        ObjectListing objectListing;
        ArrayList<String> result = new ArrayList<String>();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(this.bucketName);
        listObjectsRequest.setMaxKeys(Integer.valueOf(1000));
        String nextMarker = null;
        do {
            listObjectsRequest.setMarker(nextMarker);
            objectListing = this.getClient().listObjects(listObjectsRequest);
            for (OSSObjectSummary objectSummary : objectListing.getObjectSummaries()) {
                if (!objectSummary.getKey().contains(filename)) continue;
                result.add(objectSummary.getKey());
                this.logger.error("\u67e5\u8be2\u5230\u6587\u4ef6\uff1a{}", (Object)objectSummary.getKey());
                return result;
            }
        } while ((nextMarker = objectListing.getNextMarker()) != null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String OSSPutObject(String serviceFilename, InputStream input, String serviceDir, String contentType, long contentLength) {
        StringBuilder ossfile = new StringBuilder();
        try {
            serviceDir = serviceDir.replace("\\", "/");
            if (serviceDir.endsWith(serviceFilename)) {
                ossfile.append(serviceDir);
            } else if (serviceDir.endsWith("/")) {
                ossfile.append(serviceDir).append(serviceFilename);
            } else {
                ossfile.append(serviceDir).append("/").append(serviceFilename);
            }
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentType(contentType);
            objectMetadata.setContentLength(contentLength);
            this.getClient().putObject(this.bucketName, ossfile.toString(), input, objectMetadata);
            String string = ossfile.toString();
            return string;
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20 OSS \u5931\u8d25\uff1a", (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    this.logger.error("\u5173\u95ed\u6d41\u5931\u8d25\uff1a", (Throwable)e);
                }
            }
        }
    }
}

