/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.zlb.controller;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.services.wanda.api.entity.WandaHealthCard;
import cn.smarthse.services.wanda.api.model.HealthCardSearchModel;
import cn.smarthse.services.wanda.api.service.IWandaHealthCardService;
import cn.smarthse.services.zlb.controller.AjaxResult;
import com.github.pagehelper.PageInfo;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/zlb/healthCard"})
public class ZlbHealthCardController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZlbHealthCardController.class);
    @DubboReference(check=false)
    private IWandaHealthCardService healthCardService;

    @GetMapping(value={"/list"})
    public AjaxResult getWandaHealthCardList(HealthCardSearchModel searchModel) {
        if (StringUtils.isEmpty((CharSequence)searchModel.getSourceId())) {
            return AjaxResult.success("sourceId\u4e3a\u7a7a");
        }
        WandaHealthCard wandaHealthCard = this.healthCardService.getWandaHealthCard(searchModel.getSourceId());
        if (wandaHealthCard != null && StringUtils.isNotEmpty((String)wandaHealthCard.getIdcardCode())) {
            searchModel.setIdcardCode(wandaHealthCard.getIdcardCode());
            PageInfo page = this.healthCardService.getWandaHealthCardPage(searchModel);
            return AjaxResult.success(page);
        }
        return AjaxResult.success("\u65e0\u6570\u636e");
    }

    @GetMapping(value={"/view"})
    public AjaxResult getWandaHealthCard(String sourceId) {
        if (StringUtils.isEmpty((CharSequence)sourceId)) {
            return AjaxResult.success("sourceId\u4e3a\u7a7a");
        }
        WandaHealthCard wandaHealthCard = this.healthCardService.getWandaHealthCard(sourceId);
        return AjaxResult.success(wandaHealthCard);
    }
}

