/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.zlb.controller;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.zlb.entity.InfoEvaluation;
import cn.smarthse.modules.health.zlb.model.ScienceInfoModel;
import cn.smarthse.modules.health.zlb.model.ScienceSearchVo;
import cn.smarthse.modules.health.zlb.service.science.IScienceService;
import cn.smarthse.services.zlb.controller.AjaxResult;
import com.github.pagehelper.PageInfo;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/zlb/science"})
public class ScienceController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScienceController.class);
    @DubboReference
    private IScienceService scienceService;

    @GetMapping(value={"/list"})
    public AjaxResult scienceList(ScienceSearchVo searchVo) {
        PageInfo page = this.scienceService.page(searchVo);
        return AjaxResult.success(page);
    }

    @GetMapping(value={"/view"})
    public AjaxResult textView(Long id) {
        ScienceInfoModel model = this.scienceService.getBigTextById(id);
        return AjaxResult.success(model);
    }

    @GetMapping(value={"/checkEvaluate"})
    public AjaxResult checkEvaluate(InfoEvaluation evaluation) {
        if (evaluation == null || StringUtils.isEmpty((CharSequence)evaluation.getUserId())) {
            return AjaxResult.error("\u672a\u767b\u5f55");
        }
        InfoEvaluation infoEvaluation = this.scienceService.checkEvaluate(evaluation);
        return AjaxResult.success(infoEvaluation);
    }

    @PostMapping(value={"/evaluate"})
    public AjaxResult evaluate(@RequestBody InfoEvaluation evaluation) {
        if (evaluation == null || StringUtils.isEmpty((CharSequence)evaluation.getUserId())) {
            return AjaxResult.error("\u672a\u767b\u5f55");
        }
        InfoEvaluation infoEvaluation = this.scienceService.saveEvaluate(evaluation);
        return AjaxResult.success(infoEvaluation);
    }
}

