/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.zlb.controller;

import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.LineCaptcha;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.smarthse.common.util.passwordLog.StringUtils;
import cn.smarthse.services.wanda.api.entity.WandaHealthCard;
import cn.smarthse.services.wanda.api.service.IWandaHealthCardService;
import cn.smarthse.services.zlb.controller.AjaxResult;
import cn.smarthse.services.zlb.service.IZlbClientService;
import cn.smarthse.services.zlb.vo.ZlbUserInfoData;
import cn.smarthse.services.zlb.vo.ZlbUserInfoVo;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Deprecated
@RestController
@RequestMapping(value={"/zlb"})
public class IndividualLoginController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndividualLoginController.class);
    @Autowired
    private IZlbClientService zlbClientService;
    @DubboReference(check=false)
    private IWandaHealthCardService wandaHealthCardService;
    @Autowired
    private RedisTemplate<String, String> stringRedisTemplate;
    private static final String zlb_RSA_cacheName = "ZLBRSA:";
    private static final String zlb_loginCaptcha_cacheName = "ZLBLoginCaptcha:";

    @GetMapping(value={"getClientTicketCode/{ticket}"})
    public AjaxResult getClientTicketCode(@PathVariable String ticket) {
        if (StringUtils.isEmpty((String)ticket) || "undefined".equals(ticket)) {
            log.error("\u83b7\u53d6ticket\u5931\u8d25\uff01");
            return AjaxResult.error("\u767b\u5f55\u5931\u8d25");
        }
        log.info("\u83b7\u53d6\u7528\u6237\u767b\u9646\u7968\u636eticket=" + ticket);
        return this.zlbClientService.getClientTicketCode(ticket);
    }

    @GetMapping(value={"getClientInfoByToken/{token}"})
    public AjaxResult getClientInfoByToken(@PathVariable String token) {
        if (StringUtils.isEmpty((String)token) || "undefined".equals(token)) {
            log.error("\u83b7\u53d6token\u5931\u8d25\uff01");
            return AjaxResult.error("\u767b\u5f55\u5931\u8d25");
        }
        log.info("\u83b7\u53d6\u7528\u6237\u767b\u9646\u4ee4\u724ctoken=" + token);
        return this.zlbClientService.getClientInfoByToken(token);
    }

    @PostMapping(value={"workerH5Login"})
    public AjaxResult workerH5Login(@RequestBody ZlbUserInfoVo zlbUserInfoVo) {
        String userid = zlbUserInfoVo.getUserid();
        String username = zlbUserInfoVo.getUsername();
        String idnum = zlbUserInfoVo.getIdnum();
        String publicKeyId = zlbUserInfoVo.getPublicKeyId();
        Boolean isCheckCaptcha = zlbUserInfoVo.getIsCheckCaptcha();
        if (Boolean.FALSE.equals(isCheckCaptcha)) {
            return AjaxResult.error("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9a8c\u8bc1\u7801\uff01");
        }
        if (StringUtils.isEmpty((String)userid) || StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)idnum) || StringUtils.isEmpty((String)publicKeyId)) {
            log.error("\u4e2a\u4eba\u7528\u6237\u767b\u5f55\u5931\u8d25\uff01");
            return AjaxResult.error("\u767b\u5f55\u5931\u8d25\uff01");
        }
        String privateKey = (String)this.stringRedisTemplate.opsForValue().get((Object)(zlb_RSA_cacheName + publicKeyId));
        if (null == privateKey) {
            log.error("\u6d59\u91cc\u529e\u5bc6\u94a5\u5931\u6548\uff01");
            return AjaxResult.error("\u767b\u5f55\u5931\u8d25\uff01");
        }
        idnum = StrUtil.str((byte[])SecureUtil.rsa((String)privateKey, null).decrypt(idnum, KeyType.PrivateKey), (Charset)CharsetUtil.CHARSET_UTF_8);
        if (StrUtil.isBlank((CharSequence)idnum)) {
            log.error("\u8eab\u4efd\u8bc1\u4fe1\u606f\u4e3a\u7a7a\uff01");
            return AjaxResult.error("\u767b\u5f55\u5931\u8d25\uff01");
        }
        WandaHealthCard wandaHealthCard = this.wandaHealthCardService.getUserInfo(username, idnum);
        if (wandaHealthCard == null) {
            log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            return AjaxResult.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        this.stringRedisTemplate.delete((Object)(zlb_RSA_cacheName + publicKeyId));
        ZlbUserInfoData zlbUserInfoData = new ZlbUserInfoData();
        zlbUserInfoData.setId(wandaHealthCard.getId());
        zlbUserInfoData.setSourceId(wandaHealthCard.getSourceId());
        zlbUserInfoData.setName(wandaHealthCard.getName());
        zlbUserInfoData.setIdcardType(wandaHealthCard.getIdcardType());
        zlbUserInfoData.setIdcardCode(wandaHealthCard.getIdcardCode());
        zlbUserInfoData.setSexCode(wandaHealthCard.getSexCode());
        zlbUserInfoData.setTelPhone(wandaHealthCard.getTelPhone());
        return AjaxResult.success(zlbUserInfoData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"getLoginCaptcha"})
    public void getLoginCaptcha(@RequestParam(value="captchaId") String captchaId, HttpServletResponse response) {
        log.debug("\u6267\u884cgetLoginCaptcha\u65b9\u6cd5\uff1acaptchaId\uff1a{}", (Object)captchaId);
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-store;no-cache;must-revalidate;post-check=0;pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setContentType("image/jpeg");
        LineCaptcha lineCaptcha = CaptchaUtil.createLineCaptcha((int)200, (int)100, (int)4, (int)150);
        this.stringRedisTemplate.opsForValue().set((Object)(zlb_loginCaptcha_cacheName + captchaId), (Object)lineCaptcha.getCode(), 300L, TimeUnit.SECONDS);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            lineCaptcha.write((OutputStream)out);
        }
        catch (IOException e) {
            log.error("IOException\uff1a", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error("IOException\uff1a", (Throwable)e);
                }
            }
        }
    }

    @PostMapping(value={"checkCaptcha"})
    public AjaxResult checkLoginCaptcha(@RequestParam(value="captchaId") String captchaId, @RequestParam(value="code") String code) {
        log.debug("\u6267\u884ccheckCaptcha\u65b9\u6cd5[\u7b2c\u4e00\u6b65]\uff1acaptchaId\uff1a{},code\uff1a{}", (Object)captchaId, (Object)code);
        if (StringUtils.isEmpty((String)captchaId) || StringUtils.isEmpty((String)code)) {
            return AjaxResult.error("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9a8c\u8bc1\u7801\uff01");
        }
        String captchaCache = (String)this.stringRedisTemplate.opsForValue().get((Object)(zlb_loginCaptcha_cacheName + captchaId));
        log.debug("\u6267\u884ccheckCaptcha\u65b9\u6cd5[\u7b2c\u4e8c\u6b65]\uff1acaptchaCache\uff1a{}", (Object)captchaCache);
        if (null == captchaCache) {
            log.error("\u6d59\u91cc\u529e\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\uff01");
            return AjaxResult.error("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        boolean b = code.equalsIgnoreCase(captchaCache);
        if (b) {
            this.stringRedisTemplate.delete((Object)(zlb_loginCaptcha_cacheName + captchaId));
        }
        return AjaxResult.success(b);
    }

    @PostMapping(value={"getPublicKey"})
    public AjaxResult getPublicKey(@RequestParam(value="publicKeyId") String publicKeyId) {
        KeyPair rsa = SecureUtil.generateKeyPair((String)"RSA", (int)512);
        this.stringRedisTemplate.opsForValue().set((Object)(zlb_RSA_cacheName + publicKeyId), (Object)Base64.encode((byte[])rsa.getPrivate().getEncoded()), 300L, TimeUnit.SECONDS);
        return AjaxResult.success(Base64.encode((byte[])rsa.getPublic().getEncoded()));
    }
}

