/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.ycq.service.impl;

import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.health.ycq.vo.HealthCardDetailVo;
import cn.smarthse.modules.health.ycq.vo.YcqContraindicationsVo;
import cn.smarthse.modules.health.ycq.vo.YcqOccupationalDiseasesVo;
import cn.smarthse.modules.health.ycq.vo.YcqSuspectedDiseasesVo;
import cn.smarthse.services.wanda.api.entity.WandaHcDiags;
import cn.smarthse.services.wanda.api.entity.WandaHealthCard;
import cn.smarthse.services.ycq.mapper.YcqHealthMapper;
import cn.smarthse.services.ycq.service.impl.WandaDataConverter;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class YcqHealthService {
    private final YcqHealthMapper ycqHealthMapper;
    protected final WandaDataConverter converter;

    public List<YcqSuspectedDiseasesVo> getSuspectedDiseases(String idcard) {
        String idCardEnc = SpringEncryptUtils.encrypt((String)idcard);
        return this.ycqHealthMapper.getSuspectedDiseases(idCardEnc);
    }

    public List<YcqOccupationalDiseasesVo> getOccupationalDiseases(String idcard) {
        String idCardEnc = SpringEncryptUtils.encrypt((String)idcard);
        return this.ycqHealthMapper.getOccupationalDiseases(idCardEnc);
    }

    public List<YcqContraindicationsVo> getContraindications(String idcard) {
        String idCardEnc = SpringEncryptUtils.encrypt((String)idcard);
        return this.ycqHealthMapper.getContraindications(idCardEnc);
    }

    public List<HealthCardDetailVo> getHealthCard(String idcard) {
        ArrayList<HealthCardDetailVo> result = new ArrayList<HealthCardDetailVo>();
        String idCardEnc = SpringEncryptUtils.encrypt((String)idcard);
        List<WandaHealthCard> healthCardList = this.ycqHealthMapper.getWandaHealthCardList(idCardEnc);
        healthCardList.forEach(wandaHealthCard -> {
            List<WandaHcDiags> wandaHcDiagsList = this.ycqHealthMapper.getWandaHcDiagsList(wandaHealthCard.getSourceId());
            result.add(new HealthCardDetailVo(this.converter.WandaHealthCard2HealthCardVo((WandaHealthCard)wandaHealthCard), this.converter.WandaHcDiags2HcDiagsVo(wandaHcDiagsList)));
        });
        return result;
    }

    @Generated
    public YcqHealthService(YcqHealthMapper ycqHealthMapper, WandaDataConverter converter) {
        this.ycqHealthMapper = ycqHealthMapper;
        this.converter = converter;
    }
}

