/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.ycq.service.impl;

import cn.smarthse.modules.health.ycq.entity.YcqDiagnosis;
import cn.smarthse.modules.health.ycq.entity.YcqResultSys;
import cn.smarthse.modules.health.ycq.entity.YcqResultYxyx;
import cn.smarthse.modules.health.ycq.param.YcqParam;
import cn.smarthse.modules.health.ycq.service.IYcqDiagnosisService;
import cn.smarthse.modules.health.ycq.service.IYcqResultSysService;
import cn.smarthse.modules.health.ycq.service.IYcqResultYxyxService;
import cn.smarthse.modules.health.ycq.vo.YcqVo;
import cn.smarthse.services.ycq.converter.YxqConverter;
import cn.smarthse.services.ycq.mapper.YcqDiagnosisMapper;
import cn.smarthse.util.common.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class YcqDiagnosisServiceImpl
extends ServiceImpl<YcqDiagnosisMapper, YcqDiagnosis>
implements IYcqDiagnosisService {
    private final IYcqResultSysService ycqResultSysService;
    private final IYcqResultYxyxService YcqResultYxyxService;
    private final YxqConverter converter;

    @Transactional
    public Long addYcqDiagnosis(YcqParam param) {
        String jzlsh = param.getYcqDiagnosis().getJzlsh();
        YcqDiagnosis ycqDiagnosis = this.converter.YcqDiagnosisParam2YcqDiagnosis(param.getYcqDiagnosis());
        List<YcqResultSys> ycqResultSysList = this.converter.YcqResultSysParam2YcqResultSys(param.getYcqResultSysList());
        List<YcqResultYxyx> ycqResultYxyxList = this.converter.YcqResultYxyxParam2YcqResultYxyx(param.getYcqResultYxyxList());
        this.initOther(ycqDiagnosis, ycqResultSysList, ycqResultYxyxList);
        this.del(jzlsh);
        this.save(ycqDiagnosis);
        this.ycqResultSysService.addList(ycqResultSysList);
        this.YcqResultYxyxService.addList(ycqResultYxyxList);
        return ycqDiagnosis.getId();
    }

    public void del(String jzlsh) {
        if (StringUtils.isEmpty((CharSequence)jzlsh)) {
            return;
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate(YcqDiagnosis.class);
        ((LambdaUpdateWrapper)wrapper.eq(YcqDiagnosis::getJzlsh, (Object)jzlsh)).set(YcqDiagnosis::getIsValid, (Object)0);
        this.update((Wrapper)wrapper);
    }

    public YcqDiagnosis getYcqDiagnosis(String jzlsh) {
        if (StringUtils.isEmpty((CharSequence)jzlsh)) {
            return null;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(YcqDiagnosis.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(YcqDiagnosis::getJzlsh, (Object)jzlsh)).eq(YcqDiagnosis::getIsValid, (Object)1)).last("limit 1");
        return (YcqDiagnosis)this.getOne((Wrapper)wrapper);
    }

    private void initOther(YcqDiagnosis ycqDiagnosis, List<YcqResultSys> ycqResultSysList, List<YcqResultYxyx> ycqResultYxyxList) {
        ycqDiagnosis.setCreateDate(new Date());
        ycqDiagnosis.setUpdateDate(ycqDiagnosis.getCreateDate());
        ycqDiagnosis.setIsValid(Boolean.valueOf(true));
        if (!CollectionUtils.isEmpty(ycqResultSysList)) {
            ycqResultSysList.forEach(record -> {
                record.setCreateDate(ycqDiagnosis.getCreateDate());
                record.setUpdateDate(ycqDiagnosis.getCreateDate());
                record.setIsValid(Integer.valueOf(1));
            });
        }
        if (!CollectionUtils.isEmpty(ycqResultYxyxList)) {
            ycqResultYxyxList.forEach(record -> {
                record.setCreateDate(ycqDiagnosis.getCreateDate());
                record.setUpdateDate(ycqDiagnosis.getCreateDate());
                record.setIsValid(Integer.valueOf(1));
            });
        }
    }

    public YcqVo getYcqDiagnosisVo(String jzlsh) {
        YcqVo result = new YcqVo();
        result.setYcqDiagnosis(this.converter.YcqDiagnosis2YcqDiagnosisVo(this.getYcqDiagnosis(jzlsh)));
        result.setYcqResultSysList(this.converter.YcqResultSys2YcqResultSysVo(this.ycqResultSysService.getYcqResult(jzlsh)));
        result.setYcqResultYxyxList(this.converter.YcqResultYxyx2YcqResultYxyxVo(this.YcqResultYxyxService.getYcqResult(jzlsh)));
        return result;
    }

    @Generated
    public YcqDiagnosisServiceImpl(IYcqResultSysService ycqResultSysService, IYcqResultYxyxService YcqResultYxyxService, YxqConverter converter) {
        this.ycqResultSysService = ycqResultSysService;
        this.YcqResultYxyxService = YcqResultYxyxService;
        this.converter = converter;
    }
}

