/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.ycq.controller;

import cn.smarthse.modules.health.ycq.param.YcqIdcardQueryParam;
import cn.smarthse.modules.health.ycq.param.YcqJzlshQueryParam;
import cn.smarthse.modules.health.ycq.param.YcqParam;
import cn.smarthse.modules.health.ycq.service.IYcqDiagnosisService;
import cn.smarthse.modules.health.ycq.vo.HealthCardDetailVo;
import cn.smarthse.modules.health.ycq.vo.YcqContraindicationsVo;
import cn.smarthse.modules.health.ycq.vo.YcqOccupationalDiseasesVo;
import cn.smarthse.modules.health.ycq.vo.YcqSuspectedDiseasesVo;
import cn.smarthse.modules.health.ycq.vo.YcqVo;
import cn.smarthse.services.shiro.JWTUtils;
import cn.smarthse.services.support.ResponseData2;
import cn.smarthse.services.ycq.service.impl.YcqHealthService;
import com.auth0.jwt.interfaces.DecodedJWT;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.util.List;
import lombok.Generated;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/ycq"})
@RestController
@Validated
public class YcqDiagnosisController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(YcqDiagnosisController.class);
    private final IYcqDiagnosisService ycqDiagnosisService;
    private final YcqHealthService ycqHealthService;
    private static final String Request_Id = "Request-Id";
    public static final String DEFAULT_AUTH_TOKEN_PARAM = "token";

    @PostMapping(value={"/addYcqDiagnosis"}, consumes={"application/json"})
    public ResponseData2<Long> addYcqDiagnosis(HttpServletRequest request, @Validated @RequestBody YcqParam param) {
        log.debug("\u8d8a\u57ce\u533a\uff1a\u95e8\u8bca\u8bca\u65ad\u4fe1\u606f\u6dfb\u52a0: requestId: {}, param :{}", (Object)request.getHeader(Request_Id), (Object)param);
        Long id = this.ycqDiagnosisService.addYcqDiagnosis(param);
        return ResponseData2.success(id, "\u95e8\u8bca\u8bca\u65ad\u4fe1\u606f\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/getYcqDiagnosis"}, consumes={"application/json"})
    public ResponseData2<YcqVo> getYcqDiagnosis(HttpServletRequest request, @Validated @RequestBody YcqJzlshQueryParam param) {
        log.debug("\u8d8a\u57ce\u533a\uff1a\u95e8\u8bca\u8bca\u65ad\u4fe1\u606f\u67e5\u8be2: requestId: {}, param :{}", (Object)request.getHeader(Request_Id), (Object)param);
        return ResponseData2.success(this.ycqDiagnosisService.getYcqDiagnosisVo(param.getJzlsh()), "\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/getSuspectedDiseases"}, consumes={"application/json"})
    public ResponseData2<List<YcqSuspectedDiseasesVo>> getSuspectedDiseases(HttpServletRequest request, @Validated @RequestBody YcqIdcardQueryParam param) {
        log.info("\u8d8a\u57ce\u533a\uff1a\u7591\u4f3c\u804c\u4e1a\u75c5\u4fe1\u606f\u67e5\u8be2: requestId: {}, param :{}", (Object)request.getHeader(Request_Id), (Object)param);
        return ResponseData2.success(this.ycqHealthService.getSuspectedDiseases(param.getIdcard()), "\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/getOccupationalDiseases"}, consumes={"application/json"})
    public ResponseData2<List<YcqOccupationalDiseasesVo>> getOccupationalDiseases(HttpServletRequest request, @Validated @RequestBody YcqIdcardQueryParam param) {
        log.info("\u8d8a\u57ce\u533a\uff1a\u804c\u4e1a\u75c5\u4fe1\u606f\u67e5\u8be2: requestId: {}, param :{}", (Object)request.getHeader(Request_Id), (Object)param);
        return ResponseData2.success(this.ycqHealthService.getOccupationalDiseases(param.getIdcard()), "\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/getContraindications"}, consumes={"application/json"})
    public ResponseData2<List<YcqContraindicationsVo>> getContraindications(HttpServletRequest request, @Validated @RequestBody YcqIdcardQueryParam param) {
        log.info("\u8d8a\u57ce\u533a\uff1a\u7981\u5fcc\u8bc1\u4fe1\u606f\u67e5\u8be2: requestId: {}, param :{}", (Object)request.getHeader(Request_Id), (Object)param);
        return ResponseData2.success(this.ycqHealthService.getContraindications(param.getIdcard()), "\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/getHealthCard"}, consumes={"application/json"})
    @RequiresRoles(value={"ycq"})
    public ResponseData2<List<HealthCardDetailVo>> getHealthCard(HttpServletRequest request, @Validated @RequestBody YcqIdcardQueryParam param) {
        log.info("\u8d8a\u57ce\u533a\uff1a\u804c\u4e1a\u536b\u751f-\u804c\u4e1a\u5065\u5eb7\u6863\u6848: requestId: {}, param :{}", (Object)request.getHeader(Request_Id), (Object)param.getIdcard());
        return ResponseData2.success(this.ycqHealthService.getHealthCard(param.getIdcard()), "\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/verifyToken"})
    public boolean verifyToken(HttpServletRequest request) {
        log.debug("\u8d8a\u57ce\u533a\uff1a\u6821\u9a8ctoken\uff1a requestId\uff1a{}\uff0c {}", (Object)request.getHeader(Request_Id), (Object)request.getHeader(DEFAULT_AUTH_TOKEN_PARAM));
        try {
            DecodedJWT decodedJWT = JWTUtils.verify(request.getHeader(DEFAULT_AUTH_TOKEN_PARAM));
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        return true;
    }

    @Generated
    public YcqDiagnosisController(IYcqDiagnosisService ycqDiagnosisService, YcqHealthService ycqHealthService) {
        this.ycqDiagnosisService = ycqDiagnosisService;
        this.ycqHealthService = ycqHealthService;
    }
}

