/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.tasks.bx;

import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProvideMasService;
import cn.smarthse.modules.health.bx.entity.BxLastMonthZybSummary;
import cn.smarthse.modules.health.bx.service.IBxLastMonthZybSummaryService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideInfoService;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BxZybPushTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BxZybPushTask.class);
    @DubboReference
    private INewCompanyGuideInfoService newCompanyGuideInfoService;
    @Resource
    private IBxLastMonthZybSummaryService bxLastMonthZybSummaryService;
    @DubboReference
    private ISMSProvideMasService masService;
    @Value(value="${smarthse.phone:18989489891}")
    private String phonenum;

    @XxlJob(value="BxZybPushTask-bxzybSyncIrsData")
    public void bxzybSyncIrsData() {
        log.info("\u3010\u540c\u6b65\u201c\u7591\u4f3c\u201d\u804c\u4e1a\u75c5IRS\u6570\u636e\u3011start");
        List bxLastMonthZybSummaries = this.bxLastMonthZybSummaryService.listWaitInCompany();
        if (CollectionUtils.isEmpty((Collection)bxLastMonthZybSummaries)) {
            XxlJobHelper.log((String)"\u3010\u540c\u6b65\u201c\u7591\u4f3c\u201d\u804c\u4e1a\u75c5IRS\u6570\u636e\u3011\u4e3a\u7a7a", (Object[])new Object[0]);
            return;
        }
        ArrayList<BxLastMonthZybSummary> needUpdateList = new ArrayList<BxLastMonthZybSummary>();
        for (BxLastMonthZybSummary bxLastMonthZybSummary : bxLastMonthZybSummaries) {
            String unifiedSocialCc = bxLastMonthZybSummary.getCreditCode();
            String companyName = bxLastMonthZybSummary.getCompanyName();
            CompanySuperviseSearchModel searchParam = new CompanySuperviseSearchModel();
            searchParam.setUnifiedSocialCc(unifiedSocialCc);
            try {
                CompanySuperviseModel irsMarketEntities = this.newCompanyGuideInfoService.getCompanyInfo(searchParam);
                if (irsMarketEntities != null) {
                    if (!Objects.equals(companyName, irsMarketEntities.getName())) {
                        bxLastMonthZybSummary.setIrsFailReason("\u4f01\u4e1a\u540d\u79f0\u4e0d\u4e00\u81f4");
                    } else {
                        bxLastMonthZybSummary.setIrsBusinessState(irsMarketEntities.getIrsBusinessState());
                        bxLastMonthZybSummary.setIrsFailReason("");
                    }
                } else {
                    bxLastMonthZybSummary.setIrsFailReason("\u672a\u627e\u5230IRS\u6570\u636e");
                }
                needUpdateList.add(bxLastMonthZybSummary);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65IRS \u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isEmpty(needUpdateList)) {
            return;
        }
        this.bxLastMonthZybSummaryService.updateBxLastMonthZybSummary(needUpdateList);
        log.info("\u3010\u540c\u6b65\u201c\u7591\u4f3c\u201d\u804c\u4e1a\u75c5IRS\u6570\u636e\u3011end");
    }
}

