/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.support;

import cn.smarthse.services.onlinemonitoring.entity.user.UserInfo;
import cn.smarthse.services.shiro.JWTUtils;
import com.auth0.jwt.JWTCreator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;

public class UserUtils {
    private static final ThreadLocal<UserInfo> resources = new ThreadLocal();

    public static UserInfo getCurrentUser() {
        return resources.get();
    }

    public static void setCurrentUser(UserInfo user) {
        resources.set(user);
    }

    public static void remove() {
        resources.remove();
    }

    public static String reflashJWT(HttpServletRequest request, HttpServletResponse response) throws IllegalArgumentException, UnsupportedEncodingException {
        UserInfo user = UserUtils.getCurrentUser();
        if (user == null) {
            return null;
        }
        JWTCreator.Builder builder = JWTUtils.getBuilder();
        if (user.getAppId() != null) {
            builder.withClaim("cid", user.getAppId());
        }
        String jwt = JWTUtils.sign(builder);
        response.setHeader("jwt", jwt);
        return jwt;
    }
}

