/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.supervisionexelaw.serviceimpl.zfxx;

import cn.smarthse.services.onlinemonitoring.serviceimp.company.CompanyServiceImpl;
import cn.smarthse.services.supervisionexelaw.entity.SupervisionExeLawInfo;
import cn.smarthse.services.supervisionexelaw.mapper.SupervisionExeLawInfoMapper;
import cn.smarthse.services.supervisionexelaw.model.ResponseResult;
import cn.smarthse.services.supervisionexelaw.model.zfxx.SupervisionExeLawInfoModel;
import cn.smarthse.services.supervisionexelaw.serviceimpl.SupervisionApiBaseServiceImpl;
import cn.smarthse.util.common.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupervisionZfxxServiceImpl
extends SupervisionApiBaseServiceImpl<SupervisionExeLawInfoMapper, SupervisionExeLawInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SupervisionZfxxServiceImpl.class);
    @Autowired
    CompanyServiceImpl companyService;

    @Override
    public List<SupervisionExeLawInfo> convertObj(ResponseResult jsonObject) {
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getDataJson())) {
            List data = JSONArray.parseArray((String)jsonObject.getDataJson(), SupervisionExeLawInfoModel.class);
            if (CollectionUtils.isEmpty((Collection)data)) {
                return null;
            }
            ArrayList<SupervisionExeLawInfo> lawInfoList = new ArrayList<SupervisionExeLawInfo>();
            ArrayList<String> delSourceIdList = new ArrayList<String>();
            for (SupervisionExeLawInfoModel datum : data) {
                SupervisionExeLawInfo lawInfo = new SupervisionExeLawInfo();
                BeanUtils.copyProperties((Object)datum, (Object)lawInfo, (String[])new String[]{"id", "createDate", "updateDate"});
                lawInfo.setSourceId(datum.getId());
                lawInfo.setSourceCreateTime(datum.getCreateTime());
                lawInfo.setSourceUpdateTime(datum.getUpdateTime());
                lawInfo.setCid(this.companyService.getCidByCode(datum.getCreditCode()));
                lawInfo.setCreateDate(LocalDateTime.now());
                lawInfo.setUpdateDate(LocalDateTime.now());
                lawInfoList.add(lawInfo);
                delSourceIdList.add(datum.getId());
            }
            if (CollectionUtils.isNotEmpty(delSourceIdList)) {
                UpdateWrapper update = Wrappers.update();
                List partition = ListUtils.partition(delSourceIdList, (int)500);
                for (List strings : partition) {
                    update.in((Object)"source_id", (Collection)strings);
                    ((SupervisionExeLawInfoMapper)this.baseMapper).delete((Wrapper)update);
                }
            }
            return lawInfoList;
        }
        log.error("dataJson \u4e3a\u7a7a");
        return null;
    }

    @Override
    public String getTableNameEn() {
        return "za_yrdw_jbxx_xzcf";
    }

    @Override
    public SupervisionExeLawInfo getLatelyDataBySourceCreateTime() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.orderByDesc(SupervisionExeLawInfo::getSourceUpdateTime)).last("limit 1");
        return (SupervisionExeLawInfo)((SupervisionExeLawInfoMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
    }

    private Boolean getIsExistBySourceId(String sourceId) {
        if (sourceId == null) {
            return false;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SupervisionExeLawInfo::getSourceId, (Object)sourceId);
        SupervisionExeLawInfo info = (SupervisionExeLawInfo)((SupervisionExeLawInfoMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        return info != null && info.getSourceId() != null;
    }
}

