/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.supervisionexelaw.serviceimpl.ssj;

import cn.smarthse.services.onlinemonitoring.serviceimp.company.CompanyServiceImpl;
import cn.smarthse.services.supervisionexelaw.entity.SupervisionDoubleRandomInfo;
import cn.smarthse.services.supervisionexelaw.mapper.SupervisionDoubleRandomInfoMapper;
import cn.smarthse.services.supervisionexelaw.model.ResponseResult;
import cn.smarthse.services.supervisionexelaw.model.ssj.SupervisionDoubleRandomInfoModel;
import cn.smarthse.services.supervisionexelaw.serviceimpl.SupervisionApiBaseServiceImpl;
import cn.smarthse.util.common.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupervisionSsjxxServiceImpl
extends SupervisionApiBaseServiceImpl<SupervisionDoubleRandomInfoMapper, SupervisionDoubleRandomInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SupervisionSsjxxServiceImpl.class);
    @Autowired
    CompanyServiceImpl companyService;

    @Override
    public List<SupervisionDoubleRandomInfo> convertObj(ResponseResult jsonObject) {
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getDataJson())) {
            List data = JSONArray.parseArray((String)jsonObject.getDataJson(), SupervisionDoubleRandomInfoModel.class);
            if (CollectionUtils.isEmpty((Collection)data)) {
                return null;
            }
            ArrayList<SupervisionDoubleRandomInfo> DoubleRamList = new ArrayList<SupervisionDoubleRandomInfo>();
            ArrayList<String> delSourceIdList = new ArrayList<String>();
            for (SupervisionDoubleRandomInfoModel datum : data) {
                SupervisionDoubleRandomInfo DoubleRam = new SupervisionDoubleRandomInfo();
                BeanUtils.copyProperties((Object)datum, (Object)DoubleRam, (String[])new String[]{"id", "createDate", "updateDate"});
                DoubleRam.setSourceId(datum.getId());
                DoubleRam.setSourceCreateTime(datum.getCreateTime());
                DoubleRam.setSourceUpdateTime(datum.getUpdateTime());
                DoubleRam.setCid(this.companyService.getCidByCode(datum.getCreditCode()));
                DoubleRam.setCreateDate(LocalDateTime.now());
                DoubleRam.setUpdateDate(LocalDateTime.now());
                DoubleRamList.add(DoubleRam);
                delSourceIdList.add(datum.getId());
            }
            UpdateWrapper update = Wrappers.update();
            update.in((Object)"source_id", delSourceIdList);
            ((SupervisionDoubleRandomInfoMapper)this.baseMapper).delete((Wrapper)update);
            return DoubleRamList;
        }
        log.error("dataJson \u4e3a\u7a7a");
        return null;
    }

    @Override
    public String getTableNameEn() {
        return "za_yrdw_jbxx_ssj";
    }

    @Override
    public SupervisionDoubleRandomInfo getLatelyDataBySourceCreateTime() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.orderByDesc(SupervisionDoubleRandomInfo::getSourceUpdateTime)).last("limit 1");
        return (SupervisionDoubleRandomInfo)((SupervisionDoubleRandomInfoMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
    }

    private Boolean getIsExistBySourceId(String sourceId) {
        if (sourceId == null) {
            return false;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SupervisionDoubleRandomInfo::getSourceId, (Object)sourceId);
        SupervisionDoubleRandomInfo info = (SupervisionDoubleRandomInfo)((SupervisionDoubleRandomInfoMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        return info != null && info.getSourceId() != null;
    }
}

