/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.supervisionexelaw.serviceimpl.jdxx;

import cn.smarthse.services.onlinemonitoring.serviceimp.company.CompanyServiceImpl;
import cn.smarthse.services.supervisionexelaw.entity.SupervisionSupInfo;
import cn.smarthse.services.supervisionexelaw.mapper.SupervisionSupInfoMapper;
import cn.smarthse.services.supervisionexelaw.model.ResponseResult;
import cn.smarthse.services.supervisionexelaw.model.jdxx.SupervisionSupInfoModel;
import cn.smarthse.services.supervisionexelaw.serviceimpl.SupervisionApiBaseServiceImpl;
import cn.smarthse.util.common.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupervisionJdxxServiceImpl
extends SupervisionApiBaseServiceImpl<SupervisionSupInfoMapper, SupervisionSupInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SupervisionJdxxServiceImpl.class);
    @Autowired
    CompanyServiceImpl companyService;

    @Override
    public List<SupervisionSupInfo> convertObj(ResponseResult jsonObject) {
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getDataJson())) {
            List data = JSONArray.parseArray((String)jsonObject.getDataJson(), SupervisionSupInfoModel.class);
            if (CollectionUtils.isEmpty((Collection)data)) {
                return null;
            }
            ArrayList<SupervisionSupInfo> supInfoList = new ArrayList<SupervisionSupInfo>();
            ArrayList<String> delSourceIdList = new ArrayList<String>();
            for (SupervisionSupInfoModel datum : data) {
                SupervisionSupInfo supInfo = new SupervisionSupInfo();
                BeanUtils.copyProperties((Object)datum, (Object)supInfo, (String[])new String[]{"id", "createDate", "updateDate"});
                supInfo.setSourceId(datum.getId());
                supInfo.setSourceCreateTime(datum.getCreateTime());
                supInfo.setSourceUpdateTime(datum.getUpdateTime());
                supInfo.setCid(this.companyService.getCidByCode(datum.getCreditCode()));
                supInfo.setCreateDate(LocalDateTime.now());
                supInfo.setUpdateDate(LocalDateTime.now());
                supInfoList.add(supInfo);
                delSourceIdList.add(datum.getId());
            }
            UpdateWrapper update = Wrappers.update();
            update.in((Object)"source_id", delSourceIdList);
            ((SupervisionSupInfoMapper)this.baseMapper).delete((Wrapper)update);
            return supInfoList;
        }
        log.error("dataJson \u4e3a\u7a7a");
        return null;
    }

    @Override
    public String getTableNameEn() {
        return "za_yrdw_jbxx_jdxx";
    }

    @Override
    public SupervisionSupInfo getLatelyDataBySourceCreateTime() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.orderByDesc(SupervisionSupInfo::getSourceUpdateTime)).last("limit 1");
        return (SupervisionSupInfo)((SupervisionSupInfoMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
    }

    private Boolean getIsExistBySourceId(String sourceId) {
        if (sourceId == null) {
            return false;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SupervisionSupInfo::getSourceId, (Object)sourceId);
        SupervisionSupInfo info = (SupervisionSupInfo)((SupervisionSupInfoMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        return info != null && info.getSourceId() != null;
    }
}

