/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.supervisionexelaw.serviceimpl;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.services.config.property.SupervisionExeLawProperties;
import cn.smarthse.services.supervisionexelaw.model.ResponseResult;
import cn.smarthse.services.supervisionexelaw.model.SupervisionExeLawParamModel;
import cn.smarthse.services.supervisionexelaw.service.ISupervisionApiBaseService;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SupervisionApiBaseServiceImpl<D extends BaseMapper<T>, T>
extends ServiceImpl<D, T>
implements ISupervisionApiBaseService<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SupervisionApiBaseServiceImpl.class);
    @Autowired
    SupervisionExeLawProperties supervisionExeLawProperties;
    @Autowired(required=false)
    private D d;
    ConcurrentHashMap dataMap = new ConcurrentHashMap();
    private static CloseableHttpClient httpClient = HttpClients.custom().setMaxConnPerRoute(10).setMaxConnTotal(20).evictIdleConnections(60L, TimeUnit.SECONDS).build();

    @Override
    public List check(List list) {
        return null;
    }

    @Override
    public T getLatelyInfoBySourceCreateTime() {
        T t = this.getLatelyDataBySourceCreateTime();
        return t;
    }

    @Override
    public void dataProcessing(String queryCondition) throws UnsupportedEncodingException {
        String tableNameEn = this.getTableNameEn();
        ResponseResult responseText = this.getDataFormApiUrl(tableNameEn, 1, queryCondition);
        if (responseText != null && responseText.getTotalPages() != null) {
            Integer totalPages = responseText.getTotalPages().intValue();
            List<T> ts = this.convertObj(responseText);
            if (CollectionUtils.isNotEmpty(ts)) {
                this.saveBatch(ts, 1000);
            }
            if (totalPages != null && totalPages > 1) {
                for (int i = 2; i <= totalPages; ++i) {
                    ResponseResult response = this.getDataFormApiUrl(tableNameEn, i, queryCondition);
                    if (response == null) continue;
                    List<T> ts1 = this.convertObj(response);
                    if (!CollectionUtils.isNotEmpty(ts)) continue;
                    this.saveBatch(ts1, 1000);
                }
            }
        }
    }

    public abstract List<T> convertObj(ResponseResult var1);

    public abstract String getTableNameEn();

    public abstract T getLatelyDataBySourceCreateTime();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseResult getDataFormApiUrl(String tableNameEn, Integer page, String queryCondition) throws UnsupportedEncodingException {
        if (page == null) {
            page = 1;
        }
        SupervisionExeLawParamModel paramModel = new SupervisionExeLawParamModel(tableNameEn);
        paramModel.setUserInfo(this.supervisionExeLawProperties);
        paramModel.setPage(page);
        paramModel.setQueryCondition(queryCondition);
        HttpPost httpPost = new HttpPost(this.supervisionExeLawProperties.getApiurl());
        UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(this.getRequestParams(paramModel), "UTF-8");
        httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
        try {
            String s = EntityUtils.toString((HttpEntity)urlEncodedFormEntity, (String)"UTF-8");
            log.info("\u8bf7\u6c42\u4fe1\u606f\uff1a{}", (Object)s);
        }
        catch (IOException s) {
            // empty catch block
        }
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            JSONObject jsonObject;
            String responseText = EntityUtils.toString((HttpEntity)response.getEntity());
            if (StringUtils.isBlank((CharSequence)responseText)) {
                log.error("\u6ca1\u6709\u8fd4\u56de\u8bf7\u6c42\u5185\u5bb9..");
            }
            if ((jsonObject = JSONObject.parseObject((String)responseText)) == null) return null;
            boolean success = jsonObject.getBooleanValue("success");
            if (!success) {
                log.warn("\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c \u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)responseText);
            }
            String exceptionContent = jsonObject.getString("exceptionContent");
            String errorCode = jsonObject.getString("errorCode");
            String attachments = jsonObject.getString("attachments");
            JSONObject value = jsonObject.getJSONObject("value");
            ResponseResult responseResult2 = new ResponseResult();
            responseResult2.setAttachments(attachments);
            if (value != null) {
                Long totalPages = value.getLong("totalPages");
                Long currentPage = value.getLong("currentPage");
                String dataJson = value.getString("data");
                responseResult2.setCurrentPage(currentPage);
                responseResult2.setTotalPages(totalPages);
                responseResult2.setDataJson(dataJson);
            }
            responseResult2.setErrorCode(errorCode);
            responseResult2.setExceptionContent(exceptionContent);
            responseResult2.setSuccess(success);
            ResponseResult responseResult = responseResult2;
            return responseResult;
        }
        catch (Exception ex) {
            log.error("\u8bfb\u53d6\u6570\u636e\u63a5\u53e3\u9519\u8bef\uff1aurl:{}, tableNameEn:{}, ex:{}", new Object[]{this.supervisionExeLawProperties.getApiurl(), tableNameEn, ex});
        }
        return null;
    }

    private List<NameValuePair> getRequestParams(SupervisionExeLawParamModel paramModel) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("username", paramModel.getUsername()));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("password", paramModel.getPassword()));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("applyNo", paramModel.getApplyNo()));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("page", paramModel.getPage().toString()));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("tableNameEn", paramModel.getTableNameEn() == null ? "" : paramModel.getTableNameEn()));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("queryCondition", paramModel.getQueryCondition() == null ? "" : paramModel.getQueryCondition()));
        return nameValuePairs;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }));
    }
}

