/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.shiro;

import cn.smarthse.services.onlinemonitoring.entity.user.UserInfo;
import cn.smarthse.services.shiro.JWTUtils;
import cn.smarthse.services.shiro.ShiroUsernamePasswordToken;
import cn.smarthse.services.support.ResponseData2;
import cn.smarthse.util.common.StringUtils;
import cn.smarthse.web.common.enums.StatusCodeEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import com.auth0.jwt.JWTCreator;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroFormAuthenticationFilter
extends FormAuthenticationFilter {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public String getUsernameParam() {
        return "appId";
    }

    public String getPasswordParam() {
        return "appSecret";
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        String username = this.getUsername(request);
        String password = this.getPassword(request);
        if (password == null) {
            password = "";
        }
        boolean rememberMe = this.isRememberMe(request);
        String host = request.getRemoteAddr();
        this.logger.info("\u8868\u5355\u767b\u5f55\u8fc7\u6ee4\u5668\uff1a\uff1a\uff1ausername:{}, password:{}, host:{}", new Object[]{username, password, host});
        return new ShiroUsernamePasswordToken(username, password.toCharArray(), rememberMe, host);
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        ShiroUsernamePasswordToken r_token = (ShiroUsernamePasswordToken)token;
        UserInfo auser = r_token.getAppUser();
        JWTCreator.Builder builder = JWTUtils.getBuilder();
        builder.withClaim("appId", auser.getAppId());
        String jwttoken = JWTUtils.sign(builder);
        ResponseData2<String> r = new ResponseData2<String>();
        r.setState(StatusCodeEnum.SUCCESS);
        r.setResult(jwttoken);
        httpServletResponse.setCharacterEncoding("UTF-8");
        PrintWriter out = httpServletResponse.getWriter();
        SerializeConfig serializeConfig = new SerializeConfig();
        JSONWriter.Context context = new JSONWriter.Context(new ObjectWriterProvider(), new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat});
        context.setDateFormat("yyyy-MM-dd HH:mm:ss");
        out.println(JSON.toJSONString(r, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteEnumUsingToString}));
        out.flush();
        out.close();
        return false;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String className = ((Object)((Object)e)).getClass().getName();
        String message = "";
        e.printStackTrace();
        this.logger.error("\u767b\u5f55\u5931\u8d25\uff1a{}", (Object)className);
        if (IncorrectCredentialsException.class.getName().equals(className) || UnknownAccountException.class.getName().equals(className)) {
            message = "appId\u6216appSecret\u9519\u8bef, \u8bf7\u91cd\u8bd5.";
        } else if (AuthenticationException.class.getName().equals(className)) {
            message = StringUtils.replace((String)e.getMessage(), (String)"msg:", (String)"");
        } else if (e.getMessage() != null && StringUtils.startsWith((CharSequence)e.getMessage(), (CharSequence)"msg:")) {
            message = StringUtils.replace((String)e.getMessage(), (String)"msg:", (String)"");
        } else if (ExcessiveAttemptsException.class.getName().equals(className)) {
            message = "\u5c1d\u8bd5\u6b21\u6570\u8fc7\u591a, \u5df2\u9501\u5b9a\uff01";
        } else if (LockedAccountException.class.getName().equals(className)) {
            message = "\u767b\u5f55\u6b21\u6570\u8fc7\u591a\uff0c\u7981\u6b62\u767b\u5f55";
        } else {
            message = "\u7cfb\u7edf\u51fa\u73b0\u70b9\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01";
            e.printStackTrace();
        }
        ResponseData2 r = new ResponseData2();
        r.setState(StatusCodeEnum.FAIL);
        r.setContent(message);
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.setContentType("text/json; charset=UTF-8");
        PrintWriter out = null;
        try {
            out = httpServletResponse.getWriter();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        out.println(JSON.toJSONString(r));
        out.flush();
        out.close();
        return false;
    }
}

