/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.shiro;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.services.onlinemonitoring.entity.client.OnlineMonitorClient;
import cn.smarthse.services.onlinemonitoring.entity.user.UserInfo;
import cn.smarthse.services.onlinemonitoring.service.client.IOnlineMonitorClientService;
import cn.smarthse.services.shiro.ShiroUsernamePasswordToken;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShiroAuthorizingRealm
extends AuthorizingRealm {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    IOnlineMonitorClientService clientService;

    public ShiroAuthorizingRealm() {
        this.setAuthenticationTokenClass(ShiroUsernamePasswordToken.class);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) throws AuthenticationException {
        OnlineMonitorClient client;
        ShiroUsernamePasswordToken token = (ShiroUsernamePasswordToken)authcToken;
        String username = token.getUsername();
        if (StringUtils.isEmpty((CharSequence)username)) {
            throw new AuthenticationException("\u767b\u5f55\u8d26\u53f7\u4e3a\u7a7a");
        }
        String credentials = "";
        if (token.getLoginType() == 6) {
            // empty if block
        }
        if ((client = this.clientService.getClient(username)) == null) {
            throw new AuthenticationException("\u767b\u5f55\u5931\u8d25\uff1a\u8d26\u53f7\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        Set<Long> clientAreaId = this.clientService.getClientAreaId(client.getId());
        UserInfo userInfo = new UserInfo();
        userInfo.setCid(client.getCid());
        token.setAppUser(userInfo);
        userInfo.setAreaIdSet(clientAreaId);
        credentials = client.getAppSecret();
        return new SimpleAuthenticationInfo((Object)userInfo, (Object)credentials, this.getName());
    }

    @PostConstruct
    public void initCredentialsMatcher() {
    }

    protected void checkPermission(Permission permission, AuthorizationInfo info) {
        this.authorizationValidate(permission);
        super.checkPermission(permission, info);
    }

    protected boolean[] isPermitted(List<Permission> permissions, AuthorizationInfo info) {
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission permission : permissions) {
                this.authorizationValidate(permission);
            }
        }
        return super.isPermitted(permissions, info);
    }

    public boolean isPermitted(PrincipalCollection principals, Permission permission) {
        this.authorizationValidate(permission);
        return super.isPermitted(principals, permission);
    }

    protected boolean isPermittedAll(Collection<Permission> permissions, AuthorizationInfo info) {
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission permission : permissions) {
                this.authorizationValidate(permission);
            }
        }
        return super.isPermittedAll(permissions, info);
    }

    private void authorizationValidate(Permission permission) {
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }
}

