/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.shiro;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.passwordLog.Md5Utils;
import cn.smarthse.services.shiro.ShiroUsernamePasswordToken;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.springframework.beans.factory.annotation.Autowired;

public class ShiroAuthorizingCredentialsMatcher
extends HashedCredentialsMatcher {
    private int retryCount = 3;
    private int retryFailCount = 10;
    @Autowired
    private RedisClient redisClient;
    private String passwordRetryCacheName = "passwordRetryCache";
    private static final String vcodeCacheName = "vcodeCache";

    public boolean doCredentialsMatch(AuthenticationToken atoken, AuthenticationInfo info) {
        String password;
        AtomicInteger retryAtomicCount;
        int currentCount;
        ShiroUsernamePasswordToken token = (ShiroUsernamePasswordToken)atoken;
        String username = (String)token.getPrincipal();
        String keyName = "onlinemonitor-service" + Md5Utils.hash((String)username);
        Object retryCacheCount = this.redisClient.get(keyName);
        if (retryCacheCount == null) {
            retryCacheCount = new AtomicInteger(0);
            this.redisClient.set(keyName, retryCacheCount, 1800L);
        }
        if ((currentCount = (retryAtomicCount = (AtomicInteger)retryCacheCount).incrementAndGet()) > this.retryFailCount) {
            throw new ExcessiveAttemptsException();
        }
        if (currentCount > this.retryCount) {
            throw new LockedAccountException();
        }
        String credentials = (String)info.getCredentials();
        boolean matches = Objects.equals(credentials, password = new String(token.getPassword()));
        if (matches) {
            this.redisClient.del(new String[]{keyName});
        } else {
            this.redisClient.set(keyName, retryCacheCount, 1800L);
            if (currentCount == this.retryCount) {
                throw new LockedAccountException();
            }
        }
        return matches;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getRetryFailCount() {
        return this.retryFailCount;
    }

    public void setRetryFailCount(int retryFailCount) {
        this.retryFailCount = retryFailCount;
    }

    public String getPasswordRetryCacheName() {
        return this.passwordRetryCacheName;
    }

    public void setPasswordRetryCacheName(String passwordRetryCacheName) {
        this.passwordRetryCacheName = passwordRetryCacheName;
    }
}

