/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.shiro;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.services.config.property.JwtProperties;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JWTUtils {
    private static JwtProperties jwtProperties;

    @Autowired
    public void setProjectProperties(JwtProperties jwtProperties) {
        JWTUtils.jwtProperties = jwtProperties;
    }

    public static JWTCreator.Builder getBuilder() throws IllegalArgumentException, UnsupportedEncodingException {
        JWTCreator.Builder builder = JWT.create();
        HashMap headerClaims = new HashMap();
        builder.withHeader(headerClaims);
        builder.withIssuer(jwtProperties.getIssuer());
        builder.withExpiresAt(DateUtils.addWeeks((Date)new Date(), (int)1));
        return builder;
    }

    public static String sign(JWTCreator.Builder builder) throws IllegalArgumentException, UnsupportedEncodingException {
        Algorithm algorithm = Algorithm.HMAC256((String)jwtProperties.getTokensecret());
        return builder.sign(algorithm);
    }

    public static DecodedJWT verify(String token) throws IllegalArgumentException, UnsupportedEncodingException {
        Algorithm algorithm = Algorithm.HMAC256((String)jwtProperties.getTokensecret());
        JWTVerifier.BaseVerification verification = (JWTVerifier.BaseVerification)JWT.require((Algorithm)algorithm);
        verification.withIssuer(jwtProperties.getIssuer());
        JWTVerifier verifier = verification.build();
        return verifier.verify(token);
    }
}

