/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.shiro;

import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.services.onlinemonitoring.entity.client.OnlineMonitorClient;
import cn.smarthse.services.onlinemonitoring.entity.user.UserInfo;
import cn.smarthse.services.onlinemonitoring.service.client.IOnlineMonitorClientService;
import cn.smarthse.services.onlinemonitoring.serviceimp.company.CompanyServiceImpl;
import cn.smarthse.services.shiro.JWTUtils;
import cn.smarthse.services.support.AreaUtils;
import cn.smarthse.services.support.ResponseData2;
import cn.smarthse.services.support.UserUtils;
import cn.smarthse.web.common.enums.StatusCodeEnum;
import com.auth0.jwt.exceptions.InvalidClaimException;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.web.servlet.AdviceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppAuthFilter
extends AdviceFilter {
    private static final Logger log = LoggerFactory.getLogger(AppAuthFilter.class);
    public static final String DEFAULT_AUTH_TOKEN_PARAM = "token";
    public static final String ONLINEDEVICE_WHITELIST_CACHENAME = "ONLINEDEVICE_WHITELIST";

    public static String getRemoteAddr(HttpServletRequest request) {
        String remoteAddr = request.getHeader("X-Real-IP");
        if (StringUtils.isNotBlank((CharSequence)remoteAddr)) {
            remoteAddr = request.getHeader("X-Forwarded-For");
        } else if (StringUtils.isNotBlank((CharSequence)remoteAddr)) {
            remoteAddr = request.getHeader("Proxy-Client-IP");
        } else if (StringUtils.isNotBlank((CharSequence)remoteAddr)) {
            remoteAddr = request.getHeader("WL-Proxy-Client-IP");
        }
        return remoteAddr != null ? remoteAddr : request.getRemoteAddr();
    }

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest hrequest = (HttpServletRequest)request;
        String tokenHeader = hrequest.getHeader(DEFAULT_AUTH_TOKEN_PARAM);
        String cid = hrequest.getHeader("cid");
        String requestURI = hrequest.getRequestURI();
        if (Objects.equals(requestURI, "/") || Objects.equals(requestURI, "/csrf")) {
            return true;
        }
        CompanyServiceImpl companyService = (CompanyServiceImpl)SpringContextHolder.getBean(CompanyServiceImpl.class);
        IOnlineMonitorClientService clientService = (IOnlineMonitorClientService)SpringContextHolder.getBean(IOnlineMonitorClientService.class);
        if (StringUtils.isBlank((CharSequence)tokenHeader)) {
            throw new AuthenticationException("\u6ca1\u627e\u5230JWT\u4ee4\u724c\u53c2\u6570");
        }
        UserInfo user = new UserInfo();
        try {
            DecodedJWT jwt = JWTUtils.verify(tokenHeader);
            if (!jwt.getClaim("appId").isNull()) {
                user.setAppId(jwt.getClaim("appId").asString());
            }
            if (!jwt.getClaim("areaIds").isNull()) {
                String areaIds = jwt.getClaim("areaIds").asString();
                List longs = CommonUtil.str2LongList((String)areaIds, (String)",");
                user.setAreaIdSet(new HashSet<Long>(longs));
            }
            if (StringUtils.isNumeric((CharSequence)cid)) {
                user.setCid(Long.parseLong(cid));
            }
            OnlineMonitorClient client = clientService.getClient(user.getAppId());
            user.setClientId(client.getId());
            UserUtils.setCurrentUser(user);
        }
        catch (TokenExpiredException e) {
            throw new AuthenticationException("token \u4ee4\u724c\u8fc7\u671f");
        }
        catch (InvalidClaimException e) {
            throw new AuthenticationException("token \u4ee4\u724c\u65e0\u6548");
        }
        catch (JWTDecodeException e) {
            throw new AuthenticationException("token \u4ee4\u724c\u683c\u5f0f\u9519\u8bef");
        }
        catch (SignatureVerificationException e) {
            throw new AuthenticationException("token \u4ee4\u724c\u7b7e\u540d\u65e0\u6548");
        }
        catch (IllegalArgumentException e) {
            throw new AuthenticationException("token \u4ee4\u724c\u53c2\u6570\u5f02\u5e38");
        }
        catch (Exception e) {
            throw new AuthenticationException("token \u4ee4\u724c\u9519\u8bef");
        }
        if (StringUtils.isNumeric((CharSequence)cid)) {
            Set<Long> areaIdSet = user.getAreaIdSet();
            if (CollectionUtils.isEmpty(areaIdSet)) {
                throw new BusinessException("\u8d26\u53f7\u672a\u5173\u8054\u7ba1\u8f96\u533a\u57df\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u51b3\uff01");
            }
            Long areaId = companyService.getAreaIdByCid(Long.parseLong(cid));
            if (areaId == null) {
                areaId = companyService.getHospitalAreaIdByCid(Long.parseLong(cid));
            }
            if (areaId == null) {
                throw new BusinessException("\u627e\u4e0d\u5230\u8be5\u4f01\u4e1a\u6240\u5c5e\u533a\u57df\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u51b3\uff01");
            }
            boolean hasAuth = false;
            for (Long aLong : areaIdSet) {
                boolean authArea = AreaUtils.containAuthArea(areaId, aLong);
                if (!authArea) continue;
                hasAuth = true;
            }
            if (!hasAuth) {
                throw new BusinessException("\u6dfb\u52a0\u6570\u636e\u7684\u4f01\u4e1a\u4e0d\u5728\u8d26\u53f7\u7ba1\u8f96\u8303\u56f4\u5185\uff0c \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u51b3\uff01");
            }
        }
        return true;
    }

    protected void postHandle(ServletRequest request, ServletResponse response) {
    }

    public void afterCompletion(ServletRequest request, ServletResponse response, Exception exception) throws Exception {
        UserUtils.remove();
        if (exception != null) {
            ResponseData2 r = new ResponseData2();
            r.setState(StatusCodeEnum.FAIL);
            r.setContent(exception.getMessage());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/json; charset=UTF-8");
            ServletOutputStream output = response.getOutputStream();
            ObjectMapper mapper = new ObjectMapper();
            output.write(mapper.writeValueAsString(r).getBytes());
            output.flush();
            output.close();
        }
    }
}

