/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.onlinemonitoring.serviceimp.company;

import cn.smarthse.modules.datacentre.model.CompanySearchModel;
import cn.smarthse.modules.health.entity.base.company.CompanyBaseInfo;
import cn.smarthse.services.onlinemonitoring.mapper.company.CompanyMapper;
import cn.smarthse.services.onlinemonitoring.vo.query.company.CompanyQueryVo;
import cn.smarthse.services.supervisionexelaw.entity.CompanyVo;
import cn.smarthse.util.common.StringUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="companyServiceImpl")
public class CompanyServiceImpl {
    @Autowired
    CompanyMapper companyMapper;
    private Cache<String, Map<String, Long>> commonCache = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.HOURS).maximumSize(Integer.MAX_VALUE).build();
    private Cache<Long, Long> companyAreaCache = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.HOURS).maximumSize(Integer.MAX_VALUE).build();

    public CompanyBaseInfo getCidByNameCode(String name, String code) {
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.companyMapper.getCidByNameCode(name, code);
    }

    public CompanyBaseInfo getHospitalId(CompanyQueryVo companyQueryVo) {
        if (StringUtils.isBlank((CharSequence)companyQueryVo.getCompanyName())) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)companyQueryVo.getUnifiedCreditCode())) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)companyQueryVo.getMedicalCode())) {
            return null;
        }
        return this.companyMapper.getHospitalId(companyQueryVo);
    }

    public Long getAreaIdByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        Long areaId = (Long)this.companyAreaCache.get((Object)cid, key -> this.companyMapper.getAreaIdByCid((Long)key));
        return areaId;
    }

    public Long getHospitalAreaIdByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        return this.companyMapper.getHospitalAreaIdByCid(cid);
    }

    public Long getCidByCode(String code) {
        Long cid;
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        String cacheKey = "unifiedSocialCcCacheKey";
        Map<String, Long> codeMap = (Map<String, Long>)this.commonCache.getIfPresent((Object)cacheKey);
        if (codeMap == null) {
            codeMap = this.getComCodeMap();
            this.commonCache.put((Object)cacheKey, codeMap);
        }
        if ((cid = codeMap.get(code)) != null) {
            return cid;
        }
        cid = this.companyMapper.getCidByCode(code);
        codeMap.put(code, cid);
        this.commonCache.put((Object)cacheKey, codeMap);
        return cid;
    }

    private Map<String, Long> getComCodeMap() {
        HashMap<String, Long> codeMap = new HashMap<String, Long>();
        CompanySearchModel searchModel = new CompanySearchModel();
        List<CompanyVo> list = this.companyMapper.getCompanyList();
        for (CompanyVo l : list) {
            codeMap.put(l.getUnifiedCreditCode(), l.getCid());
        }
        return codeMap;
    }

    public Integer getCompanyTypeByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        if (this.companyMapper.getCompanyByCid(cid) != null) {
            return 1;
        }
        if (this.companyMapper.getHospitalByCid(cid) != null) {
            return 2;
        }
        return null;
    }
}

