/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.onlinemonitoring.controller.reform;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.modules.health.onlineMonitoring.service.reform.IOnlineReformService;
import cn.smarthse.modules.health.onlineMonitoring.vo.reform.ReformDeviceVo;
import cn.smarthse.modules.health.onlineMonitoring.vo.reform.ReportRectVo;
import cn.smarthse.modules.health.onlineMonitoring.vo.reform.ReportRiskParam;
import cn.smarthse.services.onlinemonitoring.serviceimp.reform.OnlineMonitorReformServiceImpl;
import cn.smarthse.services.support.ResponseData2;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/online/monitor"})
public class OnlineDeviceReformController {
    @DubboReference(retries=0)
    private IOnlineReformService onlineReformService;
    @Autowired
    OnlineMonitorReformServiceImpl onlineMonitorReformService;

    @PostMapping(value={"/reportRectificationData"})
    @Log(title="\u5728\u7ebf\u76d1\u6d4b-\u9690\u60a3\u6570\u636e\u4e0a\u62a5")
    public ResponseData2<ReportRectVo> reportRectificationData(@RequestBody ReformDeviceVo vo, HttpServletRequest request) {
        if (Objects.isNull(vo)) {
            return ResponseData2.fail("\u4f20\u53c2\u4e0d\u6b63\u786e");
        }
        return ResponseData2.success(null, "\u8be5\u63a5\u53e3\u6682\u672a\u5f00\u901a\uff0c\u8bf7\u4e0e\u7ba1\u7406\u4eba\u5458\u8054\u7cfb");
    }

    @PostMapping(value={"/reportRectPlanData"})
    @Log(title="\u5728\u7ebf\u76d1\u6d4b-\u9690\u60a3\u6574\u6539\u4e0e\u9a8c\u6536\u6570\u636e\u4e0a\u62a5")
    public ResponseData2<ReportRectVo> reportRectPlanData(@RequestBody ReportRectVo vo, HttpServletRequest request) {
        if (Objects.isNull(vo)) {
            return ResponseData2.fail("\u4f20\u53c2\u4e0d\u6b63\u786e");
        }
        return ResponseData2.success(null, "\u8be5\u63a5\u53e3\u6682\u672a\u5f00\u901a\uff0c\u8bf7\u4e0e\u7ba1\u7406\u4eba\u5458\u8054\u7cfb");
    }

    @PostMapping(value={"/reportRisk"})
    @Log(title="\u5728\u7ebf\u76d1\u6d4b-\u8d85\u6807\u98ce\u9669\u62a5\u8b66\u63a5\u53e3")
    public ResponseData2<ReportRiskParam> reportRisk(@RequestBody ReportRiskParam param, HttpServletRequest request) {
        if (Objects.isNull(param)) {
            return ResponseData2.fail("\u4f20\u53c2\u4e0d\u6b63\u786e");
        }
        Long cid = Long.parseLong(request.getHeader("cid"));
        Boolean matching = this.onlineReformService.deviceIdCidIsMatching(cid, param.getDeviceId());
        if (!matching.booleanValue()) {
            return ResponseData2.fail("\u8bbe\u5907id\u548c\u4f01\u4e1a\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        param.setCid(cid);
        this.onlineReformService.reportRisk(param);
        return ResponseData2.success(param);
    }
}

