/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.onlinemonitoring.controller.realdata;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.modules.health.onlineMonitoring.entity.realdata.OnlineMonitorRealData;
import cn.smarthse.modules.health.onlineMonitoring.service.device.IOnlineMonitorDeviceFactorService;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDevice;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceRealData;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceRealDataService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import cn.smarthse.services.onlinemonitoring.entity.user.UserInfo;
import cn.smarthse.services.onlinemonitoring.vo.OnlineMonitorRealFormData;
import cn.smarthse.services.support.ResponseData2;
import cn.smarthse.services.support.UserUtils;
import cn.smarthse.util.common.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/online/monitor"})
public class RealDataController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RealDataController.class);
    @DubboReference
    IOnlineDeviceRealDataService realDataService;
    @DubboReference
    IOnlineDeviceService onlineDeviceService;
    @DubboReference
    IOnlineMonitorDeviceFactorService deviceFactorService;
    @Autowired
    RedisClient redisClient;
    private static final String DEVICE_REALDATA_LIMITKEY = "device_realdata_limitkey";
    List<Integer> dataList = Arrays.asList(1002, 1003, 2001, 3001, 4001, 4002, 5001, 9001);

    @PostMapping(value={"/report"})
    public ResponseData2<Integer> report(@RequestBody OnlineMonitorRealFormData realData) throws BusinessException {
        if (realData == null) {
            return ResponseData2.fail("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UserInfo currentUser = UserUtils.getCurrentUser();
        if (currentUser.getCid() == null) {
            return ResponseData2.fail("\u7f3a\u5931cid\u53c2\u6570");
        }
        if (CollectionUtils.isEmpty(realData.getValue())) {
            return ResponseData2.fail("\u503c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<OnlineDeviceRealData> onlineMonitorRealData = this.convertOnlineDeviceRealData(realData, currentUser.getCid());
        if (CollectionUtils.isEmpty(onlineMonitorRealData)) {
            return ResponseData2.success(0, "\u4e0a\u62a5\u6570\u636e\u4e3a\u7a7a");
        }
        int total = onlineMonitorRealData.size();
        List limitRealData = onlineMonitorRealData.stream().filter(f -> {
            Long deviceId = f.getDeviceId() == null ? 0L : f.getDeviceId();
            Long factorId = f.getFactorId() == null ? 0L : f.getFactorId();
            Integer dataType = f.getDataType() == null ? 0 : f.getDataType();
            String redisKey = DEVICE_REALDATA_LIMITKEY + String.valueOf(deviceId) + String.valueOf(factorId) + String.valueOf(dataType);
            Object o = this.redisClient.get(redisKey);
            if (this.redisClient.hasKey(redisKey)) {
                log.info("\u8bbe\u5907\u3010{}\u3011\u5b58\u5728\u8fde\u7eed\u6570\u636e\u4e0a\u62a5\uff0c\u9700\u95f4\u96945\u5206\u949f\u8fdb\u884c\u6570\u636e\u4e0a\u62a5", (Object)deviceId);
                return false;
            }
            this.redisClient.set(redisKey, (Object)1, 5L, TimeUnit.MINUTES);
            return true;
        }).collect(Collectors.toList());
        int limitTotal = limitRealData.size();
        int i = this.realDataService.handleRealMonitorData(limitRealData);
        return ResponseData2.success(i, total == limitTotal ? "\u4e0a\u62a5\u6210\u529f" : "\u5b58\u5728\u8fde\u7eed\u4e0a\u62a5\u6570\u636e\uff08\u540c\u4e2a\u8bbe\u5907\u6570\u636e\u9700\u95f4\u96945\u5206\u949f\u518d\u4e0a\u62a5\uff09\uff0c\u5df2\u8fc7\u6ee4");
    }

    public List<OnlineDeviceRealData> convertOnlineDeviceRealData(OnlineMonitorRealFormData realData, Long cid) throws BusinessException {
        if (CollectionUtils.isNotEmpty(realData.getValue())) {
            String deviceNo = realData.getDeviceNo();
            OnlineDevice onlineDevice = this.onlineDeviceService.getCacheByDeviceNo(deviceNo, cid);
            if (onlineDevice == null) {
                throw new BusinessException("\u8bbe\u5907\u7f16\u53f7\u3010" + deviceNo + "\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u6dfb\u52a0\u8bbe\u5907\u4fe1\u606f");
            }
            if (Objects.equals(onlineDevice.getType(), (byte)3)) {
                throw new BusinessException("\u8bbe\u5907\u7f16\u53f7\u3010" + deviceNo + "\u3011\u4e3a\u76d1\u63a7\u8bbe\u5907\uff0c\u65e0\u6cd5\u4e0a\u62a5\u76d1\u6d4b\u6570\u636e");
            }
            Set factorIdSet = this.deviceFactorService.getFactorMapByDeviceId(onlineDevice.getId());
            if (CollectionUtils.isEmpty((Collection)factorIdSet)) {
                throw new BusinessException("\u8bbe\u5907id\u3010" + onlineDevice.getId() + "\u3011\u8bbe\u5907\u7f16\u53f7\u3010" + deviceNo + "\u3011\u672a\u5173\u8054\u5371\u5bb3\u56e0\u7d20");
            }
            List<OnlineMonitorRealData> realDataList = realData.getValue();
            if (CollectionUtils.isNotEmpty(realDataList)) {
                ArrayList<OnlineDeviceRealData> result = new ArrayList<OnlineDeviceRealData>();
                for (OnlineMonitorRealData r : realDataList) {
                    OnlineDeviceRealData rd = new OnlineDeviceRealData();
                    rd.setVData(r.getDataValue().toString());
                    Date date = new Date();
                    if (realData.getTime() != null) {
                        date = new Date(realData.getTime());
                    }
                    rd.setMonitorTime(date);
                    rd.setDataSource(Integer.valueOf(2));
                    if (!factorIdSet.contains(r.getFactorId())) {
                        throw new BusinessException("\u8bbe\u5907id\u3010" + onlineDevice.getId() + "\u3011\u8bbe\u5907\u7f16\u53f7\u3010" + deviceNo + "\u3011\u5371\u5bb3\u56e0\u7d20\u3010" + r.getFactorId() + "\u3011\u4e0e\u8bbe\u5907\u5bf9\u5e94\u7684\u5371\u5bb3\u56e0\u7d20\u3010" + StringUtils.join((Iterable)factorIdSet, (String)",") + "\u3011\u4e0d\u4e00\u81f4");
                    }
                    rd.setFactorId(r.getFactorId());
                    if (!this.dataList.contains(r.getDataType())) {
                        throw new BusinessException("\u76d1\u6d4b\u7c7b\u578b\u3010" + r.getDataType() + "\u3011\u586b\u5199\u9519\u8bef");
                    }
                    rd.setDataType(r.getDataType());
                    rd.setDeviceId(onlineDevice.getId());
                    result.add(rd);
                }
                return result;
            }
        }
        return null;
    }
}

