/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.onlinemonitoring.controller.login;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.util.MD5Utils;
import cn.smarthse.services.onlinemonitoring.entity.client.OnlineMonitorClient;
import cn.smarthse.services.onlinemonitoring.entity.user.UserInfo;
import cn.smarthse.services.onlinemonitoring.service.client.IOnlineMonitorClientService;
import cn.smarthse.services.onlinemonitoring.vo.LoginFormData;
import cn.smarthse.services.shiro.JWTUtils;
import cn.smarthse.services.shiro.ShiroUsernamePasswordToken;
import cn.smarthse.services.support.ResponseData2;
import cn.smarthse.util.common.StringUtils;
import com.auth0.jwt.JWTCreator;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/online/monitor"})
public class LoginController {
    @Autowired
    IOnlineMonitorClientService onlineMonitorClientService;

    @Log(title="\u5728\u7ebf\u76d1\u6d4b-\u83b7\u53d6token")
    @PostMapping(value={"/getToken"})
    public ResponseData2<String> getToken(@RequestBody(required=false) LoginFormData loginFormData) throws UnsupportedEncodingException {
        if (loginFormData == null) {
            return ResponseData2.fail("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4f20\u53c2\u65b9\u5f0f!");
        }
        if (loginFormData == null || StringUtils.isBlank((CharSequence)loginFormData.getAppId()) || StringUtils.isBlank((CharSequence)loginFormData.getAppSecret())) {
            return ResponseData2.fail("appId\u6216appSecret\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ShiroUsernamePasswordToken shiroUsernamePasswordToken = new ShiroUsernamePasswordToken(1);
        shiroUsernamePasswordToken.setUsername(loginFormData.getAppId());
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.select((Object[])new String[]{"salt"})).eq((Object)"app_id", (Object)loginFormData.getAppId());
        OnlineMonitorClient onlineMonitorClient = (OnlineMonitorClient)this.onlineMonitorClientService.getOne((Wrapper)wrapper);
        if (onlineMonitorClient != null) {
            String pwd = MD5Utils.getMD5String((String)loginFormData.getAppSecret());
            String pwdSalt = MD5Utils.getMD5String((String)(pwd + onlineMonitorClient.getSalt()));
            shiroUsernamePasswordToken.setPassword(pwdSalt.toCharArray());
        }
        try {
            SecurityUtils.getSubject().login((AuthenticationToken)shiroUsernamePasswordToken);
        }
        catch (ExcessiveAttemptsException e) {
            return ResponseData2.fail("\u5c1d\u8bd5\u6b21\u6570\u8fc7\u591a, \u5df2\u9501\u5b9a\uff01");
        }
        catch (LockedAccountException e) {
            return ResponseData2.fail("\u767b\u5f55\u6b21\u6570\u8fc7\u591a\uff0c\u7981\u6b62\u767b\u5f55!");
        }
        catch (IncorrectCredentialsException e) {
            return ResponseData2.fail("appId\u6216appSecret\u4e0d\u6b63\u786e\uff0c\u8bf7\u6838\u5b9e\u4fe1\u606f!");
        }
        catch (UnknownAccountException e) {
            return ResponseData2.fail("appId\u6216appSecret\u4e0d\u6b63\u786e\uff0c\u8bf7\u6838\u5b9e\u4fe1\u606f!");
        }
        catch (AuthenticationException e) {
            return ResponseData2.fail("appId\u6216appSecret\u4e0d\u6b63\u786e\uff0c\u8bf7\u6838\u5b9e\u4fe1\u606f!");
        }
        JWTCreator.Builder builder = JWTUtils.getBuilder();
        builder.withClaim("appId", loginFormData.getAppId());
        UserInfo userInfo = (UserInfo)SecurityUtils.getSubject().getPrincipal();
        builder.withClaim("areaIds", StringUtils.join(userInfo.getAreaIdSet(), (String)","));
        String jwttoken = JWTUtils.sign(builder);
        return ResponseData2.success(jwttoken);
    }

    public static byte[] generateSalt(int numBytes) {
        SecureRandom random = new SecureRandom();
        if (numBytes <= 0) {
            throw new RuntimeException("numBytes argument must be a positive integer (1 or larger)");
        }
        byte[] bytes = new byte[numBytes];
        random.nextBytes(bytes);
        return bytes;
    }
}

