/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.onlinemonitoring.controller.device;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.modules.health.onlineMonitoring.service.device.IOnlineMonitorNonstandardService;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceAiwarning;
import cn.smarthse.modules.health.supervise.enums.onlinedevice.RiskwarringTypeEnum;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceAiwarningService;
import cn.smarthse.services.onlinemonitoring.entity.user.UserInfo;
import cn.smarthse.services.support.ResponseData2;
import cn.smarthse.services.support.UserUtils;
import cn.smarthse.util.common.StringUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/online"})
public class OnlineDeviceNonstandardController {
    @DubboReference
    private IOnlineMonitorNonstandardService onlineDeviceNonstandardService;
    @DubboReference
    private IOnlineDeviceAiwarningService aiwarningService;
    private List<Integer> dataTypeList = Arrays.asList(1001, 1002, 1003, 2001, 2002, 2003, 2004, 3001);

    @Log(title="\u5728\u7ebf\u76d1\u6d4b-\u98ce\u9669\u9884\u8b66\u6570\u636e\u4e0a\u62a5")
    @PostMapping(value={"/camera/addNonstandardData"})
    public ResponseData2<OnlineDeviceAiwarning> addNonstandard(@RequestBody OnlineDeviceAiwarning onlineDeviceAlarm) throws IOException, BusinessException {
        if (onlineDeviceAlarm == null) {
            return ResponseData2.fail("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UserInfo currentUser = UserUtils.getCurrentUser();
        if (currentUser.getCid() == null) {
            return ResponseData2.fail("\u7f3a\u5931cid\u53c2\u6570");
        }
        if (StringUtils.isBlank((CharSequence)onlineDeviceAlarm.getDeviceNo())) {
            return ResponseData2.fail("\u7f3a\u5931\u8bbe\u5907\u7f16\u53f7\u53c2\u6570");
        }
        if (StringUtils.isBlank((CharSequence)onlineDeviceAlarm.getBackgroud())) {
            return ResponseData2.fail("\u7f3a\u5931\u98ce\u9669\u56fe\u7247\u53c2\u6570");
        }
        if (onlineDeviceAlarm.getDataType() == null) {
            return ResponseData2.fail("\u7f3a\u5931\u98ce\u9669\u7c7b\u578b\u53c2\u6570");
        }
        if (!this.dataTypeList.contains(onlineDeviceAlarm.getDataType())) {
            return ResponseData2.fail("\u98ce\u9669\u7c7b\u578b\u3010" + onlineDeviceAlarm.getDataType() + "\u3011\u53c2\u6570\u9519\u8bef");
        }
        Integer codeByApiCode = RiskwarringTypeEnum.getCodeByApiCode((Integer)onlineDeviceAlarm.getDataType());
        if (codeByApiCode == null) {
            return ResponseData2.fail("\u98ce\u9669\u7c7b\u578b\u3010" + onlineDeviceAlarm.getDataType() + "\u3011\u53c2\u6570\u9519\u8bef");
        }
        onlineDeviceAlarm.setDataType(codeByApiCode);
        if (onlineDeviceAlarm.getFindTime() == null) {
            return ResponseData2.fail("\u7f3a\u5931\u53d1\u73b0\uff08\u98ce\u9669\uff09\u65f6\u95f4\u53c2\u6570");
        }
        if (StringUtils.isBlank((CharSequence)onlineDeviceAlarm.getDeviceNo())) {
            return ResponseData2.fail("\u7f3a\u5931\u8bbe\u5907\u7f16\u53f7\u53c2\u6570");
        }
        return ResponseData2.success(null, "\u8be5\u63a5\u53e3\u6682\u672a\u5f00\u901a\uff0c\u8bf7\u4e0e\u7ba1\u7406\u4eba\u5458\u8054\u7cfb");
    }
}

