/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.onlinemonitoring.controller.device;

import cn.hutool.core.util.NumberUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.modules.health.onlineMonitoring.service.device.IOnlineMonitorDeviceFactorService;
import cn.smarthse.modules.health.onlineMonitoring.service.device.IOnlineMonitorWarningService;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceVo;
import cn.smarthse.modules.health.supervise.enums.onlinedevice.DeviceTypeEnum;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.device.OnlineDeviceBindVo;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.device.OnlineDeviceCameraVo;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.device.OnlineDeviceMonitorVo;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.device.OnlineDeviceStateVo;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.device.OnlineDeviceUpdateNoVo;
import cn.smarthse.services.onlinemonitoring.entity.user.UserInfo;
import cn.smarthse.services.onlinemonitoring.serviceimp.company.CompanyServiceImpl;
import cn.smarthse.services.support.ResponseData2;
import cn.smarthse.services.support.UserUtils;
import cn.smarthse.util.common.StringUtils;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/online"})
public class OnlineDeviceCameraController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OnlineDeviceCameraController.class);
    @Autowired
    private CompanyServiceImpl companyService;
    @DubboReference
    private IOnlineDeviceService onlineDeviceService;
    @DubboReference
    private IOnlineMonitorDeviceFactorService onlineMonitorDeviceFactorService;
    @DubboReference
    private IOnlineMonitorWarningService onlineMonitorWarningService;

    @Log(title="\u5728\u7ebf\u76d1\u6d4b-\u76d1\u6d4b\u8bbe\u5907\u6dfb\u52a0")
    @PostMapping(value={"/monitor/addDevice"})
    public ResponseData2<OnlineDeviceVo> monitorAddDevice(@RequestBody OnlineDeviceMonitorVo onlineDevice) throws BusinessException {
        OnlineDeviceVo vo = new OnlineDeviceVo();
        String deviceTypeHarmIdsJson = onlineDevice.getDeviceTypeHarmIdsJson();
        List<Object> deviceTypeHarmMap = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)deviceTypeHarmIdsJson)) {
            deviceTypeHarmMap = JSON.parseArray((String)deviceTypeHarmIdsJson, OnlineDeviceMonitorVo.class);
            deviceTypeHarmMap = deviceTypeHarmMap.stream().filter(m -> {
                Integer deviceType = m.getDeviceType();
                String harmFactorIds = m.getHarmFactorIds();
                List harmIdList = CommonUtil.str2LongList((String)harmFactorIds);
                return CollectionUtils.isNotEmpty((Collection)harmIdList) && deviceType != null;
            }).collect(Collectors.toList());
            vo.setDeviceTypeFactorIdList(deviceTypeHarmMap);
        }
        if (StringUtils.isBlank((CharSequence)onlineDevice.getHarmFactorIds()) && CollectionUtils.isEmpty(deviceTypeHarmMap)) {
            return ResponseData2.fail("\u76d1\u6d4b\u7684\u5371\u5bb3\u56e0\u7d20\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String harmFactorIds = onlineDevice.getHarmFactorIds();
        List harmIdList = CommonUtil.str2LongList((String)harmFactorIds);
        List harmIdList2 = deviceTypeHarmMap.stream().map(m -> CommonUtil.str2LongList((String)m.getHarmFactorIds())).flatMap(Collection::stream).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)harmIdList) && CollectionUtils.isEmpty(harmIdList2)) {
            return ResponseData2.fail("\u76d1\u6d4b\u7684\u5371\u5bb3\u56e0\u7d20\u7684id\u8f93\u5165\u975e\u6cd5");
        }
        BeanUtils.copyProperties((Object)onlineDevice, (Object)vo);
        if (CollectionUtils.isNotEmpty(deviceTypeHarmMap)) {
            StringBuffer sb = new StringBuffer("");
            for (OnlineDeviceMonitorVo onlineDeviceMonitorVo : deviceTypeHarmMap) {
                DeviceTypeEnum typeEnum = DeviceTypeEnum.getThisEnumByKey((Integer)onlineDeviceMonitorVo.getDeviceType());
                if (typeEnum == null) {
                    throw new BusinessException("\u8bbe\u5907\u7c7b\u578b\u3010" + onlineDeviceMonitorVo.getDeviceType() + "\u3011\u9519\u8bef");
                }
                onlineDeviceMonitorVo.setDeviceType(typeEnum.getValue());
                sb.append(typeEnum.getValue()).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            vo.setDeviceType(sb.toString());
            try {
                for (OnlineDeviceMonitorVo onlineDeviceMonitorVo : deviceTypeHarmMap) {
                    Integer deviceTypeTemp = onlineDeviceMonitorVo.getDeviceType();
                    String harmFactorIdsTemp = onlineDeviceMonitorVo.getHarmFactorIds();
                    this.onlineMonitorWarningService.assertAndInsert(harmFactorIdsTemp, deviceTypeTemp);
                }
            }
            catch (Exception e) {
                log.error("\u6dfb\u52a0\u8bbe\u5907\u5bf9\u5e94\u7684\u8bbe\u7f6e\u51fa\u9519\uff1a", (Throwable)e);
            }
        } else {
            DeviceTypeEnum typeEnum = DeviceTypeEnum.getThisEnumByKey((Integer)onlineDevice.getDeviceType());
            if (typeEnum == null) {
                throw new BusinessException("\u8bbe\u5907\u7c7b\u578b\u9519\u8bef");
            }
            vo.setDeviceType("" + typeEnum.getValue());
            try {
                this.onlineMonitorWarningService.assertAndInsert(harmFactorIds, onlineDevice.getDeviceType());
            }
            catch (Exception e) {
                log.error("\u6dfb\u52a0\u8bbe\u5907\u5bf9\u5e94\u7684\u8bbe\u7f6e\u51fa\u9519\uff1a", (Throwable)e);
            }
            ArrayList<OnlineDeviceMonitorVo> deviceTypeHarmMap2 = new ArrayList<OnlineDeviceMonitorVo>();
            OnlineDeviceMonitorVo onlineDeviceMonitorVo = new OnlineDeviceMonitorVo();
            onlineDeviceMonitorVo.setDeviceType(typeEnum.getValue());
            onlineDeviceMonitorVo.setHarmFactorIds(harmFactorIds);
            deviceTypeHarmMap2.add(onlineDeviceMonitorVo);
            vo.setDeviceTypeFactorIdList(deviceTypeHarmMap2);
        }
        return this.saveDevice(vo);
    }

    @Log(title="\u5728\u7ebf\u76d1\u6d4b-\u76d1\u63a7\u8bbe\u5907\u6dfb\u52a0")
    @PostMapping(value={"/camera/addDevice"})
    public ResponseData2<OnlineDeviceVo> cameraAddDevice(@RequestBody OnlineDeviceCameraVo onlineDevice) throws BusinessException {
        OnlineDeviceVo vo = new OnlineDeviceVo();
        BeanUtils.copyProperties((Object)onlineDevice, (Object)vo);
        vo.setDeviceType("3");
        return this.saveDevice(vo);
    }

    @PostMapping(value={"/monitor/bindDevice"})
    @Log(title="\u5728\u7ebf\u76d1\u6d4b-\u76d1\u6d4b\u76d1\u63a7\u8bbe\u5907\u7ed1\u5b9a")
    public ResponseData2<String> bindDevice(@RequestBody OnlineDeviceBindVo deviceBindVo) throws BusinessException {
        this.onlineDeviceService.bindDevice(deviceBindVo, UserUtils.getCurrentUser().getCid(), UserUtils.getCurrentUser().getClientId());
        return new ResponseData2<String>("\u7ed1\u5b9a\u6210\u529f");
    }

    @Log(title="\u5728\u7ebf\u76d1\u6d4b-\u8bbe\u5907\u72b6\u6001\u4fee\u6539\u63a5\u53e3")
    @PostMapping(value={"/device/state"})
    public ResponseData2<String> updatestate(@RequestBody OnlineDeviceStateVo stateVo) throws BusinessException {
        this.onlineDeviceService.updatestate(stateVo, UserUtils.getCurrentUser().getCid(), UserUtils.getCurrentUser().getClientId());
        return new ResponseData2<String>("\u4fee\u6539\u6210\u529f");
    }

    private ResponseData2<OnlineDeviceVo> saveDevice(OnlineDeviceVo onlineDevice) throws BusinessException {
        if (onlineDevice == null) {
            return ResponseData2.fail("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)onlineDevice.getDeviceId()) && !NumberUtil.isNumber((CharSequence)onlineDevice.getDeviceId())) {
            return ResponseData2.fail("deviceId\u53c2\u6570\u4f20\u5165\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)onlineDevice.getDeviceNo()) && StringUtils.isBlank((CharSequence)onlineDevice.getDeviceId())) {
            return ResponseData2.fail("\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UserInfo currentUser = UserUtils.getCurrentUser();
        if (currentUser.getCid() == null) {
            return ResponseData2.fail("\u7f3a\u5931cid\u53c2\u6570");
        }
        onlineDevice.setCid(currentUser.getCid());
        onlineDevice.setCreateBy(currentUser.getClientId());
        onlineDevice.setCompanyType(this.companyService.getCompanyTypeByCid(currentUser.getCid()));
        onlineDevice = this.onlineDeviceService.saveOrUpdateDevice(onlineDevice);
        return ResponseData2.success(onlineDevice);
    }

    @Log(title="\u5728\u7ebf\u76d1\u6d4b-\u66f4\u65b0\u76d1\u6d4b\u8bbe\u5907\u7f16\u53f7")
    @PostMapping(value={"/monitor/updateDeviceNo"})
    public ResponseData2<String> updateDeviceNo(@RequestBody OnlineDeviceUpdateNoVo onlineDevice) throws BusinessException {
        UserInfo currentUser = UserUtils.getCurrentUser();
        if (currentUser.getCid() == null) {
            return ResponseData2.fail("\u7f3a\u5931cid\u53c2\u6570");
        }
        onlineDevice.setCid(currentUser.getCid());
        if (StringUtils.isBlank((CharSequence)onlineDevice.getDeviceNo())) {
            return ResponseData2.fail("\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)onlineDevice.getNewDeviceNo())) {
            return ResponseData2.fail("\u8bbe\u5907\u65b0\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        onlineDevice.setUpdateBy(currentUser.getClientId());
        int updater = this.onlineDeviceService.updateDeviceNo(onlineDevice);
        return ResponseData2.success(String.format("\u66f4\u65b0%d\u6761\u6570\u636e", updater));
    }
}

