/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.onlinemonitoring.controller.company;

import cn.smarthse.modules.health.entity.base.company.CompanyBaseInfo;
import cn.smarthse.services.onlinemonitoring.serviceimp.company.CompanyServiceImpl;
import cn.smarthse.services.onlinemonitoring.vo.query.company.CompanyQueryVo;
import cn.smarthse.services.support.AreaUtils;
import cn.smarthse.services.support.ResponseData2;
import cn.smarthse.services.support.UserUtils;
import cn.smarthse.util.common.StringUtils;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/online/monitor"})
public class CompanyController {
    @Autowired
    CompanyServiceImpl companyService;

    @PostMapping(value={"/getCid"})
    public ResponseData2<String> reportRectificationData(@RequestBody CompanyQueryVo companyQueryVo) {
        if (companyQueryVo == null) {
            return ResponseData2.fail("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (companyQueryVo.getType() == null) {
            return ResponseData2.fail("\u7528\u4eba\u5355\u4f4d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (companyQueryVo.getType() != 1 && companyQueryVo.getType() != 2) {
            return ResponseData2.fail("\u7528\u4eba\u5355\u4f4d\u7c7b\u578b\u53c2\u6570\u9519\u8bef");
        }
        return companyQueryVo.getType() == 1 ? this.getCompany(companyQueryVo) : this.getHospital(companyQueryVo);
    }

    private ResponseData2<String> getCompany(CompanyQueryVo companyQueryVo) {
        if (StringUtils.isBlank((CharSequence)companyQueryVo.getCompanyName())) {
            return ResponseData2.fail("companyName\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)companyQueryVo.getUnifiedCreditCode())) {
            return ResponseData2.fail("unifiedCreditCode\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompanyBaseInfo companyBaseInfo = this.companyService.getCidByNameCode(companyQueryVo.getCompanyName(), companyQueryVo.getUnifiedCreditCode());
        if (companyBaseInfo == null) {
            return ResponseData2.fail("\u627e\u4e0d\u5230\u4f01\u4e1a\u4fe1\u606f", "");
        }
        Set<Long> areaIdSet = UserUtils.getCurrentUser().getAreaIdSet();
        if (CollectionUtils.isEmpty(areaIdSet)) {
            return ResponseData2.fail("\u8d26\u53f7\u672a\u5173\u8054\u7ba1\u8f96\u533a\u57df\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u51b3\uff01", "");
        }
        boolean hasAuth = false;
        for (Long aLong : areaIdSet) {
            boolean authArea = AreaUtils.containAuthArea(companyBaseInfo.getAreaId(), aLong);
            if (!authArea) continue;
            hasAuth = true;
        }
        if (!hasAuth) {
            return ResponseData2.fail("\u6dfb\u52a0\u7684\u4f01\u4e1a\u6240\u5c5e\u533a\u57df\u4e3a\uff1a" + companyBaseInfo.getAreaDetailName() + ", \u4e0d\u5728\u8d26\u53f7\u7ba1\u8f96\u7684\u533a\u57df\u5185\uff01", "");
        }
        return ResponseData2.success(companyBaseInfo.getId().toString(), "\u83b7\u53d6\u4f01\u4e1aid\u6210\u529f");
    }

    private ResponseData2<String> getHospital(CompanyQueryVo companyQueryVo) {
        if (StringUtils.isBlank((CharSequence)companyQueryVo.getCompanyName())) {
            return ResponseData2.fail("companyName\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)companyQueryVo.getUnifiedCreditCode())) {
            return ResponseData2.fail("unifiedCreditCode\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)companyQueryVo.getMedicalCode())) {
            return ResponseData2.fail("medicalCode\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompanyBaseInfo companyBaseInfo = this.companyService.getHospitalId(companyQueryVo);
        if (companyBaseInfo == null) {
            return ResponseData2.fail("\u627e\u4e0d\u5230\u533b\u9662\u4fe1\u606f", "");
        }
        Set<Long> areaIdSet = UserUtils.getCurrentUser().getAreaIdSet();
        if (CollectionUtils.isEmpty(areaIdSet)) {
            return ResponseData2.fail("\u8d26\u53f7\u672a\u5173\u8054\u7ba1\u8f96\u533a\u57df\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u51b3\uff01", "");
        }
        boolean hasAuth = false;
        for (Long aLong : areaIdSet) {
            boolean authArea = AreaUtils.containAuthArea(companyBaseInfo.getAreaId(), aLong);
            if (!authArea) continue;
            hasAuth = true;
        }
        if (!hasAuth) {
            return ResponseData2.fail("\u6dfb\u52a0\u7684\u533b\u9662\u6240\u5c5e\u533a\u57df\u4e3a\uff1a" + companyBaseInfo.getAreaDetailName() + ", \u4e0d\u5728\u8d26\u53f7\u7ba1\u8f96\u7684\u533a\u57df\u5185\uff01", "");
        }
        return ResponseData2.success(companyBaseInfo.getId().toString(), "\u83b7\u53d6\u533b\u9662id\u6210\u529f");
    }
}

