/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.interceptor;

import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.log.SysLog;
import cn.smarthse.modules.datacentre.provider.log.IShareCommonLogService;
import cn.smarthse.services.onlinemonitoring.entity.user.UserInfo;
import cn.smarthse.services.support.RequestBodyUtils;
import cn.smarthse.services.support.UserUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class LogInterceptor
implements HandlerInterceptor {
    @DubboReference
    IShareCommonLogService sysLogThirdService;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        try {
            String requestURI = request.getRequestURI();
            if (!requestURI.startsWith("/api/") && !requestURI.startsWith("/hse/dataservice")) {
                return;
            }
            if (requestURI.startsWith("/api/online/monitor/report")) {
                return;
            }
            UserInfo currentUser = UserUtils.getCurrentUser();
            Long cid = Optional.ofNullable(currentUser).map(UserInfo::getCid).orElse(null);
            String appIdStr = Optional.ofNullable(currentUser).map(UserInfo::getAppId).orElse("");
            SysLog syslog = new SysLog();
            syslog.setUsername(appIdStr);
            syslog.setTitle("\u5728\u7ebf\u76d1\u6d4b\u5bf9\u63a5\u65e5\u5fd7");
            syslog.setCid(cid);
            syslog.setCreateDate(new Date());
            syslog.setUpdateDate(new Date());
            syslog.setRequestMethod(request.getMethod());
            syslog.setRemoteIp(StringUtils.getRemoteAddr((HttpServletRequest)request));
            syslog.setRequestUri(request.getRequestURI());
            syslog.setUserAgent(request.getHeader("user-agent"));
            syslog.setType(Byte.valueOf((byte)2));
            String requestBody = RequestBodyUtils.getRequestBody();
            if (ex != null) {
                syslog.setType(Byte.valueOf((byte)0));
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("param", requestBody);
                StringBuffer errorStr = new StringBuffer();
                errorStr.append(ex.toString() + "<br/>");
                for (StackTraceElement s : ex.getStackTrace()) {
                    errorStr.append(s.toString() + "<br/>");
                }
                data.put("ex", errorStr.toString());
                syslog.setParams(JsonMapper.toJsonString(data));
            } else if (requestURI.startsWith("/hse/dataservice")) {
                Map parameterMap = request.getParameterMap();
                syslog.setParams(JsonMapper.toJsonString((Object)parameterMap));
            } else {
                syslog.setParams(JsonMapper.toJsonString((Object)requestBody));
            }
            this.sysLogThirdService.addLog(syslog);
        }
        finally {
            RequestBodyUtils.remove();
        }
    }
}

