/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.dataservice.service.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModelNoEncrypt;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.health.bx.model.CompanyRefVo;
import cn.smarthse.modules.health.dataservice.entity.ChuangdeSystemHealthSuperviseOrg;
import cn.smarthse.modules.health.dataservice.entity.CompanyBaseDcInfo;
import cn.smarthse.modules.health.dataservice.entity.CompanyBaseDcInfoModel;
import cn.smarthse.modules.health.dataservice.entity.CompanyBaseDcInfoVo;
import cn.smarthse.modules.health.dataservice.service.ICompanyBaseDcInfoService;
import cn.smarthse.modules.health.entity.base.company.WandaDeclare;
import cn.smarthse.modules.health.entity.base.selfjudge.CompanyHsePreventionControlSelfJudge;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.enums.home.grade.GradeSourceEnum;
import cn.smarthse.services.dataservice.mapper.CompanyBaseDcInfoMapper;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import jakarta.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Year;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
public class CompanyBaseDcInfoServiceImpl
extends ServiceImpl<CompanyBaseDcInfoMapper, CompanyBaseDcInfo>
implements ICompanyBaseDcInfoService {
    @Autowired
    private CompanyBaseDcInfoMapper companyBaseDcInfoMapper;
    @Resource
    private ExecutorService dcThreadPoolExecutor;
    @Autowired
    private RedissonClient redisClient;
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Transactional
    public void regularlyUpdateData() throws Exception {
        final CountDownLatch downLatch = new CountDownLatch(2);
        final HashMap<Long, List<CertificateStaffDetail>> certificateStaffDetailMap = new HashMap<Long, List<CertificateStaffDetail>>();
        this.dcThreadPoolExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<Object> certificateStaffDetails = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectCertificateStaffDetail();
                    Date date = new Date();
                    certificateStaffDetails = certificateStaffDetails.stream().filter(item -> item.getCertCreateDate() != null && item.getCertCreateDate().compareTo(date) <= 0).collect(Collectors.toList());
                    certificateStaffDetails = certificateStaffDetails.stream().filter(item -> item.getValidityDate() != null && item.getValidityDate().compareTo(date) >= 0).collect(Collectors.toList());
                    certificateStaffDetailMap.putAll(certificateStaffDetails.stream().collect(Collectors.groupingBy(CertificateStaffDetail::getCid)));
                    CompanyBaseDcInfoServiceImpl.this.logger.info("\u521b\u5f97\u4e09\u65b9\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u66f4\u65b0>>>>\u67e5\u8be2\u4f01\u4e1a\u8bc1\u4e66\u8be6\u60c5\u7ed3\u675f\u5171\uff1a {} \u6761end-->{}", (Object)certificateStaffDetails.size(), (Object)DateUtils.formatDate((Date)new Date()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new HealthException("\u521b\u5f97\u4e09\u65b9\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u66f4\u65b0>>>>\u4eba\u5458\u8bc1\u4e66\u76f8\u5173\u4fe1\u606f\u67e5\u8be2\u9519\u8bef");
                }
                finally {
                    downLatch.countDown();
                }
            }
        });
        final HashMap<Long, ChuangdeSystemHealthSuperviseOrg> chuangdeSystemHealthSuperviseOrgMap = new HashMap<Long, ChuangdeSystemHealthSuperviseOrg>();
        final HashMap<Long, Long> areaMap = new HashMap<Long, Long>();
        final HashMap<Long, SysArea> sysAreaMap = new HashMap<Long, SysArea>();
        this.dcThreadPoolExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<ChuangdeSystemHealthSuperviseOrg> chuangdeSystemHealthSuperviseOrgs = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectChuangdeSystemHealthSuperviseOrg();
                    chuangdeSystemHealthSuperviseOrgMap.putAll(chuangdeSystemHealthSuperviseOrgs.stream().collect(Collectors.toMap(ChuangdeSystemHealthSuperviseOrg::getAreaId, c -> c, (c1, c2) -> c1)));
                    List<SysArea> sysAreas = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectSysAreaParent();
                    areaMap.putAll(sysAreas.stream().collect(Collectors.toMap(SysArea::getId, SysArea::getParentId, (a1, a2) -> a1)));
                    sysAreaMap.putAll(sysAreas.stream().collect(Collectors.toMap(SysArea::getId, a -> a, (a1, a2) -> a1)));
                    CompanyBaseDcInfoServiceImpl.this.logger.info("\u521b\u5f97\u4e09\u65b9\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u66f4\u65b0>>>>\u67e5\u8be2\u521b\u5f97\u7cfb\u7edf\u7ba1\u7406-\u536b\u751f\u76d1\u7763\u673a\u6784\u5171:{}\u6761\uff0c\u533a\u57df\u5212\u5206\u5171\uff1a {} \u6761end-->{}", new Object[]{chuangdeSystemHealthSuperviseOrgs.size(), sysAreas.size(), DateUtils.formatDate((Date)new Date())});
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new HealthException("\u521b\u5f97\u4e09\u65b9\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u66f4\u65b0>>>>\u536b\u751f\u76d1\u7763\u7ec4\u7ec7\u8868\u3001\u7cfb\u7edf\u5730\u533a\u8868\u76f8\u5173\u4fe1\u606f\u67e5\u8be2\u9519\u8bef");
                }
                finally {
                    downLatch.countDown();
                }
            }
        });
        List<Long> cids = this.companyBaseDcInfoMapper.selectAllCids();
        this.logger.error("\u521b\u5f97\u4e09\u65b9\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u66f4\u65b0>>>>\u67e5\u8be2\u7edf\u8ba1\u4f01\u4e1a\u5171 {} \u6761", (Object)cids.size());
        List cidsList = new ArrayList();
        if (!cids.isEmpty()) {
            cidsList = ListUtil.partition(cids, (int)10000);
        }
        int count = cidsList.size();
        downLatch.await();
        if (count == 0) {
            this.logger.error("\u521b\u5f97\u4e09\u65b9\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u66f4\u65b0>>>>\u6ca1\u6709\u67e5\u8be2\u5230\u63a8\u9001\u4f01\u4e1a");
            return;
        }
        for (int i = 0; i < count; ++i) {
            final CountDownLatch countDownLatchT = new CountDownLatch(3);
            final List cidListT = (List)cidsList.get(i);
            if (CollectionUtils.isEmpty((Collection)cidListT)) {
                countDownLatchT.countDown();
                countDownLatchT.countDown();
                countDownLatchT.countDown();
                continue;
            }
            final HashMap<Long, List<WandaDeclare>> wandaDeclareMapT = new HashMap<Long, List<WandaDeclare>>();
            this.dcThreadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        List<WandaDeclare> wandaDeclares = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectWandaDeclare(cidListT);
                        wandaDeclareMapT.putAll(wandaDeclares.stream().collect(Collectors.groupingBy(WandaDeclare::getCid)));
                        CompanyBaseDcInfoServiceImpl.this.logger.info("\u521b\u5f97\u4e09\u65b9\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u66f4\u65b0>>>>\u67e5\u8be2\u4e07\u8fbe\u6570\u636e\u5171\uff1a{} \u6761 end-->{}", (Object)wandaDeclares.size(), (Object)DateUtils.formatDate((Date)new Date()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new HealthException("\u521b\u5f97\u4e09\u65b9\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u66f4\u65b0>>>>\u4e07\u8fbe\u8868\u76f8\u5173\u4fe1\u606f\u67e5\u8be2\u9519\u8bef");
                    }
                    finally {
                        countDownLatchT.countDown();
                    }
                }
            });
            final HashMap<Long, CompanyBaseDcInfoModel> companyBaseDcInfoModelMapT = new HashMap<Long, CompanyBaseDcInfoModel>();
            this.dcThreadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        List<CompanyBaseDcInfoModel> companies = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectCompanyAbout(cidListT);
                        companyBaseDcInfoModelMapT.putAll(companies.stream().collect(Collectors.toMap(CompanyBaseInfoModelNoEncrypt::getId, c -> c, (c1, c2) -> c1)));
                        CompanyBaseDcInfoServiceImpl.this.logger.info("\u521b\u5f97\u4e09\u65b9\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u66f4\u65b0>>>>\u67e5\u8be2\u4f01\u4e1a\u76f8\u5173\u6570\u636e {} \u6761", (Object)cidListT.size());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new HealthException("\u521b\u5f97\u4e09\u65b9\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u66f4\u65b0>>>>\u4f01\u4e1a\u8868\u76f8\u5173\u4fe1\u606f\u67e5\u8be2\u9519\u8bef");
                    }
                    finally {
                        countDownLatchT.countDown();
                    }
                }
            });
            final HashMap<Long, CompanyHsePreventionControlSelfJudge> selfJudgeMapT = new HashMap<Long, CompanyHsePreventionControlSelfJudge>();
            this.dcThreadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        List<CompanyHsePreventionControlSelfJudge> selfJudges = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectSelfJudgeByCids(cidListT);
                        selfJudgeMapT.putAll(selfJudges.stream().collect(Collectors.toMap(CompanyHsePreventionControlSelfJudge::getCid, c -> c, (c1, c2) -> c1)));
                        CompanyBaseDcInfoServiceImpl.this.logger.error("\u521b\u5f97\u4e09\u65b9\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u66f4\u65b0>>>>\u67e5\u8be2\u4f01\u4e1a\u81ea\u67e5\u901a\u8fc7\u7684\u6570\u636e {} \u6761", (Object)selfJudges.size());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new HealthException("\u521b\u5f97\u4e09\u65b9\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u66f4\u65b0>>>>\u4f01\u4e1a\u81ea\u67e5\u901a\u8fc7\u7684\u6570\u636e\u67e5\u8be2\u9519\u8bef");
                    }
                    finally {
                        countDownLatchT.countDown();
                    }
                }
            });
            countDownLatchT.await();
            if (MapUtils.isEmpty(companyBaseDcInfoModelMapT)) continue;
            ArrayList<CompanyBaseDcInfo> newCompanyBaseDcInfoList = new ArrayList<CompanyBaseDcInfo>();
            this.updateChuangDe(certificateStaffDetailMap, chuangdeSystemHealthSuperviseOrgMap, areaMap, wandaDeclareMapT, companyBaseDcInfoModelMapT, newCompanyBaseDcInfoList, sysAreaMap, selfJudgeMapT);
            companyBaseDcInfoModelMapT.clear();
            wandaDeclareMapT.clear();
            selfJudgeMapT.clear();
            newCompanyBaseDcInfoList.clear();
        }
        Integer integer = this.companyBaseDcInfoMapper.delAllCompanyBaseDcInfo(cids);
        this.logger.error("\u521b\u5f97\u4e09\u65b9\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u66f4\u65b0>>>>\u8fdb\u884c\u4f01\u4e1a\u5220\u9664\u6570\u636e\u5171\uff1a{} \u6761 end-->{}", (Object)integer, (Object)DateUtils.formatDate((Date)new Date()));
        this.logger.error("\u521b\u5f97\u4e09\u65b9\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u66f4\u65b0>>>>\u9700\u8981\u5de1\u67e5\u7684\u4f01\u4e1a\u5f00\u59cb");
        this.companyBaseDcInfoMapper.delBxCompanyBxNeedInspection();
        this.companyBaseDcInfoMapper.generateBxCompanyBxNeedInspection();
        this.logger.error("\u521b\u5f97\u4e09\u65b9\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u66f4\u65b0>>>>\u9700\u8981\u5de1\u67e5\u7684\u4f01\u4e1a\u7ed3\u675f");
    }

    public PageInfo<CompanyBaseDcInfo> getCompanyBaseDcInfoServicePage(Integer pageSize, Integer pageNum, String queryPara, Long cid, String cname, String unifiedSocialCc) {
        String startDate = null;
        String endDate = null;
        try {
            JSONObject jsonObject;
            if (StringUtils.isNotEmpty((String)queryPara) && (jsonObject = JSON.parseObject((String)queryPara)) != null) {
                startDate = (String)jsonObject.get((Object)"updateStartDate");
                endDate = (String)jsonObject.get((Object)"updateEndDate");
            }
        }
        catch (Exception e) {
            throw new HealthException("\u4f20\u5165queryPara\u67e5\u8be2\u53c2\u6570\u9519\u8bef");
        }
        RAtomicLong atomicLong = this.redisClient.getAtomicLong("CHUANGDEPUSHCOMPANYTOTAL:queryPara:" + queryPara + "cid:" + cid + "cname:" + cname + "unifiedSocialCc:" + unifiedSocialCc);
        Long aLong = atomicLong.get();
        Boolean falg = ObjectUtil.isNull((Object)aLong) || aLong == -1L || aLong == 0L;
        PageMethod.startPage((int)pageNum, (int)pageSize, (boolean)falg);
        List<CompanyBaseDcInfo> companyBaseDcInfoList = this.companyBaseDcInfoMapper.getCompanyBaseDcInfoServicePage(startDate, endDate, cid, cname, unifiedSocialCc);
        if (companyBaseDcInfoList.size() > 0) {
            for (CompanyBaseDcInfo companyBaseDcInfo : companyBaseDcInfoList) {
                companyBaseDcInfo.setLegalName(SpringEncryptUtils.decrypt((String)companyBaseDcInfo.getLegalName()));
                companyBaseDcInfo.setLegalTel(SpringEncryptUtils.decrypt((String)companyBaseDcInfo.getLegalTel()));
                companyBaseDcInfo.setOccLeaderName(SpringEncryptUtils.decrypt((String)companyBaseDcInfo.getOccLeaderName()));
                companyBaseDcInfo.setOccLeaderTel(SpringEncryptUtils.decrypt((String)companyBaseDcInfo.getOccLeaderTel()));
                companyBaseDcInfo.setOccManagerName(SpringEncryptUtils.decrypt((String)companyBaseDcInfo.getOccManagerName()));
                companyBaseDcInfo.setOccManagerTel(SpringEncryptUtils.decrypt((String)companyBaseDcInfo.getOccManagerTel()));
                String scale = companyBaseDcInfo.getScale();
                if ("1".equals(scale) || "2".equals(scale) || "3".equals(scale) || "4".equals(scale)) {
                    companyBaseDcInfo.setScale(String.valueOf(4 - Integer.parseInt(scale)));
                } else {
                    companyBaseDcInfo.setScale("4");
                }
                companyBaseDcInfo.setOccHazardProject(Integer.valueOf(ObjectUtil.isNull((Object)companyBaseDcInfo.getOccHazardProject()) ? 1 : (companyBaseDcInfo.getOccHazardProject() == 2 ? 0 : 1)));
            }
        }
        PageInfo data = new PageInfo(companyBaseDcInfoList);
        if (ObjectUtil.isNull((Object)aLong) || aLong == -1L || aLong == 0L) {
            atomicLong.set(data.getTotal());
            atomicLong.expire(1L, TimeUnit.MINUTES);
        } else {
            data.setTotal(aLong.longValue());
        }
        return data;
    }

    public PageInfo<CompanyRefVo> listBxCompany(Integer pageSize, Integer pageNum, String queryPara, Long cid, String cname, String unifiedSocialCc) {
        String startDate = null;
        String endDate = null;
        try {
            JSONObject jsonObject;
            if (StringUtils.isNotEmpty((String)queryPara) && (jsonObject = JSON.parseObject((String)queryPara)) != null) {
                startDate = (String)jsonObject.get((Object)"updateStartDate");
                endDate = (String)jsonObject.get((Object)"updateEndDate");
            }
        }
        catch (Exception e) {
            throw new HealthException("\u4f20\u5165queryPara\u67e5\u8be2\u53c2\u6570\u9519\u8bef");
        }
        RAtomicLong atomicLong = this.redisClient.getAtomicLong("BXPUSHCOMPANYTOTAL:queryPara:" + queryPara + "cid:" + cid + "cname:" + cname + "unifiedSocialCc:" + unifiedSocialCc);
        Long aLong = atomicLong.get();
        Boolean falg = ObjectUtil.isNull((Object)aLong) || aLong == -1L || aLong == 0L;
        PageMethod.startPage((int)pageNum, (int)pageSize, (boolean)falg);
        List<CompanyRefVo> companyBaseDcInfoList = this.companyBaseDcInfoMapper.listBxCompany(startDate, endDate, cid, cname, unifiedSocialCc);
        if (companyBaseDcInfoList.size() > 0) {
            for (CompanyRefVo companyBaseDcInfo : companyBaseDcInfoList) {
                String gradeSource;
                companyBaseDcInfo.setLegalName(SpringEncryptUtils.decrypt((String)companyBaseDcInfo.getLegalName()));
                companyBaseDcInfo.setLegalTel(SpringEncryptUtils.decrypt((String)companyBaseDcInfo.getLegalTel()));
                companyBaseDcInfo.setOccManagerName(SpringEncryptUtils.decrypt((String)companyBaseDcInfo.getOccManagerName()));
                companyBaseDcInfo.setOccManagerTel(SpringEncryptUtils.decrypt((String)companyBaseDcInfo.getOccManagerTel()));
                companyBaseDcInfo.setMainLeaderName(SpringEncryptUtils.decrypt((String)companyBaseDcInfo.getMainLeaderName()));
                companyBaseDcInfo.setMainLeaderTel(SpringEncryptUtils.decrypt((String)companyBaseDcInfo.getMainLeaderTel()));
                String scale = String.valueOf(companyBaseDcInfo.getScale());
                if ("1".equals(scale) || "2".equals(scale) || "3".equals(scale) || "4".equals(scale)) {
                    companyBaseDcInfo.setScale(Integer.valueOf(4 - Integer.parseInt(scale)));
                } else {
                    companyBaseDcInfo.setScale(Integer.valueOf(4));
                }
                String mainLeaderTrain = companyBaseDcInfo.getMainLeaderTrain();
                if ("1".equals(mainLeaderTrain)) {
                    companyBaseDcInfo.setMainLeaderTrain("\u662f");
                } else {
                    companyBaseDcInfo.setMainLeaderTrain("\u5426");
                }
                String occManagerTrain = companyBaseDcInfo.getOccManagerTrain();
                if ("1".equals(occManagerTrain)) {
                    companyBaseDcInfo.setOccManagerTrain("\u662f");
                } else {
                    companyBaseDcInfo.setOccManagerTrain("\u5426");
                }
                String occManager = companyBaseDcInfo.getOccManage();
                if ("1".equals(occManager)) {
                    companyBaseDcInfo.setOccManage("\u6709");
                } else {
                    companyBaseDcInfo.setOccManage("\u65e0");
                }
                if (!StringUtils.isNotBlank((CharSequence)(gradeSource = companyBaseDcInfo.getGradeSource())) || !NumberUtil.isNumber((CharSequence)gradeSource)) continue;
                String name = GradeSourceEnum.getName((Integer)Integer.parseInt(gradeSource));
                companyBaseDcInfo.setGradeSource(name);
            }
        }
        PageInfo data = new PageInfo(companyBaseDcInfoList);
        if (ObjectUtil.isNull((Object)aLong) || aLong == -1L || aLong == 0L) {
            atomicLong.set(data.getTotal());
            atomicLong.expire(1L, TimeUnit.MINUTES);
        } else {
            data.setTotal(aLong.longValue());
        }
        return data;
    }

    public Integer updateChuangdePushInfo(final String keyWord) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)keyWord)) {
            this.dcThreadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    List<Long> cids = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectCidsByKeyWord(keyWord);
                    if (cids.size() > 0) {
                        List<CompanyBaseDcInfoModel> companyBaseDcInfoModels = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectCompanyAbout(cids);
                        Map<Long, CompanyBaseDcInfoModel> companyBaseDcInfoModelMap = companyBaseDcInfoModels.stream().collect(Collectors.toMap(CompanyBaseInfoModelNoEncrypt::getId, c -> c, (c1, c2) -> c1));
                        List<Object> certificateStaffDetails = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectCertificateStaffDetailByCids(cids);
                        Date date = new Date();
                        certificateStaffDetails = certificateStaffDetails.stream().filter(item -> item.getCertCreateDate() != null && item.getCertCreateDate().compareTo(date) <= 0).collect(Collectors.toList());
                        certificateStaffDetails = certificateStaffDetails.stream().filter(item -> item.getValidityDate() != null && item.getValidityDate().compareTo(date) >= 0).collect(Collectors.toList());
                        Map<Long, List<CertificateStaffDetail>> certificateStaffDetailMap = certificateStaffDetails.stream().collect(Collectors.groupingBy(CertificateStaffDetail::getCid));
                        List<ChuangdeSystemHealthSuperviseOrg> chuangdeSystemHealthSuperviseOrgs = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectChuangdeSystemHealthSuperviseOrg();
                        Map<Long, ChuangdeSystemHealthSuperviseOrg> chuangdeSystemHealthSuperviseOrgMap = chuangdeSystemHealthSuperviseOrgs.stream().collect(Collectors.toMap(ChuangdeSystemHealthSuperviseOrg::getAreaId, c -> c, (c1, c2) -> c1));
                        List<SysArea> sysAreas = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectSysAreaParent();
                        Map<Long, Long> areaMap = sysAreas.stream().collect(Collectors.toMap(SysArea::getId, SysArea::getParentId, (a1, a2) -> a1));
                        Map<Long, SysArea> sysAreaMap = sysAreas.stream().collect(Collectors.toMap(SysArea::getId, a -> a, (a1, a2) -> a1));
                        Map<Long, List<WandaDeclare>> wandaDeclareMap = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectWandaDeclare(cids).stream().collect(Collectors.groupingBy(WandaDeclare::getCid));
                        Map<Long, CompanyHsePreventionControlSelfJudge> selfJudgeMap = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectSelfJudgeByCids(cids).stream().collect(Collectors.toMap(CompanyHsePreventionControlSelfJudge::getCid, c -> c, (c1, c2) -> c1));
                        ArrayList<CompanyBaseDcInfo> newCompanyBaseDcInfoList = new ArrayList<CompanyBaseDcInfo>();
                        CompanyBaseDcInfoServiceImpl.this.updateChuangDe(certificateStaffDetailMap, chuangdeSystemHealthSuperviseOrgMap, areaMap, wandaDeclareMap, companyBaseDcInfoModelMap, newCompanyBaseDcInfoList, sysAreaMap, selfJudgeMap);
                    }
                }
            });
        }
        return 0;
    }

    public Integer updateChuangdePushInfoByCid(final List<Long> cids) throws Exception {
        if (CollectionUtils.isNotEmpty(cids)) {
            this.dcThreadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (cids.size() > 0) {
                        List<CompanyBaseDcInfoModel> companyBaseDcInfoModels = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectCompanyAbout(cids);
                        Map<Long, CompanyBaseDcInfoModel> companyBaseDcInfoModelMap = companyBaseDcInfoModels.stream().collect(Collectors.toMap(CompanyBaseInfoModelNoEncrypt::getId, c -> c, (c1, c2) -> c1));
                        List<Object> certificateStaffDetails = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectCertificateStaffDetailByCids(cids);
                        Date date = new Date();
                        certificateStaffDetails = certificateStaffDetails.stream().filter(item -> item.getCertCreateDate() != null && item.getCertCreateDate().compareTo(date) <= 0).collect(Collectors.toList());
                        certificateStaffDetails = certificateStaffDetails.stream().filter(item -> item.getValidityDate() != null && item.getValidityDate().compareTo(date) >= 0).collect(Collectors.toList());
                        Map<Long, List<CertificateStaffDetail>> certificateStaffDetailMap = certificateStaffDetails.stream().collect(Collectors.groupingBy(CertificateStaffDetail::getCid));
                        List<ChuangdeSystemHealthSuperviseOrg> chuangdeSystemHealthSuperviseOrgs = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectChuangdeSystemHealthSuperviseOrg();
                        Map<Long, ChuangdeSystemHealthSuperviseOrg> chuangdeSystemHealthSuperviseOrgMap = chuangdeSystemHealthSuperviseOrgs.stream().collect(Collectors.toMap(ChuangdeSystemHealthSuperviseOrg::getAreaId, c -> c, (c1, c2) -> c1));
                        List<SysArea> sysAreas = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectSysAreaParent();
                        Map<Long, Long> areaMap = sysAreas.stream().collect(Collectors.toMap(SysArea::getId, SysArea::getParentId, (a1, a2) -> a1));
                        Map<Long, SysArea> sysAreaMap = sysAreas.stream().collect(Collectors.toMap(SysArea::getId, a -> a, (a1, a2) -> a1));
                        Map<Long, List<WandaDeclare>> wandaDeclareMap = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectWandaDeclare(cids).stream().collect(Collectors.groupingBy(WandaDeclare::getCid));
                        Map<Long, CompanyHsePreventionControlSelfJudge> selfJudgeMap = CompanyBaseDcInfoServiceImpl.this.companyBaseDcInfoMapper.selectSelfJudgeByCids(cids).stream().collect(Collectors.toMap(CompanyHsePreventionControlSelfJudge::getCid, c -> c, (c1, c2) -> c1));
                        ArrayList<CompanyBaseDcInfo> newCompanyBaseDcInfoList = new ArrayList<CompanyBaseDcInfo>();
                        CompanyBaseDcInfoServiceImpl.this.updateChuangDe(certificateStaffDetailMap, chuangdeSystemHealthSuperviseOrgMap, areaMap, wandaDeclareMap, companyBaseDcInfoModelMap, newCompanyBaseDcInfoList, sysAreaMap, selfJudgeMap);
                    }
                }
            });
        }
        return 0;
    }

    public PageInfo<CompanyBaseDcInfoVo> getCompanyBaseInfoPushList(CompanySuperviseSearchModel model, JqGridParam jqGridParam) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<CompanyBaseDcInfoVo> companyBaseDcInfoVoList = this.companyBaseDcInfoMapper.selectCompanyBaseInfoPushList(model);
        return new PageInfo(companyBaseDcInfoVoList);
    }

    public List<CompanyHsePreventionControlSelfJudge> getSelfReportPassByCids(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            return new ArrayList<CompanyHsePreventionControlSelfJudge>();
        }
        return this.companyBaseDcInfoMapper.selectSelfJudgeByCids(cids);
    }

    private void processingData(Map<Long, List<CertificateStaffDetail>> certificateStaffDetailMap, Map<Long, List<WandaDeclare>> wandaDeclareMap, Map<Long, ChuangdeSystemHealthSuperviseOrg> chuangdeSystemHealthSuperviseOrgMap, Map<Long, Long> areaMap, Long id, CompanyBaseDcInfoModel company, CompanyBaseDcInfo companyBaseDcInfo, Map<String, Date> valueMap, Map<Long, SysArea> sysAreaMap, Map<Long, CompanyHsePreventionControlSelfJudge> selfJudgeMap) {
        if (ObjectUtil.isNotNull((Object)company)) {
            this.companyCalculation(companyBaseDcInfo, valueMap, company, id, wandaDeclareMap, sysAreaMap);
        }
        companyBaseDcInfo.setBusinessState(company.getBusinessState());
        Date csUpdateDate = company.getCsUpdateDate();
        this.compareTime(valueMap, csUpdateDate);
        String manageOrg = company.getManageOrg();
        if ("1".equals(manageOrg)) {
            companyBaseDcInfo.setOccManageOrg("1");
        } else {
            companyBaseDcInfo.setOccManageOrg("0");
        }
        companyBaseDcInfo.setManageMajorStaffCount(Long.valueOf(ObjectUtil.isNull((Object)company.getManageMajorStaffCount()) ? 0L : (company.getManageMajorStaffCount() > Long.valueOf(Integer.MAX_VALUE) ? Long.valueOf(Integer.MAX_VALUE) : company.getManageMajorStaffCount())));
        companyBaseDcInfo.setManagePluralityStaffCount(Long.valueOf(ObjectUtil.isNull((Object)company.getManagePluralityStaffCount()) ? 0L : (company.getManagePluralityStaffCount() > Long.valueOf(Integer.MAX_VALUE) ? Long.valueOf(Integer.MAX_VALUE) : company.getManagePluralityStaffCount())));
        Date criUpdateDate = company.getCriUpdateDate();
        this.compareTime(valueMap, criUpdateDate);
        this.certificateStaffDetailCalculation(certificateStaffDetailMap, companyBaseDcInfo, valueMap);
        this.checkFactorTempCalculation(companyBaseDcInfo, company, valueMap);
        Date cgvrUpdateDate = company.getCgvrUpdateDate();
        this.compareTime(valueMap, cgvrUpdateDate);
        companyBaseDcInfo.setGrade(Integer.valueOf(ObjectUtil.isNull((Object)company.getGrade()) ? 0 : company.getGrade()));
        companyBaseDcInfo.setGradeSource(Integer.valueOf(ObjectUtil.isNull((Object)company.getGradeSource()) ? 0 : (company.getGradeSource() == 7 ? 6 : company.getGradeSource())));
        this.chuangdeOrgCalculation(companyBaseDcInfo, chuangdeSystemHealthSuperviseOrgMap, areaMap, company, sysAreaMap);
        companyBaseDcInfo.setUpdateTime(valueMap.get("updateTime"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Year year = Year.now();
        String currentYear = year.toString();
        CompanyHsePreventionControlSelfJudge selfJudge = selfJudgeMap.get(id);
        if (Boolean.TRUE.equals(company.getAIsValid()) && ObjectUtil.isNotNull((Object)company.getIsRegulationVisible()) && Boolean.TRUE.equals(company.getCsIsValid()) && Boolean.TRUE.equals(company.getIsValid()) && Boolean.FALSE.equals(company.getSuperviseIsDel()) && 1 == company.getIsRegulationVisible() && ObjectUtil.isNotNull((Object)company.getProvinceId()) && ObjectUtil.isNotNull((Object)company.getCompanyType()) && Boolean.FALSE.equals(company.getIsTest()) && company.getProvinceId() == 330000000000L && (company.getCompanyType() == 1 || company.getCompanyType() == 3 || company.getCompanyType() == 2) && Boolean.FALSE.equals(company.getSuperviseIsHide()) && Boolean.TRUE.equals(company.getIsDec()) && (ObjectUtil.isNull((Object)company.getStorageReason()) || ObjectUtil.isNull((Object)company.getStorageDate()) || !sdf.format(company.getStorageDate()).equals(currentYear) || company.getStorageReason() != 1 || ObjectUtil.isNotNull((Object)selfJudge)) || company.getId() == 1904103536297811969L || company.getId() == 1877755020780797954L) {
            companyBaseDcInfo.setIsPush(Integer.valueOf(1));
            companyBaseDcInfo.setIsDelPush(Integer.valueOf(0));
        } else {
            companyBaseDcInfo.setIsPush(Integer.valueOf(0));
        }
        if (companyBaseDcInfo.getIsPush() == 1) {
            companyBaseDcInfo.setIsDel(Integer.valueOf(0));
        } else {
            companyBaseDcInfo.setIsDel(Integer.valueOf(1));
            companyBaseDcInfo.setIsPush(Integer.valueOf(1));
            companyBaseDcInfo.setIsDelPush(Integer.valueOf(1));
        }
    }

    public void compareTime(Map<String, Date> valueMap, Date date) {
        if (ObjectUtil.isNull((Object)date)) {
            return;
        }
        Date updateTime = valueMap.get("updateTime");
        if (ObjectUtil.isNull((Object)updateTime)) {
            valueMap.put("updateTime", date);
            return;
        }
        int result = updateTime.compareTo(date);
        if (result < 0) {
            valueMap.put("updateTime", date);
        }
    }

    public void companyCalculation(CompanyBaseDcInfo companyBaseDcInfo, Map valueMap, CompanyBaseDcInfoModel company, Long id, Map<Long, List<WandaDeclare>> wandaDeclareMap, Map<Long, SysArea> sysAreaMap) {
        if (ObjectUtil.isNotNull((Object)company)) {
            SimpleDateFormat format;
            String endTime;
            valueMap.put("updateTime", company.getCUpdateDate());
            companyBaseDcInfo.setName(ObjectUtil.isNull((Object)company.getName()) ? "" : company.getName());
            companyBaseDcInfo.setWorkAddressCode(ObjectUtil.isNull((Object)company.getAreaId()) ? "" : company.getAreaId().toString());
            if (MapUtils.isNotEmpty(sysAreaMap)) {
                String workAddress = company.getWorkAddress();
                if (StringUtils.isEmpty((CharSequence)workAddress)) {
                    workAddress = "";
                } else {
                    SysArea sysArea;
                    String workAddressCode = companyBaseDcInfo.getWorkAddressCode();
                    if (StringUtils.isNotEmpty((String)workAddressCode) && ObjectUtil.isNotEmpty((Object)(sysArea = sysAreaMap.get(Long.parseLong(workAddressCode))))) {
                        String provinceName;
                        String cityName;
                        String areaName;
                        String streetName = sysArea.getStreetName();
                        if (StringUtils.isNotEmpty((String)streetName)) {
                            workAddress = workAddress.replace(streetName, "");
                        }
                        if (StringUtils.isNotEmpty((String)(areaName = sysArea.getAreaName()))) {
                            workAddress = workAddress.replace(areaName, "");
                        }
                        if (StringUtils.isNotEmpty((String)(cityName = sysArea.getCityName()))) {
                            workAddress = workAddress.replace(cityName, "");
                        }
                        if (StringUtils.isNotEmpty((String)(provinceName = sysArea.getProvinceName()))) {
                            workAddress = workAddress.replace(provinceName, "");
                        }
                    }
                }
                companyBaseDcInfo.setWorkAddress(workAddress);
            } else {
                companyBaseDcInfo.setWorkAddress(ObjectUtil.isNull((Object)company.getWorkAddress()) ? "" : company.getWorkAddress());
            }
            companyBaseDcInfo.setRegisterAddressCode(ObjectUtil.isNull((Object)company.getRegisterAddressRegionId()) ? "" : company.getRegisterAddressRegionId().toString());
            companyBaseDcInfo.setRegisterAddress(ObjectUtil.isNull((Object)company.getRegisterAddress()) ? "" : company.getRegisterAddress());
            companyBaseDcInfo.setIndustryCategoryCode(ObjectUtil.isNull((Object)company.getIndustryCategory()) ? "" : company.getIndustryCategory().toString());
            companyBaseDcInfo.setUnifiedSocialCc(ObjectUtil.isNull((Object)company.getUnifiedSocialCc()) ? "" : company.getUnifiedSocialCc());
            companyBaseDcInfo.setRegisterType(Long.valueOf(ObjectUtil.isNull((Object)company.getRegisterType()) ? 900L : company.getRegisterType()));
            String scale = company.getScale();
            if ("1".equals(scale) || "2".equals(scale) || "3".equals(scale) || "4".equals(scale)) {
                companyBaseDcInfo.setScale(String.valueOf(4 - Integer.parseInt(scale)));
            } else {
                companyBaseDcInfo.setScale("4");
            }
            companyBaseDcInfo.setLegalName(ObjectUtil.isNull((Object)company.getLegalName()) ? "" : company.getLegalName());
            companyBaseDcInfo.setLegalTel(ObjectUtil.isNull((Object)company.getLegalTel()) ? "" : company.getLegalTel());
            if (ObjectUtil.isNull((Object)company.getStaffCount())) {
                companyBaseDcInfo.setStaffCount(Integer.valueOf(0));
            } else {
                companyBaseDcInfo.setStaffCount(company.getStaffCount());
            }
            Integer victimsIdentify = company.getVictimsIdentify();
            if (ObjectUtil.isNotNull((Object)company.getCviRiskPickupDate())) {
                endTime = "2024-01-20 00:00:00";
                format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    if (!company.getCviRiskPickupDate().after(format.parse(endTime))) {
                        company.setCviRiskPickupDate(null);
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    company.setCviRiskPickupDate(null);
                    this.logger.error("CviRiskPickupDate\u65e5\u671f\u6bd4\u8f83\u5f02\u5e38-->{}", (Object)DateUtils.formatDate((Date)new Date()));
                }
            }
            if (ObjectUtil.isNotNull((Object)company.getCviIdentifyInvalidTime())) {
                endTime = "2025-01-20 00:00:00";
                format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    if (!company.getCviIdentifyInvalidTime().after(format.parse(endTime))) {
                        company.setCviIdentifyInvalidTime(null);
                    }
                }
                catch (ParseException e) {
                    company.setCviIdentifyInvalidTime(null);
                    this.logger.error("CviIdentifyInvalidTime\u65e5\u671f\u6bd4\u8f83\u5f02\u5e38-->{}", (Object)DateUtils.formatDate((Date)new Date()));
                }
            }
            if (ObjectUtil.isNotNull((Object)company.getCviIdentifyTime())) {
                endTime = "2025-01-20 00:00:00";
                format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    if (!company.getCviIdentifyTime().after(format.parse(endTime))) {
                        company.setCviIdentifyTime(null);
                    }
                }
                catch (ParseException e) {
                    company.setCviIdentifyTime(null);
                    this.logger.error("CviIdentifyTime\u65e5\u671f\u6bd4\u8f83\u5f02\u5e38-->{}", (Object)DateUtils.formatDate((Date)new Date()));
                }
            }
            if (ObjectUtil.isNotNull((Object)victimsIdentify) && victimsIdentify == 2) {
                this.compareTime(valueMap, company.getCviRiskPickupDate());
                this.compareTime(valueMap, company.getCviIdentifyInvalidTime());
                this.compareTime(valueMap, company.getCviIdentifyTime());
                if (ObjectUtil.isNotNull((Object)company.getIdentifyRealNum()) && company.getIdentifyRealNum() >= 3) {
                    companyBaseDcInfo.setHarmStaffCount(company.getIdentifyRealNum().toString());
                } else {
                    companyBaseDcInfo.setHarmStaffCount("");
                }
            } else if (ObjectUtil.isNotNull((Object)victimsIdentify) && victimsIdentify == 1) {
                this.compareTime(valueMap, company.getCviRiskPickupDate());
                this.compareTime(valueMap, company.getCviIdentifyInvalidTime());
                this.compareTime(valueMap, company.getCviIdentifyTime());
                if (ObjectUtil.isNotNull((Object)company.getIdentifyRealNum()) && company.getIdentifyRealNum() < 3) {
                    companyBaseDcInfo.setHarmStaffCount(company.getIdentifyRealNum().toString());
                } else {
                    companyBaseDcInfo.setHarmStaffCount("<3");
                }
            } else {
                companyBaseDcInfo.setHarmStaffCount(ObjectUtil.isNull((Object)company.getPickupCount()) ? "" : company.getPickupCount().toString());
            }
            companyBaseDcInfo.setOccHazardProject(Integer.valueOf(ObjectUtil.isNull((Object)company.getCompanyType()) ? 1 : (company.getCompanyType() == 2 ? 0 : 1)));
            companyBaseDcInfo.setOccLeaderName(ObjectUtil.isNull((Object)company.getMainLeaderName()) ? "" : company.getMainLeaderName());
            companyBaseDcInfo.setOccLeaderTel(ObjectUtil.isNull((Object)company.getMainLeaderTel()) ? "" : company.getMainLeaderTel());
            if (MapUtils.isNotEmpty(wandaDeclareMap)) {
                List<WandaDeclare> wandaDeclareList = wandaDeclareMap.get(id);
                if (CollectionUtils.isNotEmpty(wandaDeclareList)) {
                    List collect = wandaDeclareList.stream().sorted(Comparator.comparing(WandaDeclare::getDeclareTime, Comparator.reverseOrder())).collect(Collectors.toList());
                    if (collect.size() != 0) {
                        WandaDeclare wandaDeclare = (WandaDeclare)collect.get(0);
                        Date updateDate = wandaDeclare.getUpdateDate();
                        this.compareTime(valueMap, updateDate);
                        companyBaseDcInfo.setIsDeclare(Integer.valueOf(1));
                        String type = wandaDeclare.getDeclareType();
                        if (StringUtils.isNotEmpty((String)type)) {
                            if (type.equals("0")) {
                                companyBaseDcInfo.setDeclareType("\u521d\u6b21\u7533\u62a5");
                            } else if (type.equals("1")) {
                                companyBaseDcInfo.setDeclareType("\u53d8\u66f4\u7533\u62a5");
                            } else if (type.equals("2")) {
                                companyBaseDcInfo.setDeclareType("\u5e74\u5ea6\u66f4\u65b0");
                            } else {
                                companyBaseDcInfo.setDeclareType("");
                            }
                        } else {
                            companyBaseDcInfo.setDeclareType("");
                        }
                        companyBaseDcInfo.setDeclareYear((String)(ObjectUtil.isNull((Object)wandaDeclare.getDeclareTime()) ? "" : "" + (wandaDeclare.getDeclareTime().getYear() + 1900)));
                        companyBaseDcInfo.setDeclareTime(wandaDeclare.getDeclareTime());
                    } else {
                        companyBaseDcInfo.setIsDeclare(Integer.valueOf(0));
                        companyBaseDcInfo.setDeclareType("");
                        companyBaseDcInfo.setDeclareYear("");
                    }
                } else {
                    Boolean isReport = company.getIsReport();
                    if (ObjectUtil.isNotNull((Object)isReport) && isReport.booleanValue()) {
                        companyBaseDcInfo.setIsDeclare(Integer.valueOf(1));
                        companyBaseDcInfo.setDeclareType("\u521d\u6b21\u7533\u62a5");
                        companyBaseDcInfo.setDeclareYear("2020");
                    } else {
                        companyBaseDcInfo.setIsDeclare(Integer.valueOf(0));
                        companyBaseDcInfo.setDeclareType("");
                        companyBaseDcInfo.setDeclareYear("");
                    }
                }
            } else {
                Boolean isReport = company.getIsReport();
                if (ObjectUtil.isNotNull((Object)isReport) && isReport.booleanValue()) {
                    companyBaseDcInfo.setIsDeclare(Integer.valueOf(1));
                    companyBaseDcInfo.setDeclareType("\u521d\u6b21\u7533\u62a5");
                    companyBaseDcInfo.setDeclareYear("2020");
                } else {
                    companyBaseDcInfo.setIsDeclare(Integer.valueOf(0));
                    companyBaseDcInfo.setDeclareType("");
                    companyBaseDcInfo.setDeclareYear("");
                }
            }
            companyBaseDcInfo.setCreateTime(company.getCreateDate());
            companyBaseDcInfo.setOccManagerName(ObjectUtil.isNull((Object)company.getOccManagerName()) ? "" : company.getOccManagerName());
            companyBaseDcInfo.setOccManagerTel(ObjectUtil.isNull((Object)company.getOccManagerTel()) ? "" : company.getOccManagerTel());
            Integer legalCardType = company.getLegalCardType();
            if (ObjectUtil.isNotNull((Object)legalCardType) && (legalCardType == 1 || legalCardType == 2 || legalCardType == 3 || legalCardType == 4 || legalCardType == 5)) {
                companyBaseDcInfo.setLegalCardType(legalCardType.toString());
            } else {
                companyBaseDcInfo.setLegalCardType("");
            }
            String legalCardId = company.getLegalCardId();
            if (StringUtils.isNotEmpty((String)legalCardId)) {
                companyBaseDcInfo.setLegalCardNo(legalCardId);
            } else {
                companyBaseDcInfo.setLegalCardNo("");
            }
        }
    }

    private void certificateStaffDetailCalculation(Map<Long, List<CertificateStaffDetail>> certificateStaffDetailMap, CompanyBaseDcInfo companyBaseDcInfo, Map valueMap) {
        Long id;
        List<CertificateStaffDetail> certificateStaffDetails;
        companyBaseDcInfo.setHasMainManagTrain(Integer.valueOf(0));
        companyBaseDcInfo.setHasHseManagTrain(Integer.valueOf(0));
        if (MapUtils.isNotEmpty(certificateStaffDetailMap) && CollectionUtils.isNotEmpty(certificateStaffDetails = certificateStaffDetailMap.get(id = companyBaseDcInfo.getId()))) {
            for (CertificateStaffDetail certificateStaffDetail : certificateStaffDetails) {
                Date updateDate = certificateStaffDetail.getUpdateDate();
                this.compareTime(valueMap, updateDate);
                Long certId = certificateStaffDetail.getCertId();
                if (ObjectUtil.isNotNull((Object)certId) && certId == 12L) {
                    companyBaseDcInfo.setHasMainManagTrain(Integer.valueOf(1));
                    continue;
                }
                if (!ObjectUtil.isNotNull((Object)certId) || certId != 13L) continue;
                companyBaseDcInfo.setHasHseManagTrain(Integer.valueOf(1));
            }
        }
    }

    public void checkFactorTempCalculation(CompanyBaseDcInfo companyBaseDcInfo, CompanyBaseDcInfoModel company, Map valueMap) {
        companyBaseDcInfo.setHasDust(Integer.valueOf(0));
        companyBaseDcInfo.setHasChemistry(Integer.valueOf(0));
        companyBaseDcInfo.setHasPhysics(Integer.valueOf(0));
        companyBaseDcInfo.setHasRadiation(Integer.valueOf(0));
        companyBaseDcInfo.setHasBiology(Integer.valueOf(0));
        companyBaseDcInfo.setHasOther(Integer.valueOf(0));
        Date cftUpdateDate = company.getCftUpdateDate();
        this.compareTime(valueMap, cftUpdateDate);
        String type = company.getType();
        Date rpurUpdateDate = company.getRpurUpdateDate();
        if (StringUtils.isNotEmpty((String)type)) {
            if (type.contains("\u7c89\u5c18")) {
                companyBaseDcInfo.setHasDust(Integer.valueOf(1));
                companyBaseDcInfo.setSilicaDustCount((Integer)ObjectUtil.defaultIfNull((Object)company.getSilicaDustCount(), (Object)0));
                companyBaseDcInfo.setCoalDustCount((Integer)ObjectUtil.defaultIfNull((Object)company.getCoalDustCount(), (Object)0));
                companyBaseDcInfo.setAsbestosDustCount((Integer)ObjectUtil.defaultIfNull((Object)company.getAsbestosDustCount(), (Object)0));
                this.compareTime(valueMap, rpurUpdateDate);
            }
            if (type.contains("\u5316\u5b66\u56e0\u7d20")) {
                companyBaseDcInfo.setHasChemistry(Integer.valueOf(1));
                companyBaseDcInfo.setLeadCount((Integer)ObjectUtil.defaultIfNull((Object)company.getLeadCount(), (Object)0));
                companyBaseDcInfo.setBenzeneCount((Integer)ObjectUtil.defaultIfNull((Object)company.getBenzeneCount(), (Object)0));
                this.compareTime(valueMap, rpurUpdateDate);
            }
            if (type.contains("\u7269\u7406\u56e0\u7d20")) {
                companyBaseDcInfo.setHasPhysics(Integer.valueOf(1));
                companyBaseDcInfo.setNoiseCount((Integer)ObjectUtil.defaultIfNull((Object)company.getNoiseCount(), (Object)0));
                this.compareTime(valueMap, rpurUpdateDate);
            }
            if (type.contains("\u653e\u5c04\u56e0\u7d20")) {
                companyBaseDcInfo.setHasRadiation(Integer.valueOf(1));
                companyBaseDcInfo.setRadiationCount((Integer)ObjectUtil.defaultIfNull((Object)company.getRadiationCount(), (Object)0));
                this.compareTime(valueMap, rpurUpdateDate);
            }
            if (type.contains("\u751f\u7269\u56e0\u7d20")) {
                companyBaseDcInfo.setHasBiology(Integer.valueOf(1));
                companyBaseDcInfo.setBiologyCount((Integer)ObjectUtil.defaultIfNull((Object)company.getBiologyCount(), (Object)0));
                this.compareTime(valueMap, rpurUpdateDate);
            }
            if (type.contains("\u5176\u4ed6\u56e0\u7d20")) {
                companyBaseDcInfo.setHasOther(Integer.valueOf(1));
                companyBaseDcInfo.setOtherCount((Integer)ObjectUtil.defaultIfNull((Object)company.getOtherCount(), (Object)0));
                this.compareTime(valueMap, rpurUpdateDate);
            }
        }
    }

    private void chuangdeOrgCalculation(CompanyBaseDcInfo companyBaseDcInfo, Map<Long, ChuangdeSystemHealthSuperviseOrg> chuangdeSystemHealthSuperviseOrgMap, Map<Long, Long> areaMap, CompanyBaseDcInfoModel company, Map<Long, SysArea> sysAreaMap) {
        String workAddressCode;
        companyBaseDcInfo.setDeclareOrgName("");
        companyBaseDcInfo.setDeclareOrgCode("");
        Integer belongType = company.getBelongType();
        if (MapUtils.isNotEmpty(chuangdeSystemHealthSuperviseOrgMap) && StringUtils.isNotEmpty((String)(workAddressCode = companyBaseDcInfo.getWorkAddressCode())) && workAddressCode.chars().allMatch(Character::isDigit)) {
            Long areaId = Long.parseLong(workAddressCode);
            if (ObjectUtil.isNotNull((Object)belongType) && belongType == 2) {
                SysArea sysArea;
                Byte level;
                if (MapUtils.isNotEmpty(sysAreaMap) && ObjectUtil.isNotNull((Object)sysAreaMap.get(areaId)) && ObjectUtil.isNotNull((Object)(level = (sysArea = sysAreaMap.get(areaId)).getLevel()))) {
                    ChuangdeSystemHealthSuperviseOrg chuangdeSystemHealthSuperviseOrg;
                    Byte i = 0;
                    while (i < level - 2 && ObjectUtil.isNotNull((Object)(areaId = ObjectUtil.isNotNull((Object)sysArea) ? sysArea.getParentId() : null))) {
                        sysArea = sysAreaMap.get(areaId);
                        Byte by = i;
                        i = (byte)(i + 1);
                    }
                    if (ObjectUtil.isNotNull((Object)areaId) && ObjectUtil.isNotNull((Object)(chuangdeSystemHealthSuperviseOrg = chuangdeSystemHealthSuperviseOrgMap.get(areaId)))) {
                        companyBaseDcInfo.setDeclareOrgName(ObjectUtil.isNull((Object)chuangdeSystemHealthSuperviseOrg.getJgmc()) ? "" : chuangdeSystemHealthSuperviseOrg.getJgmc());
                        companyBaseDcInfo.setDeclareOrgCode(ObjectUtil.isNull((Object)chuangdeSystemHealthSuperviseOrg.getJgid()) ? "" : chuangdeSystemHealthSuperviseOrg.getJgid());
                    }
                }
            } else {
                ChuangdeSystemHealthSuperviseOrg chuangdeSystemHealthSuperviseOrg = chuangdeSystemHealthSuperviseOrgMap.get(areaId);
                if (MapUtils.isNotEmpty(areaMap)) {
                    for (int i = 0; i < 6 && !ObjectUtil.isNotNull((Object)chuangdeSystemHealthSuperviseOrg) && !ObjectUtil.isNull((Object)(areaId = areaMap.get(areaId))); ++i) {
                        chuangdeSystemHealthSuperviseOrg = chuangdeSystemHealthSuperviseOrgMap.get(areaId);
                    }
                }
                if (ObjectUtil.isNotNull((Object)chuangdeSystemHealthSuperviseOrg)) {
                    companyBaseDcInfo.setDeclareOrgName(ObjectUtil.isNull((Object)chuangdeSystemHealthSuperviseOrg.getJgmc()) ? "" : chuangdeSystemHealthSuperviseOrg.getJgmc());
                    companyBaseDcInfo.setDeclareOrgCode(ObjectUtil.isNull((Object)chuangdeSystemHealthSuperviseOrg.getJgid()) ? "" : chuangdeSystemHealthSuperviseOrg.getJgid());
                }
            }
        }
    }

    private void updateChuangDe(Map<Long, List<CertificateStaffDetail>> certificateStaffDetailMap, Map<Long, ChuangdeSystemHealthSuperviseOrg> chuangdeSystemHealthSuperviseOrgMap, Map<Long, Long> areaMap, Map<Long, List<WandaDeclare>> wandaDeclareMap, Map<Long, CompanyBaseDcInfoModel> companyBaseDcInfoModelMap, List<CompanyBaseDcInfo> newCompanyBaseDcInfoList, Map<Long, SysArea> sysAreaMap, Map<Long, CompanyHsePreventionControlSelfJudge> selfJudgeMap) {
        if (MapUtils.isNotEmpty(companyBaseDcInfoModelMap)) {
            for (Long id : companyBaseDcInfoModelMap.keySet()) {
                CompanyBaseDcInfoModel company = companyBaseDcInfoModelMap.get(id);
                if (ObjectUtil.isNull((Object)company)) continue;
                CompanyBaseDcInfo companyBaseDcInfo = new CompanyBaseDcInfo();
                companyBaseDcInfo.setId(id);
                HashMap<String, Date> valueMap = new HashMap<String, Date>();
                this.processingData(certificateStaffDetailMap, wandaDeclareMap, chuangdeSystemHealthSuperviseOrgMap, areaMap, id, company, companyBaseDcInfo, valueMap, sysAreaMap, selfJudgeMap);
                companyBaseDcInfo.setUpdateDate(new Date());
                companyBaseDcInfo.setCreateDate(new Date());
                companyBaseDcInfo.setIsValid(Boolean.valueOf(true));
                newCompanyBaseDcInfoList.add(companyBaseDcInfo);
            }
            if (CollectionUtils.isNotEmpty(newCompanyBaseDcInfoList)) {
                List partition = ListUtil.partition(newCompanyBaseDcInfoList, (int)1000);
                for (List companyBaseDcInfoList : partition) {
                    if (!CollectionUtils.isNotEmpty((Collection)companyBaseDcInfoList)) continue;
                    this.companyBaseDcInfoMapper.updateBatch(companyBaseDcInfoList);
                }
            }
            this.logger.info("\u521b\u5f97\u4e09\u65b9\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u66f4\u65b0>>>>\u66f4\u65b0\u6216\u65b0\u589e\u521b\u5f97\u4f01\u4e1a\u4fe1\u606f\u7edf\u8ba1\u62a5\u8868\u5171\uff1a{} \u6761 end-->{}", (Object)newCompanyBaseDcInfoList.size(), (Object)DateUtils.formatDate((Date)new Date()));
        }
    }
}

