/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.dataservice.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.modules.health.dataservice.entity.ChuangdeSystemAreaInfo;
import cn.smarthse.modules.health.dataservice.entity.ChuangdeSystemAreaInfoModel;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.services.dataservice.mapper.ChuangdeSystemAreaInfoMapper;
import cn.smarthse.services.dataservice.service.impl.ChuangdeApiBaseAreaServiceImpl;
import cn.smarthse.services.supervisionexelaw.model.ResponseResult;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.util.common.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChuangdeSystemAreaServiceImpl
extends ChuangdeApiBaseAreaServiceImpl<ChuangdeSystemAreaInfoMapper, ChuangdeSystemAreaInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChuangdeSystemAreaServiceImpl.class);
    @Autowired
    protected IdWorker idworker;

    @Override
    public List<ChuangdeSystemAreaInfo> convertObj(ResponseResult jsonObject) {
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getDataJson())) {
            List data = JSONArray.parseArray((String)jsonObject.getDataJson(), ChuangdeSystemAreaInfoModel.class);
            if (CollectionUtils.isEmpty((Collection)data)) {
                return null;
            }
            ArrayList<ChuangdeSystemAreaInfo> chuangdeSystemAreaInfos = new ArrayList<ChuangdeSystemAreaInfo>();
            ArrayList<Long> delSourceIdList = new ArrayList<Long>();
            for (ChuangdeSystemAreaInfoModel chuangdeSystemAreaInfoModel : data) {
                ChuangdeSystemAreaInfo chuangdeSystemAreaInfo = new ChuangdeSystemAreaInfo();
                chuangdeSystemAreaInfo.setId(Long.valueOf(this.idworker.nextId()));
                chuangdeSystemAreaInfo.setAreaId(null);
                chuangdeSystemAreaInfo.setSourceId(chuangdeSystemAreaInfoModel.getId());
                chuangdeSystemAreaInfo.setParentId(chuangdeSystemAreaInfoModel.getParentId());
                chuangdeSystemAreaInfo.setCode(chuangdeSystemAreaInfoModel.getCode());
                chuangdeSystemAreaInfo.setLevelCode(chuangdeSystemAreaInfoModel.getLevelCode());
                chuangdeSystemAreaInfo.setName(chuangdeSystemAreaInfoModel.getName());
                chuangdeSystemAreaInfo.setFullName(chuangdeSystemAreaInfoModel.getFullName());
                chuangdeSystemAreaInfo.setMatchingTimes(null);
                chuangdeSystemAreaInfo.setCreateDate(new Date());
                chuangdeSystemAreaInfo.setUpdateDate(new Date());
                chuangdeSystemAreaInfo.setIsValid(Boolean.valueOf(true));
                chuangdeSystemAreaInfos.add(chuangdeSystemAreaInfo);
                delSourceIdList.add(chuangdeSystemAreaInfoModel.getId());
            }
            UpdateWrapper update = Wrappers.update();
            update.in((Object)"source_id", delSourceIdList);
            ((ChuangdeSystemAreaInfoMapper)this.baseMapper).delete((Wrapper)update);
            return chuangdeSystemAreaInfos;
        }
        log.error("dataJson \u4e3a\u7a7a");
        return null;
    }

    @Override
    public String getTableNameEn() {
        return "area";
    }

    @Override
    public ChuangdeSystemAreaInfo getLatelyDataBySourceCreateTime() {
        return null;
    }

    public void delAll() {
        ((ChuangdeSystemAreaInfoMapper)this.baseMapper).delAll();
    }

    @Transactional
    public void chuangdeCodeToArea() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(ChuangdeSystemAreaInfo::getIsValid, (Object)true)).isNotNull(ChuangdeSystemAreaInfo::getSourceId);
        List chuangdeSystemAreaInfos = ((ChuangdeSystemAreaInfoMapper)this.baseMapper).selectList((Wrapper)wrapper);
        Map<Long, ChuangdeSystemAreaInfo> chuangdeSystemAreaInfoMap = chuangdeSystemAreaInfos.stream().collect(Collectors.toMap(ChuangdeSystemAreaInfo::getSourceId, c -> c, (c1, c2) -> c1));
        List<SysArea> allArea = ((ChuangdeSystemAreaInfoMapper)this.baseMapper).allArea();
        Map<String, List<SysArea>> areaMap = allArea.stream().filter(s -> ObjectUtil.isNotNull((Object)s.getName())).collect(Collectors.groupingBy(SysArea::getName));
        for (ChuangdeSystemAreaInfo chuangdeSystemAreaInfo : chuangdeSystemAreaInfos) {
            String name = chuangdeSystemAreaInfo.getName();
            String levelCode = chuangdeSystemAreaInfo.getLevelCode();
            String fullName = chuangdeSystemAreaInfo.getFullName();
            Long parentId = chuangdeSystemAreaInfo.getParentId();
            chuangdeSystemAreaInfo.setMatchingTimes(Integer.valueOf(1));
            if (StringUtils.isNotEmpty((String)name) && MapUtils.isNotEmpty(areaMap) && StringUtils.isNotEmpty((String)fullName)) {
                List<SysArea> sysAreas = areaMap.get(name);
                Integer level = 0;
                if (StringUtils.isNotEmpty((String)levelCode) && levelCode.chars().allMatch(Character::isDigit)) {
                    level = Integer.valueOf(levelCode);
                }
                Integer i = 0;
                while (i < level && ObjectUtil.isNull((Object)chuangdeSystemAreaInfo.getAreaId()) && ObjectUtil.isNotNull((Object)fullName)) {
                    if (CollectionUtils.isNotEmpty(sysAreas)) {
                        for (SysArea sysArea : sysAreas) {
                            if (levelCode.equals("3")) {
                                if (!fullName.contains(sysArea.getCityName()) || !fullName.contains(sysArea.getProvinceName())) continue;
                                chuangdeSystemAreaInfo.setAreaId(sysArea.getId());
                                chuangdeSystemAreaInfo.setMatchingTimes(Integer.valueOf(1 + i));
                                break;
                            }
                            if (levelCode.equals("4")) {
                                if (!fullName.contains(sysArea.getCityName()) || !fullName.contains(sysArea.getAreaName()) || !fullName.contains(sysArea.getProvinceName())) continue;
                                chuangdeSystemAreaInfo.setAreaId(sysArea.getId());
                                chuangdeSystemAreaInfo.setMatchingTimes(Integer.valueOf(1 + i));
                                break;
                            }
                            if (levelCode.equals("2")) {
                                if (!fullName.contains(sysArea.getProvinceName())) continue;
                                chuangdeSystemAreaInfo.setAreaId(sysArea.getId());
                                chuangdeSystemAreaInfo.setMatchingTimes(Integer.valueOf(1 + i));
                                break;
                            }
                            if (!levelCode.equals("1")) continue;
                            chuangdeSystemAreaInfo.setAreaId(sysArea.getId());
                            chuangdeSystemAreaInfo.setMatchingTimes(Integer.valueOf(1 + i));
                            break;
                        }
                    }
                    if (ObjectUtil.isNull((Object)chuangdeSystemAreaInfo.getAreaId()) && MapUtils.isNotEmpty(chuangdeSystemAreaInfoMap) && ObjectUtil.isNotNull((Object)parentId)) {
                        sysAreas = null;
                        fullName = null;
                        levelCode = null;
                        ChuangdeSystemAreaInfo chuangdeSystemAreaInfo1 = chuangdeSystemAreaInfoMap.get(parentId);
                        parentId = null;
                        if (ObjectUtil.isNotNull((Object)chuangdeSystemAreaInfo1) && ObjectUtil.isNotNull((Object)chuangdeSystemAreaInfo1.getName())) {
                            name = chuangdeSystemAreaInfo1.getName();
                            fullName = chuangdeSystemAreaInfo1.getFullName();
                            sysAreas = areaMap.get(name);
                            parentId = chuangdeSystemAreaInfo1.getParentId();
                            levelCode = chuangdeSystemAreaInfo1.getLevelCode();
                        }
                    }
                    Integer n = i;
                    i = i + 1;
                }
            }
            if (ObjectUtil.isNull((Object)chuangdeSystemAreaInfo.getAreaId())) {
                chuangdeSystemAreaInfo.setMatchingTimes(Integer.valueOf(0));
            }
            ((ChuangdeSystemAreaInfoMapper)this.baseMapper).updateById(chuangdeSystemAreaInfo);
        }
    }
}

