/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.dataref.service;

import cn.hutool.core.util.NumberUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.services.dataref.entity.CompanyRef;
import cn.smarthse.services.dataref.mapper.CompanyRefMapper;
import cn.smarthse.services.dataref.mapper.dto.CollectCertifi;
import cn.smarthse.services.dataref.mapper.dto.CollectCheck;
import cn.smarthse.services.dataref.mapper.dto.CollectDeclare;
import cn.smarthse.services.dataref.mapper.dto.CollectReport;
import cn.smarthse.services.dataref.vo.CompanyRefQueryVo;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.util.common.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CompanyRefServiceImpl
extends ServiceImpl<CompanyRefMapper, CompanyRef> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyRefServiceImpl.class);
    @Autowired
    private IdWorker snowFlake;
    @Autowired
    private CompanyRefMapper baseMapper;

    @Transactional(readOnly=false)
    public synchronized void collectCompanyRef() {
        List<CompanyRef> list = this.baseMapper.collectCompanyRef2();
        List<CollectCertifi> certifiList = this.baseMapper.collectCertifi();
        List<CollectCheck> checkiList = this.baseMapper.collectCheck();
        List<CollectReport> reportList = this.baseMapper.collectReport();
        List<CollectDeclare> declareList = this.baseMapper.collectDeclare();
        if (CollectionUtils.isNotEmpty(list)) {
            log.info("\u67e5\u8be2\u7edf\u8ba1\u6570\u636e\uff1a{}\u6761", (Object)list.size());
            Map<Object, Object> certifiListMap = new HashMap();
            if (CollectionUtils.isNotEmpty(certifiList)) {
                certifiListMap = certifiList.stream().collect(Collectors.toMap(k -> "" + k.getCid() + k.getCertId(), v -> v, (v1, v2) -> v1));
            }
            Map<Object, Object> riskListMap = new HashMap();
            if (CollectionUtils.isNotEmpty(checkiList)) {
                riskListMap = checkiList.stream().collect(Collectors.toMap(k -> k.getRiskId(), v -> v, (v1, v2) -> v1));
            }
            Map<Object, Object> reportListMap = new HashMap();
            if (CollectionUtils.isNotEmpty(reportList)) {
                reportListMap = reportList.stream().collect(Collectors.toMap(k -> k.getCid(), v -> v, (v1, v2) -> v1));
            }
            Map<Object, Object> declareListMap = new HashMap();
            if (CollectionUtils.isNotEmpty(declareList)) {
                declareListMap = declareList.stream().collect(Collectors.toMap(k -> k.getCid(), v -> v, (v1, v2) -> v1));
            }
            for (CompanyRef companyRef : list) {
                String scale;
                this.setDefaultValue(companyRef);
                companyRef.setCreateDate(new Date());
                companyRef.setId1(this.snowFlake.nextId());
                Long cid = companyRef.getCid();
                CollectCertifi collectCertifi12 = (CollectCertifi)certifiListMap.get(cid + "12");
                CollectCertifi collectCertifi13 = (CollectCertifi)certifiListMap.get(cid + "13");
                CollectReport collectReport = (CollectReport)reportListMap.get(cid);
                CollectDeclare collectDeclare = (CollectDeclare)declareListMap.get(cid);
                if (collectCertifi12 != null && collectCertifi12.getNum() > 0L) {
                    companyRef.setMainLeaderTrain("\u662f");
                }
                if (collectCertifi13 != null && collectCertifi13.getNum() > 0L) {
                    companyRef.setOccManagerTrain("\u662f");
                }
                Date reportUpdate = null;
                Date companyUpdate = null;
                if (companyRef.getUpdateDate() != null) {
                    companyUpdate = companyRef.getUpdateDate();
                }
                if (collectReport != null) {
                    companyRef.setFullTimeNum(this.long2Str(collectReport.getFullTimeNum()));
                    companyRef.setPartTimeNum(this.long2Str(collectReport.getPartTimeNum()));
                    companyRef.setStaffCount(this.long2Str(collectReport.getStaffCount()));
                    companyRef.setHarmStaffCount(this.long2Str(collectReport.getHarmStaffCount()));
                    if (Objects.equals(collectReport.getOccManage(), "1")) {
                        companyRef.setOccManage("\u6709");
                    } else {
                        companyRef.setOccManage("\u65e0");
                    }
                    reportUpdate = collectReport.getUpdateDate();
                    Long riskId = collectReport.getRiskId();
                    CollectCheck collectCheck = (CollectCheck)riskListMap.get(riskId);
                    if (collectCheck != null) {
                        if (collectCheck.getFc() != null && collectCheck.getFc() > 0L) {
                            companyRef.setContactDust("\u662f");
                        }
                        if (collectCheck.getHx() != null && collectCheck.getHx() > 0L) {
                            companyRef.setContactChemistry("\u662f");
                        }
                        if (collectCheck.getWl() != null && collectCheck.getWl() > 0L) {
                            companyRef.setContactPhysics("\u662f");
                        }
                        if (collectCheck.getFs() != null && collectCheck.getFs() > 0L) {
                            companyRef.setContactRadiation("\u662f");
                        }
                        if (collectCheck.getSw() != null && collectCheck.getSw() > 0L) {
                            companyRef.setContactBiology("\u662f");
                        }
                        if (collectCheck.getQt() != null && collectCheck.getQt() > 0L) {
                            companyRef.setContactOther("\u662f");
                        }
                        if (collectCheck.getType() != null) {
                            companyRef.setContainOcc("\u662f");
                        }
                    }
                }
                Date declaredate = null;
                if (collectDeclare != null) {
                    companyRef.setDecalareType(collectDeclare.getDeclareType());
                    companyRef.setDeclareTime(collectDeclare.getUpdateDate());
                    companyRef.setIsDecalare("\u662f");
                    declaredate = DateUtils.parseDate((Object)collectDeclare.getUpdateDate());
                }
                Date maxDate = DateUtils.getMaxDate((Date[])new Date[]{reportUpdate, companyUpdate, declaredate});
                companyRef.setUpdateTime(DateUtils.formatDateTime((Date)maxDate));
                String updateTime = companyRef.getUpdateTime();
                if (!DateUtils.isDate((String)updateTime) || Objects.equals(updateTime, "1970-01-01 00:00:00")) {
                    companyRef.setUpdateTime(null);
                }
                if (NumberUtil.isNumber((CharSequence)(scale = companyRef.getScale()))) continue;
                companyRef.setScale(null);
            }
            int delete = this.baseMapper.delete(null);
            log.info("\u5220\u9664\u6570\u636e\uff1a{}\u6761", (Object)delete);
            this.batchInsertcompanyRef(list);
        }
    }

    public void setDefaultValue(CompanyRef companyRef) {
        if (companyRef == null) {
            return;
        }
        companyRef.setContainOcc("\u5426");
        companyRef.setContactPhysics("\u5426");
        companyRef.setContactChemistry("\u5426");
        companyRef.setContactBiology("\u5426");
        companyRef.setContactOther("\u5426");
        companyRef.setContactRadiation("\u5426");
        companyRef.setContactDust("\u5426");
        companyRef.setMainLeaderTrain("\u5426");
        companyRef.setOccManagerTrain("\u5426");
        companyRef.setIsDecalare("\u5426");
    }

    public String long2Str(Long l) {
        if (l != null) {
            return l.toString();
        }
        return "0";
    }

    public int batchInsertcompanyRef(List<CompanyRef> gradeList) {
        int pointsDataLimit = 1000;
        int listSize = gradeList.size();
        int maxSize = listSize - 1;
        int n = 0;
        ArrayList<CompanyRef> newList = new ArrayList<CompanyRef>();
        for (int i = 0; i < gradeList.size(); ++i) {
            newList.add(gradeList.get(i));
            if (pointsDataLimit != newList.size() && i != maxSize) continue;
            log.info("\u8c03\u7528\u6279\u91cf\u63d2\u5165\uff1a{}\u6761", (Object)newList.size());
            this.baseMapper.insertcompanyRef(newList);
            newList.clear();
        }
        return n;
    }

    public PageInfo<CompanyRef> queryList(CompanyRefQueryVo queryVo) {
        String queryPara = queryVo.getQueryPara();
        String startDate = null;
        String endDate = null;
        if (StringUtils.isNotBlank((CharSequence)queryPara)) {
            try {
                JSONObject jsonObject = JSON.parseObject((String)queryPara);
                if (jsonObject != null) {
                    startDate = (String)jsonObject.get((Object)"updateStartDate");
                    endDate = (String)jsonObject.get((Object)"updateEndDate");
                }
            }
            catch (Exception e) {
                throw new HealthException("\u4f20\u5165queryPara\u67e5\u8be2\u53c2\u6570\u9519\u8bef");
            }
        }
        PageHelper.startPage((int)queryVo.getPageNum(), (int)queryVo.getPageSize());
        List<CompanyRef> list = this.baseMapper.pageCompanyRef(startDate, endDate);
        if (CollectionUtils.isNotEmpty(list)) {
            for (CompanyRef companyRef : list) {
                companyRef.setLegalName(SpringEncryptUtils.decrypt((String)companyRef.getLegalName()));
                companyRef.setLegalTel(SpringEncryptUtils.decrypt((String)companyRef.getLegalTel()));
                companyRef.setOccManagerName(SpringEncryptUtils.decrypt((String)companyRef.getOccManagerName()));
                companyRef.setOccManagerTel(SpringEncryptUtils.decrypt((String)companyRef.getOccManagerTel()));
                companyRef.setMainLeaderName(SpringEncryptUtils.decrypt((String)companyRef.getMainLeaderName()));
                companyRef.setMainLeaderTel(SpringEncryptUtils.decrypt((String)companyRef.getMainLeaderTel()));
            }
        }
        return new PageInfo(list);
    }

    public List<Map<String, Object>> collectGrade() {
        return this.baseMapper.collectGrade();
    }
}

