/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.dataref.controller;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.modules.datacentre.model.CompanyRefUpdateVo;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.bx.model.CompanyRefVo;
import cn.smarthse.modules.health.dataservice.service.ICompanyBaseDcInfoService;
import cn.smarthse.services.dataref.entity.CompanyRef;
import cn.smarthse.services.dataref.service.CompanyRefServiceImpl;
import cn.smarthse.services.dataref.vo.CompanyRefQueryVo;
import cn.smarthse.util.common.StringUtils;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hse/companyref"})
public class CompanyRefController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyRefController.class);
    @Autowired
    private CompanyRefServiceImpl companyRefService;
    @DubboReference(version="1.0.0", timeout=60000)
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Autowired
    private ICompanyBaseDcInfoService companyBaseDcInfoService;

    @ResponseBody
    @GetMapping(value={"collect"})
    public String collect() {
        this.companyRefService.collectCompanyRef();
        return "\u6267\u884c\u6210\u529f";
    }

    @ResponseBody
    @GetMapping(value={"collectGrade"})
    public List<Map<String, Object>> collectGrade() {
        return this.companyRefService.collectGrade();
    }

    @ResponseBody
    @GetMapping(value={"queryold"})
    public PageInfo<CompanyRef> query(CompanyRefQueryVo queryVo) {
        if (queryVo.getPageNum() == null) {
            queryVo.setPageNum(1);
        }
        if (queryVo.getPageSize() == null) {
            queryVo.setPageSize(1000);
        }
        PageInfo<CompanyRef> pageInfo1 = this.companyRefService.queryList(queryVo);
        return pageInfo1;
    }

    @ResponseBody
    @Deprecated
    public PageInfo<CompanyRefVo> queryv2(CompanyRefQueryVo queryVo) {
        if (queryVo.getPageNum() == null) {
            queryVo.setPageNum(1);
        }
        if (queryVo.getPageSize() == null) {
            queryVo.setPageSize(1000);
        }
        PageInfo companyBaseDcInfoServicePage = this.companyBaseDcInfoService.listBxCompany(queryVo.getPageSize(), queryVo.getPageNum(), queryVo.getQueryPara(), queryVo.getCid(), queryVo.getCname(), queryVo.getUnifiedSocialCc());
        return companyBaseDcInfoServicePage;
    }

    @ResponseBody
    @PostMapping(value={"update"})
    @Log(title="\u521b\u5f97-\u66f4\u65b0\u4f01\u4e1a\u6570\u636e")
    public ResponseData<String> update(@RequestBody List<CompanyRefUpdateVo> updateVoList) {
        if (CollectionUtils.isNotEmpty(updateVoList)) {
            for (CompanyRefUpdateVo companyRefUpdateVo : updateVoList) {
                if (!StringUtils.isBlank((CharSequence)companyRefUpdateVo.getId()) && !StringUtils.isBlank((CharSequence)companyRefUpdateVo.getName()) && !StringUtils.isBlank((CharSequence)companyRefUpdateVo.getUnifiedSocialCc())) continue;
                ResponseData data = new ResponseData();
                data.setContent("\u53c2\u6570\u9519\u8bef[id,name,unifiedSocialCc] \u90fd\u5e94\u4e3a\u5fc5\u586b\u9879");
                return data;
            }
        }
        int affectRows = this.companyProvideBySuperviseService.batchUpdateCompanyRef(updateVoList);
        ResponseData data = new ResponseData();
        data.setContent("\u6210\u529f\u66f4\u65b0" + affectRows + "\u6761\u6570\u636e");
        return data;
    }
}

