/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.config;

import cn.smarthse.services.config.property.ProjectProperties;
import cn.smarthse.services.interceptor.CommonInterceptor;
import cn.smarthse.services.interceptor.LogInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@SpringBootConfiguration
public class WebMvcConfig
implements WebMvcConfigurer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private CommonInterceptor commonInterceptor;
    private LogInterceptor logInterceptor;
    private ProjectProperties projectProperties;

    @Autowired
    public void setProjectProperties(ProjectProperties projectProperties) {
        this.projectProperties = projectProperties;
    }

    @Autowired
    public void setLogInterceptor(LogInterceptor logInterceptor) {
        this.logInterceptor = logInterceptor;
    }

    @Autowired
    public void setCommonInterceptor(CommonInterceptor commonInterceptor) {
        this.commonInterceptor = commonInterceptor;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.commonInterceptor).addPathPatterns(new String[]{"/**"});
        registry.addInterceptor((HandlerInterceptor)this.logInterceptor).addPathPatterns(new String[]{"/api/**"});
        registry.addInterceptor((HandlerInterceptor)this.logInterceptor).addPathPatterns(new String[]{"/hse/**"});
    }

    @Bean
    @Primary
    public RequestMappingHandlerMapping requestMappingHandlerMapping() {
        return new RequestMappingHandlerMapping();
    }
}

