/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.config;

import cn.smarthse.services.shiro.AppAuthFilter;
import cn.smarthse.services.shiro.ShiroAuthorizingCredentialsMatcher;
import cn.smarthse.services.shiro.ShiroAuthorizingRealm;
import cn.smarthse.services.shiro.ShiroFormAuthenticationFilter;
import cn.smarthse.services.shiro.StatelessDefaultSubjectFactory;
import jakarta.servlet.Filter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.context.annotation.Bean;

@SpringBootConfiguration
public class ShiroConfig {
    @Bean
    public LifecycleBeanPostProcessor getLifecycleBeanPostProcessor() {
        return new LifecycleBeanPostProcessor();
    }

    @Bean
    public ShiroAuthorizingRealm getShiroAuthorizingRealm() {
        ShiroAuthorizingRealm shiroAuthorizingRealm = new ShiroAuthorizingRealm();
        shiroAuthorizingRealm.setCredentialsMatcher((CredentialsMatcher)this.getShiroAuthorizingCredentialsMatcher());
        return shiroAuthorizingRealm;
    }

    @Bean
    public DefaultWebSecurityManager securityManager() {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm((Realm)this.getShiroAuthorizingRealm());
        securityManager.setSubjectFactory((SubjectFactory)this.getStatelessDefaultSubjectFactory());
        return securityManager;
    }

    @Bean
    public ShiroFilterFactoryBean shiroFilterChainDefinition(SecurityManager securityManager) {
        ShiroFilterFactoryBean filterFactoryBean = new ShiroFilterFactoryBean();
        filterFactoryBean.setSecurityManager((SecurityManager)this.securityManager());
        filterFactoryBean.setLoginUrl("/login");
        filterFactoryBean.setFilters(this.getFiltersMap());
        filterFactoryBean.setFilterChainDefinitionMap(this.getFilterChainDefinitionMap());
        return filterFactoryBean;
    }

    private LinkedHashMap<String, String> getFilterChainDefinitionMap() {
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        filterChainDefinitionMap.put("/api/online/monitor/getToken", "noSessionCreation,anon");
        filterChainDefinitionMap.put("/login", "noSessionCreation,anon");
        filterChainDefinitionMap.put("/swagger-ui.html", "noSessionCreation,anon");
        filterChainDefinitionMap.put("/swagger-resources/**", "noSessionCreation,anon");
        filterChainDefinitionMap.put("/v2/api-docs/**", "noSessionCreation,anon");
        filterChainDefinitionMap.put("/apiDoc/**", "noSessionCreation,anon");
        filterChainDefinitionMap.put("/webjars/**", "noSessionCreation,anon");
        filterChainDefinitionMap.put("/favicon.ico", "noSessionCreation,anon");
        filterChainDefinitionMap.put("/supervision/**", "noSessionCreation,anon");
        filterChainDefinitionMap.put("/wanda/**", "noSessionCreation,anon");
        filterChainDefinitionMap.put("/zlb/**", "noSessionCreation,anon");
        filterChainDefinitionMap.put("/threeTime/**", "noSessionCreation,anon");
        filterChainDefinitionMap.put("/hse/companyref/**", "noSessionCreation,anon");
        filterChainDefinitionMap.put("/hse/dataservice/**", "noSessionCreation,anon");
        filterChainDefinitionMap.put("/**", "noSessionCreation,appAuth");
        return filterChainDefinitionMap;
    }

    private Map<String, Filter> getFiltersMap() {
        LinkedHashMap<String, Filter> filterChainDefinitionMap = new LinkedHashMap<String, Filter>();
        filterChainDefinitionMap.put("appAuth", (Filter)new AppAuthFilter());
        return filterChainDefinitionMap;
    }

    @Bean
    public ShiroAuthorizingCredentialsMatcher getShiroAuthorizingCredentialsMatcher() {
        ShiroAuthorizingCredentialsMatcher matcher = new ShiroAuthorizingCredentialsMatcher();
        matcher.setRetryCount(3);
        matcher.setRetryFailCount(10);
        matcher.setHashAlgorithmName("SHA-1");
        matcher.setStoredCredentialsHexEncoded(true);
        return matcher;
    }

    @Bean
    public ShiroFormAuthenticationFilter getShiroFormAuthenticationFilter() {
        return new ShiroFormAuthenticationFilter();
    }

    @Bean
    public StatelessDefaultSubjectFactory getStatelessDefaultSubjectFactory() {
        return new StatelessDefaultSubjectFactory();
    }

    @Bean
    public static DefaultAdvisorAutoProxyCreator getDefaultAdvisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        defaultAdvisorAutoProxyCreator.setUsePrefix(true);
        return defaultAdvisorAutoProxyCreator;
    }
}

