/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.bx.service.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.util.BeanUtils;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.bx.entity.BxZyb;
import cn.smarthse.modules.health.bx.model.BxZybDetailVo;
import cn.smarthse.modules.health.bx.model.BxZybVo;
import cn.smarthse.modules.health.bx.model.ZybCountUpdateVo;
import cn.smarthse.modules.health.bx.param.BxZybAppendParam;
import cn.smarthse.modules.health.bx.service.IBxYszybService;
import cn.smarthse.modules.health.bx.service.IBxZybService;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyExitItem;
import cn.smarthse.modules.health.entity.base.staff.StaffInfoSearchParam;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyExitItem;
import cn.smarthse.modules.health.param.FcythSearchParam;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.supervise.model.home.v3223.onlineMonitoring.PneumocoPieChartData;
import cn.smarthse.modules.health.vo.work.check.OccPatientVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.services.bx.mapper.BxZybMapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bxZybService")
@DubboService
public class BxZybServiceImpl
extends ServiceImpl<BxZybMapper, BxZyb>
implements IBxZybService {
    @Autowired
    private IBxYszybService yszybService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    private ICompanyProvideService companyProvideService;

    @Transactional(readOnly=false)
    public List<Long> appendData(List<BxZybAppendParam> param) {
        ArrayList<Long> failIds = new ArrayList<Long>();
        List list = param.stream().map(item -> {
            BxZyb bxZyb = new BxZyb();
            BeanUtils.copyBeanProp((Object)bxZyb, (Object)item);
            bxZyb.setCreateDate(new Date());
            bxZyb.setUpdateDate(new Date());
            bxZyb.setIsValid(Boolean.valueOf(true));
            return bxZyb;
        }).collect(Collectors.toList());
        int totalSize = list.size();
        int batchSize = 1000;
        for (int i = 0; i < totalSize; i += batchSize) {
            List batch = list.subList(i, Math.min(i + batchSize, totalSize));
            try {
                this.saveOrUpdateBatch(batch);
                continue;
            }
            catch (Exception e) {
                failIds.addAll(batch.stream().map(BxZyb::getId).collect(Collectors.toList()));
            }
        }
        return failIds;
    }

    public Integer getCfbNum(SearchParam param) {
        return ((BxZybMapper)this.baseMapper).getCfbNum(param);
    }

    public List<PneumocoPieChartData> pneumoconiosisPieChartData(SearchParam param) {
        AreaModel areaModel = this.sysAreaProvideService.getAreaById(param.getAreaId());
        List<PneumocoPieChartData> pieChartDataList = ((BxZybMapper)this.baseMapper).pneumoconiosisPieChartData(areaModel.getId(), areaModel.getLevel(), param.getIsCurrent());
        if (CollectionUtils.isNotEmpty(pieChartDataList)) {
            if (pieChartDataList.size() <= 3) {
                pieChartDataList.add(new PneumocoPieChartData("\u5176\u4ed6", Integer.valueOf(0)));
            } else {
                List<PneumocoPieChartData> pneumocoPieChartData = pieChartDataList.subList(0, 2);
                List<PneumocoPieChartData> otherList = pieChartDataList.subList(2, pieChartDataList.size() - 1);
                Integer otherNum = otherList.stream().map(PneumocoPieChartData::getValue).reduce(0, Integer::sum);
                pneumocoPieChartData.add(new PneumocoPieChartData("\u5176\u4ed6", otherNum));
                pieChartDataList = pneumocoPieChartData;
            }
        }
        return pieChartDataList;
    }

    public Integer countZybNum(String unifiedSocialCc) {
        return ((BxZybMapper)this.baseMapper).countZybNum(unifiedSocialCc);
    }

    public List<ComplianceCompanyExitItem> countComplianceZybNum(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        Map<String, Long> cidCreditCodeMap = this.getCidCreditCodeMap(cids);
        ArrayList<String> creditCodeList = new ArrayList<String>(cidCreditCodeMap.keySet());
        List<ComplianceCompanyExitItem> list = ((BxZybMapper)this.baseMapper).countComplianceZybNum(creditCodeList);
        for (ComplianceCompanyExitItem complianceCompanyExitItem : list) {
            complianceCompanyExitItem.setCid(cidCreditCodeMap.get(complianceCompanyExitItem.getCreditCode()));
        }
        return list;
    }

    public List<NewComplianceCompanyExitItem> countNewComplianceZybNum(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        Map<String, Long> cidCreditCodeMap = this.getCidCreditCodeMap(cids);
        ArrayList<String> creditCodeList = new ArrayList<String>(cidCreditCodeMap.keySet());
        List<NewComplianceCompanyExitItem> list = ((BxZybMapper)this.baseMapper).countNewComplianceZybNum(creditCodeList);
        for (NewComplianceCompanyExitItem complianceCompanyExitItem : list) {
            complianceCompanyExitItem.setCid(cidCreditCodeMap.get(complianceCompanyExitItem.getCreditCode()));
        }
        return list;
    }

    public Map<String, Long> getCidCreditCodeMap(List<Long> cids) {
        List<Company> list = ((BxZybMapper)this.baseMapper).getCreditCodeList(cids);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (Company company : list) {
            map.put(company.getUnifiedSocialCc(), company.getId());
        }
        return map;
    }

    public PageInfo<OccPatientVo> getPatientList(FcythSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new PageInfo(((BxZybMapper)this.baseMapper).getPatientList(param));
    }

    public PageInfo<BxZybVo> getZybPatientList(FcythSearchParam param, Integer type) {
        List<BxZybVo> bxZybVoList = ((BxZybMapper)this.baseMapper).selectZybPatientList(param);
        List<BxZybVo> bxJdVoList = ((BxZybMapper)this.baseMapper).selectJdPatientList(param);
        bxZybVoList.addAll(bxJdVoList);
        List<BxZybVo> bxZybVos = this.distinctByNameAndIdcard(bxZybVoList);
        List<Object> lastBxZybVos = new ArrayList();
        PageInfo pageInfo = new PageInfo();
        if (type == 1) {
            lastBxZybVos = bxZybVos.stream().filter(entity -> ObjectUtil.isNotNull((Object)entity)).peek(entity -> {
                Integer dataSources;
                String occupationalName;
                String idcard = entity.getIdcard();
                if (StringUtils.isNotEmpty((String)idcard) && idcard.length() >= 15) {
                    entity.setGender(IDCardUtil.getGender((String)entity.getIdcard()));
                    entity.setAge(Integer.valueOf(IDCardUtil.getAge((String)entity.getIdcard())));
                }
                if (StringUtils.isEmpty((CharSequence)(occupationalName = entity.getOccupationalName())) || occupationalName.equals("--")) {
                    entity.setOccupationalName(entity.getDiagnosisOccupationalName());
                }
                if (ObjectUtil.isNotNull((Object)(dataSources = entity.getDataSources()))) {
                    String period = this.determinePeriod((BxZybVo)entity, dataSources);
                    entity.setPeriod(period);
                }
            }).sorted((e1, e2) -> {
                Date date1 = e1.getDiagnosisDate();
                Date date2 = e2.getDiagnosisDate();
                if (date1 == null && date2 == null) {
                    return 0;
                }
                if (date1 == null) {
                    return 1;
                }
                if (date2 == null) {
                    return -1;
                }
                return date2.compareTo(date1);
            }).collect(Collectors.toList());
            pageInfo = PageUtil.getPageInfo(lastBxZybVos, (int)param.getPage(), (int)param.getRows());
        } else if (type == 3) {
            lastBxZybVos = bxZybVos.stream().filter(entity -> ObjectUtil.isNotNull((Object)entity)).collect(Collectors.toList());
            pageInfo.setList(lastBxZybVos);
            pageInfo.setTotal((long)lastBxZybVos.size());
        }
        return pageInfo;
    }

    public List<ZybCountUpdateVo> getZybCountUpdateLog(FcythSearchParam param) {
        List cidList = param.getCidList();
        if (CollectionUtils.isEmpty((Collection)cidList)) {
            return Collections.emptyList();
        }
        return ((BxZybMapper)this.baseMapper).getZybCountUpdateLog(param);
    }

    @Transactional
    public void addOrUpdZybCountUpdate(List<ZybCountUpdateVo> addOrUpdList) {
        if (CollectionUtils.isNotEmpty(addOrUpdList)) {
            List partition = ListUtil.partition(addOrUpdList, (int)1000);
            for (List zybCountUpdateVos : partition) {
                ((BxZybMapper)this.baseMapper).batchInsertOrUpdateAddZybCountUpdate(zybCountUpdateVos);
            }
        }
    }

    public List<ZybCountUpdateVo> getZybStaffCount(StaffInfoSearchParam param) {
        List cidList = param.getCidList();
        List idCardList = param.getIdCardList();
        if (CollectionUtils.isEmpty((Collection)idCardList) || CollectionUtils.isEmpty((Collection)cidList)) {
            return new ArrayList<ZybCountUpdateVo>();
        }
        List idCardListEnc = idCardList.stream().map(SpringEncryptUtils::encrypt).collect(Collectors.toList());
        param.setIdCardList(idCardListEnc);
        param.setIsSeniorSearch(Global.FALSE);
        param.setSearchKey(null);
        param.setWorkRoleInfoId(null);
        param.setWorkStatus(Byte.valueOf((byte)1));
        return ((BxZybMapper)this.baseMapper).getZybStaffCount(param);
    }

    public BxZybDetailVo getZybPatientDetailById(FcythSearchParam param) {
        Integer dataSources = param.getDataSources();
        Long id = param.getId();
        if (ObjectUtil.isNull((Object)dataSources) || ObjectUtil.isNull((Object)id)) {
            throw new HealthException("\u6570\u636e\u6e90\u672a\u6307\u5b9a\u6216\u672a\u9009\u5b9a\u804c\u4e1a\u75c5\u60a3\u8005");
        }
        BxZybDetailVo bxZybDetailVo = new BxZybDetailVo();
        bxZybDetailVo = dataSources == 1 ? ((BxZybMapper)this.baseMapper).selectBxZybDetailById(param) : ((BxZybMapper)this.baseMapper).selectBxJdDetailById(param);
        this.assignmentPeriod(bxZybDetailVo, dataSources);
        return bxZybDetailVo;
    }

    public List<String> getAllZybPatientUnifiedSocialCc(List<String> unifiedSocialCcList) {
        return ((BxZybMapper)this.baseMapper).getAllZybPatientUnifiedSocialCc(unifiedSocialCcList);
    }

    public void setResetAndNumberUpdate(List<Long> addOrUpdCidList) {
        ((BxZybMapper)this.baseMapper).setResetAndNumberUpdate(addOrUpdCidList);
    }

    public void bxZybDiagnosisYearGroupTableRefresh() {
        ((BxZybMapper)this.baseMapper).truncateBxZybDiagnosisYearGroupTable();
        ((BxZybMapper)this.baseMapper).insertBxZybDiagnosisYearGroupTable();
    }

    public PageInfo<BxZybVo> getStatisticZybPatientPage(FcythSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<BxZybVo> bxZybVos = ((BxZybMapper)this.baseMapper).getStatisticZybPatientPage(param);
        for (BxZybVo bxZybVo : bxZybVos) {
            String period = this.determinePeriod(bxZybVo, 2);
            bxZybVo.setPeriod(period);
        }
        return new PageInfo(bxZybVos);
    }

    public BxZybDetailVo getStatisticZybDetailsById(FcythSearchParam param) {
        Integer dataSources = param.getDataSources();
        Long id = param.getId();
        if (ObjectUtil.isNull((Object)dataSources) || ObjectUtil.isNull((Object)id)) {
            throw new HealthException("\u6570\u636e\u6e90\u672a\u6307\u5b9a\u6216\u672a\u9009\u5b9a\u804c\u4e1a\u75c5\u60a3\u8005");
        }
        BxZybDetailVo bxZybDetailVo = new BxZybDetailVo();
        if (dataSources == 1) {
            bxZybDetailVo = ((BxZybMapper)this.baseMapper).getBxZybDetailsById(param);
        } else {
            bxZybDetailVo = ((BxZybMapper)this.baseMapper).getBxJdDetailsById(param);
            String cfb1 = bxZybDetailVo.getCfb1();
            String cfb2 = bxZybDetailVo.getCfb2();
            String cfb3 = bxZybDetailVo.getCfb3();
            bxZybDetailVo.setCfb1date(StringUtils.isNumeric((CharSequence)cfb1) ? new Date(Long.valueOf(cfb1)) : null);
            bxZybDetailVo.setCfb2date(StringUtils.isNumeric((CharSequence)cfb2) ? new Date(Long.valueOf(cfb2)) : null);
            bxZybDetailVo.setCfb3date(StringUtils.isNumeric((CharSequence)cfb3) ? new Date(Long.valueOf(cfb3)) : null);
        }
        return bxZybDetailVo;
    }

    private String determinePeriod(BxZybVo entity, Integer dataSources) {
        String period = null;
        if (dataSources == 1) {
            Date appraisalCf3Date = entity.getAppraisalCf3Date();
            Date appraisalCf2Date = entity.getAppraisalCf2Date();
            Date appraisalCf1Date = entity.getAppraisalCf1Date();
            Date cfb3date = entity.getCfb3date();
            Date cfb2date = entity.getCfb2date();
            Date cfb1date = entity.getCfb1date();
            if (ObjectUtil.isNotNull((Object)appraisalCf3Date)) {
                period = "\u4e09\u671f";
            } else if (ObjectUtil.isNotNull((Object)appraisalCf2Date)) {
                period = "\u4e8c\u671f";
            } else if (ObjectUtil.isNotNull((Object)appraisalCf1Date)) {
                period = "\u4e00\u671f";
            } else if (ObjectUtil.isNotNull((Object)cfb3date)) {
                period = "\u4e09\u671f";
            } else if (ObjectUtil.isNotNull((Object)cfb2date)) {
                period = "\u4e8c\u671f";
            } else if (ObjectUtil.isNotNull((Object)cfb1date)) {
                period = "\u4e00\u671f";
            }
        } else if (dataSources == 2) {
            Date appraisalCf3Date = entity.getAppraisalCf3Date();
            Date appraisalCf2Date = entity.getAppraisalCf2Date();
            Date appraisalCf1Date = entity.getAppraisalCf1Date();
            String cfb3 = entity.getCfb3();
            String cfb2 = entity.getCfb2();
            String cfb1 = entity.getCfb1();
            if (ObjectUtil.isNotNull((Object)appraisalCf3Date)) {
                period = "\u4e09\u671f";
            } else if (ObjectUtil.isNotNull((Object)appraisalCf2Date)) {
                period = "\u4e8c\u671f";
            } else if (ObjectUtil.isNotNull((Object)appraisalCf1Date)) {
                period = "\u4e00\u671f";
            } else if (StringUtils.isNotEmpty((String)cfb3)) {
                period = "\u4e09\u671f";
            } else if (StringUtils.isNotEmpty((String)cfb2)) {
                period = "\u4e8c\u671f";
            } else if (StringUtils.isNotEmpty((String)cfb1)) {
                period = "\u4e00\u671f";
            }
        }
        return period;
    }

    private void assignmentPeriod(BxZybDetailVo bxZybDetailVo, Integer dataSources) {
        String appraisalPeriod = null;
        String diagnosisPeriod = null;
        Date appraisalCf3Date = bxZybDetailVo.getAppraisalCf3Date();
        Date appraisalCf2Date = bxZybDetailVo.getAppraisalCf2Date();
        Date appraisalCf1Date = bxZybDetailVo.getAppraisalCf1Date();
        if (ObjectUtil.isNotNull((Object)appraisalCf3Date)) {
            appraisalPeriod = "\u4e09\u671f";
        } else if (ObjectUtil.isNotNull((Object)appraisalCf2Date)) {
            appraisalPeriod = "\u4e8c\u671f";
        } else if (ObjectUtil.isNotNull((Object)appraisalCf1Date)) {
            appraisalPeriod = "\u4e00\u671f";
        }
        if (dataSources == 1) {
            Date cfb3date = bxZybDetailVo.getCfb3date();
            Date cfb2date = bxZybDetailVo.getCfb2date();
            Date cfb1date = bxZybDetailVo.getCfb1date();
            if (ObjectUtil.isNotNull((Object)cfb3date)) {
                diagnosisPeriod = "\u4e09\u671f";
            } else if (ObjectUtil.isNotNull((Object)cfb2date)) {
                diagnosisPeriod = "\u4e8c\u671f";
            } else if (ObjectUtil.isNotNull((Object)cfb1date)) {
                diagnosisPeriod = "\u4e00\u671f";
            }
        } else if (dataSources == 2) {
            String cfb3 = bxZybDetailVo.getCfb3();
            String cfb2 = bxZybDetailVo.getCfb2();
            String cfb1 = bxZybDetailVo.getCfb1();
            if (StringUtils.isNotEmpty((String)cfb3)) {
                diagnosisPeriod = "\u4e09\u671f";
            } else if (StringUtils.isNotEmpty((String)cfb2)) {
                diagnosisPeriod = "\u4e8c\u671f";
            } else if (StringUtils.isNotEmpty((String)cfb1)) {
                diagnosisPeriod = "\u4e00\u671f";
            }
        }
        bxZybDetailVo.setDiagnosisPeriod(diagnosisPeriod);
        bxZybDetailVo.setAppraisalPeriod(appraisalPeriod);
    }

    private List<BxZybVo> distinctByNameAndIdcard(List<BxZybVo> bxZybVoList) {
        if (CollectionUtils.isEmpty(bxZybVoList)) {
            return new ArrayList<BxZybVo>();
        }
        List validList = bxZybVoList.stream().filter(b -> ObjectUtil.isNotNull((Object)b) && StringUtils.isNotEmpty((String)b.getIdcard())).collect(Collectors.toList());
        List<BxZybVo> distinctList = validList.stream().collect(Collectors.toMap(b -> b.getStaffName() + "|" + b.getIdcard() + "|" + b.getEmployersCreditCode(), b -> b, (existing, replacement) -> {
            Date minCreateTime = null;
            Date existingCreateDate = existing.getMinCreateDate();
            Date replacementCreateDate = replacement.getMinCreateDate();
            minCreateTime = existingCreateDate == null ? replacementCreateDate : (replacementCreateDate == null ? existingCreateDate : Collections.min(Arrays.asList(existingCreateDate, replacementCreateDate)));
            existing.setMinCreateDate(minCreateTime);
            replacement.setMinCreateDate(minCreateTime);
            Date existingTime = existing.getDiagnosisDate();
            Date replacementTime = replacement.getDiagnosisDate();
            if (existingTime == null) {
                return replacement;
            }
            if (replacementTime == null) {
                return existing;
            }
            return replacementTime.after(existingTime) ? replacement : existing;
        })).values().stream().collect(Collectors.toList());
        return distinctList;
    }

    public List<Long> appendData1(List<BxZyb> param) {
        List list = param.stream().map(item -> {
            BxZyb BxZyb2 = new BxZyb();
            BeanUtils.copyBeanProp((Object)BxZyb2, (Object)item);
            BxZyb2.setCreateDate(new Date());
            BxZyb2.setUpdateDate(new Date());
            return BxZyb2;
        }).collect(Collectors.toList());
        int batchSize = 1000;
        AtomicInteger successCount = new AtomicInteger();
        Map<Long, List<BxZyb>> partitionedData = IntStream.range(0, list.size()).boxed().collect(Collectors.partitioningBy(i -> i % batchSize == 0, Collectors.mapping(list::get, Collectors.toList()))).entrySet().stream().flatMap(entry -> {
            List batch = (List)entry.getValue();
            try {
                successCount.addAndGet(this.saveBatch(batch) ? batch.size() : 0);
                return Stream.empty();
            }
            catch (Exception e) {
                return batch.stream();
            }
        }).collect(Collectors.groupingBy(BxZyb::getId));
        ArrayList<Long> failIds = new ArrayList<Long>(partitionedData.keySet());
        failIds.removeAll(partitionedData.getOrDefault(true, Collections.emptyList()).stream().map(BxZyb::getId).collect(Collectors.toList()));
        return failIds;
    }
}

