/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.bx.service.impl;

import cn.smarthse.common.util.BeanUtils;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.bx.entity.BxFxhj;
import cn.smarthse.modules.health.bx.entity.BxRiskReport;
import cn.smarthse.modules.health.bx.service.IBxRiskReportService;
import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.reform.ReformItemSource;
import cn.smarthse.services.bx.mapper.BxRiskReportMapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import jakarta.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
public class BxRiskReportServiceImpl
implements IBxRiskReportService {
    @Resource
    BxRiskReportMapper dao;
    @DubboReference
    ISysFileProvideService sysFileProvideService;

    public BxRiskReport saveOne(BxRiskReport bxRiskReport) {
        bxRiskReport.setId(Long.valueOf(IdWorker.getId()));
        this.dao.insertDb(bxRiskReport);
        return bxRiskReport;
    }

    public BxRiskReport getBxRiskReportInfo(Long id, Map<String, Object> map) {
        if (id == null) {
            throw new ServiceException("\u6570\u636eid\u4e3a\u7a7a");
        }
        BxRiskReport model = this.dao.getById(id);
        if (model == null) {
            return null;
        }
        if (model.getViewRecordId() != null) {
            model.setViewRecordFile(this.sysFileProvideService.getFileById(model.getViewRecordId()));
        }
        if (model.getBackgroudId() != null) {
            model.setBackgroudFile(this.sysFileProvideService.getFileById(model.getBackgroudId()));
        }
        return model;
    }

    @Transactional(readOnly=false)
    public void updateCheckRiskState(Integer type) {
        this.dao.updateCheckRiskState("reform_item_basic", type);
        this.dao.updateCheckRiskState("reform_item_source", type);
    }

    @Transactional(readOnly=false)
    public void generateOnlineRisk() {
        this.delOnlineRisk();
        this.addCompany1();
        this.addCompany2();
        this.addCompany3();
    }

    private void addCompany1() {
        Long id = 1820731941121581058L;
        Long cid = 99657571579441900L;
        String dataStr = "2025-12-09 14:19:00";
        Date date = DateUtils.parseDate((Object)dataStr);
        String massage = "\u566a\u58f0\u5f3a\u5ea6\u8d85\u6807\u65f6\uff0c\u672a\u4f69\u6234\u8033\u7f6e\u4eba\u5458\u8fdb\u5165";
        Long deviceId = 4636547048343552L;
        BxRiskReport report = new BxRiskReport();
        report.setId(id);
        report.setCid(cid);
        report.setDeviceId(deviceId);
        report.setRiskType(Byte.valueOf((byte)2));
        report.setInstallStation("\u8f66\u95f4");
        report.setFindTime(date);
        report.setDescribe(massage);
        report.setFactorId(Long.valueOf(567L));
        report.setFactorName("\u566a\u58f0");
        report.setFactorValue(Double.valueOf(94.6));
        report.setViewRecord(null);
        report.setViewRecordId(Long.valueOf(1998336710392995842L));
        report.setBackgroud(null);
        report.setBackgroudId(Long.valueOf(1998336464753582082L));
        report.setCreateDate(date);
        report.setUpdateDate(date);
        this.dao.addBxRiskReport(report);
        this.generateOnlineRiskDetail(id, cid, dataStr, massage, (byte)2);
    }

    private void addCompany2() {
        Long id = 1820731941121581059L;
        Long cid = 4927705139842884127L;
        String dataStr = "2025-12-09 11:21:00";
        Date date = DateUtils.parseDate((Object)dataStr);
        String massage = "\u7c89\u5c18\u6d53\u5ea6\u8d85\u6807\u65f6\uff0c\u672a\u4f69\u6234\u9632\u5c18\u53e3\u7f69\u4eba\u5458\u8fdb\u5165";
        Long deviceId = 4726616225335296L;
        BxRiskReport report = new BxRiskReport();
        report.setId(id);
        report.setCid(cid);
        report.setDeviceId(deviceId);
        report.setRiskType(Byte.valueOf((byte)2));
        report.setInstallStation("\u94f8\u953b\u8f66\u95f4");
        report.setFindTime(date);
        report.setDescribe(massage);
        report.setFactorId(Long.valueOf(654L));
        report.setFactorName("\u5176\u4ed6\u7c89\u5c18");
        report.setFactorValue(Double.valueOf(1.05));
        report.setViewRecord(null);
        report.setViewRecordId(Long.valueOf(1998337732539699201L));
        report.setBackgroud(null);
        report.setBackgroudId(Long.valueOf(1998337567695163394L));
        report.setCreateDate(date);
        report.setUpdateDate(date);
        this.dao.addBxRiskReport(report);
        this.generateOnlineRiskDetail(id, cid, dataStr, massage, (byte)2);
    }

    private void addCompany3() {
        Long id = 1820731941121581060L;
        Long cid = 99657571579870439L;
        String dataStr = "2025-12-09 11:24:00";
        Date date = DateUtils.parseDate((Object)dataStr);
        String massage = "\u7c89\u5c18\u6d53\u5ea6\u8d85\u6807\u65f6\uff0c\u672a\u4f69\u6234\u9632\u5c18\u53e3\u7f69\u4eba\u5458\u8fdb\u5165";
        Long deviceId = 4671137941293056L;
        BxRiskReport report = new BxRiskReport();
        report.setId(id);
        report.setCid(cid);
        report.setDeviceId(deviceId);
        report.setRiskType(Byte.valueOf((byte)2));
        report.setInstallStation("\u8f66\u95f4");
        report.setFindTime(date);
        report.setDescribe(massage);
        report.setFactorId(Long.valueOf(654L));
        report.setFactorName("\u5176\u4ed6\u7c89\u5c18");
        report.setFactorValue(Double.valueOf(2.05));
        report.setViewRecord(null);
        report.setViewRecordId(Long.valueOf(1998338696323649538L));
        report.setBackgroud(null);
        report.setBackgroudId(Long.valueOf(1998338839857913857L));
        report.setCreateDate(date);
        report.setUpdateDate(date);
        this.dao.addBxRiskReport(report);
        this.generateOnlineRiskDetail(id, cid, dataStr, massage, (byte)2);
    }

    private void generateOnlineRiskDetail(Long id, Long cid, String dataStr, String massage, Byte reformItemSourceType) {
        Date date = DateUtils.parseDate((Object)dataStr);
        BxFxhj bxFxhj = new BxFxhj();
        bxFxhj.setId(id);
        bxFxhj.setCid(cid);
        bxFxhj.setRiskName(massage);
        bxFxhj.setFindTime(DateUtils.parseDate((Object)dataStr));
        bxFxhj.setRiskType(Integer.valueOf(89));
        bxFxhj.setRiskDesc(massage);
        bxFxhj.setStatus(Integer.valueOf(0));
        bxFxhj.setReformItemSource(Integer.valueOf(56));
        bxFxhj.setCreateDate(date);
        bxFxhj.setUpdateDate(date);
        this.dao.addBxFxhj(bxFxhj);
        ReformItemBasic basic = new ReformItemBasic();
        basic.setId(id);
        basic.setCid(cid);
        basic.setFindTime(DateUtils.parseDate((Object)dataStr));
        basic.setFindTimeYear(Integer.valueOf(DateUtils.getYear((String)dataStr)));
        basic.setName(massage);
        basic.setReformItemSource(Byte.valueOf((byte)56));
        basic.setReformItemSourceId(id);
        basic.setReformItemSourceMult("56");
        basic.setGenerationSource(Byte.valueOf((byte)21));
        basic.setDescription(massage);
        basic.setStatus(Byte.valueOf((byte)1));
        basic.setDataSource(Byte.valueOf((byte)10));
        basic.setBatchNum(Integer.valueOf(1));
        basic.setReformItemSourceType(reformItemSourceType);
        basic.setCreateDate(date);
        basic.setUpdateDate(date);
        this.dao.addReformItemBasic(basic);
        ReformItemSource source = new ReformItemSource();
        BeanUtils.copyProperties((Object)basic, (Object)source);
        source.setReformItemId(basic.getId());
        this.dao.addReformItemSource(source);
        ReformItemAcceptanceRecord record = new ReformItemAcceptanceRecord();
        record.setId(id);
        record.setReformItemId(basic.getId());
        record.setCid(cid);
        record.setStatus(Byte.valueOf((byte)0));
        record.setCreateDate(date);
        record.setUpdateDate(date);
        this.dao.addReformItemAcceptanceRecord(record);
    }

    @Transactional(readOnly=false)
    public void delOnlineRisk() {
        List<Long> idList = List.of(Long.valueOf(1820731941121581058L), Long.valueOf(1820731941121581059L), Long.valueOf(1820731941121581060L));
        this.dao.delOnlineRisk("bx_fxhj", idList);
        this.dao.delOnlineRisk("bx_risk_report", idList);
        this.dao.delOnlineRisk("reform_item_basic", idList);
        this.dao.delOnlineRisk("reform_item_source", idList);
        this.dao.delOnlineRisk("reform_item_acceptance_record", idList);
        this.dao.delOnlineRisk("reform_check_measure", idList);
    }

    @Transactional(readOnly=false)
    public void delOnlineRisk2() {
        this.dao.delOnlineRisk2("bx_fxhj");
        this.dao.delOnlineRisk2("bx_risk_report");
        this.dao.delOnlineRisk2("reform_item_basic");
        this.dao.delOnlineRisk2("reform_item_source");
    }

    @Transactional
    public void riskData(String type, String operate) {
        Date date = new Date();
        String dataStr = DateUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        switch (operate) {
            case "addRisk": {
                if (type.equals("check")) {
                    this.dao.generateCheckRisk("reform_item_basic", dataStr);
                    this.dao.generateCheckRisk("reform_item_source", dataStr);
                    this.dao.generateCheckRisk("reform_item_acceptance_record", dataStr);
                    break;
                }
                if (type.equals("train")) {
                    this.dao.generateTrainRisk("reform_item_basic", dataStr);
                    this.dao.generateTrainRisk("reform_item_source", dataStr);
                    this.dao.generateTrainRisk("reform_item_acceptance_record", dataStr);
                    break;
                }
                if (!type.equals("phy")) break;
                this.dao.generatePhyRisk("reform_item_basic", dataStr);
                this.dao.generatePhyRisk("reform_item_source", dataStr);
                this.dao.generatePhyRisk("reform_item_acceptance_record", dataStr);
                break;
            }
            case "delRisk": {
                if (type.equals("check")) {
                    this.dao.delRiskById("reform_item_basic", 1820391799026610177L);
                    this.dao.delRiskById("reform_item_source", 1820391799026610177L);
                    this.dao.delRiskById("reform_item_acceptance_record", 1820391784258465793L);
                    break;
                }
                if (type.equals("train")) {
                    this.dao.delRiskById("reform_item_basic", 1820391799026610178L);
                    this.dao.delRiskById("reform_item_source", 1820391799026610178L);
                    this.dao.delRiskById("reform_item_acceptance_record", 1820391784258465794L);
                    break;
                }
                if (!type.equals("phy")) break;
                this.dao.delRiskById("reform_item_basic", 1820391799026610179L);
                this.dao.delRiskById("reform_item_source", 1820391799026610179L);
                this.dao.delRiskById("reform_item_acceptance_record", 1820391784258465795L);
                break;
            }
            case "addData": {
                if (type.equals("check")) {
                    this.dao.updateData("risk_expose_evaluate", 1);
                    this.dao.updateData("check_plan", 1);
                    break;
                }
                if (type.equals("train")) {
                    this.dao.updateData("certificate_staff_detail", 1);
                    break;
                }
                if (!type.equals("phy")) break;
                this.dao.updateData("phc_physical_check_v3221", 1);
                break;
            }
            case "delData": {
                if (type.equals("check")) {
                    this.dao.updateData("risk_expose_evaluate", 0);
                    this.dao.updateData("check_plan", 0);
                    break;
                }
                if (type.equals("train")) {
                    this.dao.updateData("certificate_staff_detail", 0);
                    break;
                }
                if (!type.equals("phy")) break;
                this.dao.updateData("phc_physical_check_v3221", 0);
                break;
            }
        }
    }
}

